/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import java.util.Objects;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;

public final class SpongeNoiseConfig {
    private SpongeNoiseConfig() {
    }

    public static final class BuilderImpl
    implements NoiseConfig.Builder {
        public int minY;
        public int height;
        public int horizontalSize;
        public int verticalSize;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseConfig.Builder minY(int minY) {
            this.minY = minY;
            return this;
        }

        @Override
        public NoiseConfig.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public NoiseConfig.Builder horizontalSize(int horizontal) {
            this.horizontalSize = horizontal;
            return this;
        }

        @Override
        public NoiseConfig.Builder verticalSize(int vertical) {
            this.verticalSize = vertical;
            return this;
        }

        @Override
        public NoiseConfig.Builder reset() {
            this.minY = -64;
            this.height = 384;
            this.horizontalSize = 1;
            this.verticalSize = 2;
            return this;
        }

        @Override
        public NoiseConfig.Builder from(NoiseConfig value) {
            Objects.requireNonNull(value, "value");
            this.minY = value.minY();
            this.height = value.height();
            this.horizontalSize = value.horizontalSize();
            this.verticalSize = value.verticalSize();
            return this;
        }

        public @NonNull NoiseConfig build() {
            return (NoiseConfig)NoiseSettings.create((int)this.minY, (int)this.height, (int)this.horizontalSize, (int)this.verticalSize);
        }
    }
}

