/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.mojang.datafixers.DataFixer;
import io.leangen.geantyref.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.persistence.schematic.SchematicUpdater1_to_2;
import org.spongepowered.common.data.persistence.schematic.SchematicUpdater2_to_3;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.schematic.SpongeSchematicBuilder;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SchematicTranslator
implements DataTranslator<Schematic> {
    private static final SchematicTranslator INSTANCE = new SchematicTranslator();
    private static final TypeToken<Schematic> TYPE_TOKEN = TypeToken.get(Schematic.class);
    private static final ConcurrentSkipListSet<String> MISSING_MOD_IDS = new ConcurrentSkipListSet();
    private static final DataContentUpdater V1_TO_2 = new SchematicUpdater1_to_2();
    private static final DataContentUpdater V2_TO_3 = new SchematicUpdater2_to_3();
    private static @Nullable DataFixer VANILLA_FIXER;

    public static SchematicTranslator get() {
        return INSTANCE;
    }

    private SchematicTranslator() {
    }

    @Override
    public TypeToken<Schematic> token() {
        return TYPE_TOKEN;
    }

    @Override
    public Schematic translate(DataView unprocessed) throws InvalidDataException {
        DataView updatedView;
        boolean needsFixers;
        DataView schematicView;
        int version;
        if (VANILLA_FIXER == null) {
            VANILLA_FIXER = SpongeCommon.server().getFixerUpper();
        }
        if ((version = (schematicView = unprocessed.getView(Constants.Sponge.Schematic.SCHEMATIC).orElse(unprocessed)).getInt(Constants.Sponge.Schematic.VERSION).get().intValue()) > 3) {
            throw new InvalidDataException(String.format("Unknown schematic version %d (current version is %d)", version, 3));
        }
        if (version == 1) {
            V2_TO_3.update(V1_TO_2.update(schematicView));
        } else if (version == 2) {
            V2_TO_3.update(schematicView);
        }
        int dataVersion = schematicView.getInt(Constants.Sponge.Schematic.DATA_VERSION).get();
        boolean bl = needsFixers = dataVersion < SharedConstants.getCurrentVersion().getWorldVersion() && VANILLA_FIXER != null;
        if (needsFixers) {
            CompoundTag compound = NBTTranslator.INSTANCE.translate(schematicView);
            CompoundTag updated = NbtUtils.update((DataFixer)VANILLA_FIXER, (DataFixTypes)DataFixTypes.CHUNK, (CompoundTag)compound, (int)dataVersion);
            updatedView = NBTTranslator.INSTANCE.translate(updated);
        } else {
            updatedView = schematicView;
        }
        SpongeSchematicBuilder builder = new SpongeSchematicBuilder();
        Optional<DataView> metadataView = updatedView.getView(Constants.Sponge.Schematic.METADATA);
        metadataView.ifPresent(metadata -> {
            metadata.getView(DataQuery.of(".")).ifPresent(data -> {
                for (DataQuery key : data.keys(false)) {
                    if (metadata.contains(key)) continue;
                    metadata.set(key, data.get(key).get());
                }
            });
            String schematicName = metadata.getString(Constants.Sponge.Schematic.NAME).orElse("unknown");
            metadata.getStringList(Constants.Sponge.Schematic.REQUIRED_MODS).ifPresent(mods -> {
                for (String modId : mods) {
                    if (Sponge.pluginManager().plugin(modId).isPresent() || !MISSING_MOD_IDS.add(modId)) continue;
                    SpongeCommon.logger().warn("When attempting to load the Schematic: {} there is a missing modid {} some blocks/tiles/entities may not load correctly.", (Object)schematicName, (Object)modId);
                }
            });
            DataContainer meta = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
            for (DataQuery key : metadata.keys(false)) {
                meta.set(key, metadata.get(key).get());
            }
            builder.metadata(meta);
        });
        short width = updatedView.getShort(Constants.Sponge.Schematic.WIDTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + Constants.Sponge.Schematic.WIDTH));
        short height = updatedView.getShort(Constants.Sponge.Schematic.HEIGHT).orElseThrow(() -> new InvalidDataException("Missing value for: " + Constants.Sponge.Schematic.HEIGHT));
        short length = updatedView.getShort(Constants.Sponge.Schematic.LENGTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + Constants.Sponge.Schematic.LENGTH));
        if (width <= 0 || height <= 0 || length <= 0) {
            throw new InvalidDataException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, (int)height, (int)length, 65535));
        }
        int[] offsetArray = (int[])updatedView.get(Constants.Sponge.Schematic.OFFSET).orElse(new int[3]);
        if (offsetArray.length != 3) {
            throw new InvalidDataException("Schematic offset was not of length 3");
        }
        Vector3i offset = new Vector3i(offsetArray[0], offsetArray[1], offsetArray[2]);
        SpongeArchetypeVolume archetypeVolume = new SpongeArchetypeVolume(offset, new Vector3i((int)width, (int)height, (int)length), Sponge.server());
        updatedView.getView(Constants.Sponge.Schematic.BLOCK_CONTAINER).ifPresent(blocks -> SchematicTranslator.deserializeBlockContainer(blocks, archetypeVolume, width, length, offset, needsFixers));
        updatedView.getView(Constants.Sponge.Schematic.BIOME_CONTAINER).ifPresent(biomes -> SchematicTranslator.deserializeBiomeContainer(biomes, archetypeVolume, width, length, offset));
        updatedView.getViewList(Constants.Sponge.Schematic.ENTITIES).map(Collection::stream).orElse(Stream.of(new DataView[0])).filter(entity -> entity.contains(Constants.Sponge.Schematic.ENTITIES_POS, Constants.Sponge.Schematic.ENTITIES_ID)).map(SchematicTranslator.deserializeEntityArchetype()).filter(Optional::isPresent).map(Optional::get).forEach(archetypeVolume::addEntity);
        builder.volume(archetypeVolume);
        return builder.build();
    }

    private static Function<DataView, Optional<EntityArchetypeEntry>> deserializeEntityArchetype() {
        return view -> {
            String typeId = view.getString(Constants.Sponge.Schematic.ENTITIES_ID).get();
            ResourceKey key = ResourceKey.resolve(typeId);
            Optional<@NonNull V> entityType = Sponge.game().registry(RegistryTypes.ENTITY_TYPE).findValue(key);
            return entityType.map(type -> {
                List<Double> pos = view.getDoubleList(Constants.Sponge.Schematic.ENTITIES_POS).orElseThrow(() -> new IllegalStateException("Schematic not abiding by format, all Entities must have an x y z pos"));
                EntityArchetype.Builder builder = SpongeEntityArchetypeBuilder.pooled().type((EntityType<?>)type);
                view.getView(Constants.Sponge.Schematic.BLOCKENTITY_DATA).ifPresent(builder::entityData);
                Vector3d entityPosition = new Vector3d(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue());
                return EntityArchetypeEntry.of(builder.build(), entityPosition);
            });
        };
    }

    @NotNull
    private static Consumer<DataView> deserializeBlockEntities(Vector3i offset, SpongeArchetypeVolume archetypeVolume, boolean needsFixers) {
        return blockEntityData -> {
            int[] pos = (int[])blockEntityData.get(Constants.Sponge.Schematic.BLOCKENTITY_POS).orElseThrow(() -> new IllegalStateException("Schematic not abiding by format, all BlockEntities must have an x y z pos"));
            blockEntityData.getString(Constants.Sponge.Schematic.BLOCKENTITY_ID).map(ResourceKey::resolve).map(key -> Sponge.game().registry(RegistryTypes.BLOCK_ENTITY_TYPE).findValue((ResourceKey)key)).filter(Optional::isPresent).map(Optional::get).ifPresent(type -> {
                int x = pos[0] - offset.x();
                int y = pos[1] - offset.y();
                int z = pos[2] - offset.z();
                BlockEntityArchetype.Builder builder = SpongeBlockEntityArchetypeBuilder.pooled().state(archetypeVolume.block(x, y, z)).blockEntity((BlockEntityType)type);
                blockEntityData.getView(Constants.Sponge.Schematic.BLOCKENTITY_DATA).ifPresent(builder::blockEntityData);
                archetypeVolume.addBlockEntity(x, y, z, builder.build());
            });
        };
    }

    private static void deserializeBlockContainer(DataView view, SpongeArchetypeVolume archetypeVolume, int width, int length, Vector3i offset, boolean needsFixers) {
        DataView paletteMap = view.getView(Constants.Sponge.Schematic.BLOCK_PALETTE).orElseThrow(() -> new InvalidDataException("Missing BlockPalette as required by Schematic Specification"));
        Set<DataQuery> paletteKeys = paletteMap.keys(false);
        MutableBimapPalette<BlockState, BlockType> palette = new MutableBimapPalette<BlockState, BlockType>(PaletteTypes.BLOCK_STATE_PALETTE.get(), Sponge.game().registry(RegistryTypes.BLOCK_TYPE), RegistryTypes.BLOCK_TYPE, paletteKeys.size());
        for (DataQuery key : paletteKeys) {
            BlockState state = BlockStateSerializerDeserializer.deserialize(key.parts().get(0)).orElseGet(() -> (BlockState)BlockTypes.BEDROCK.get().defaultState());
            palette.assign(state, paletteMap.getInt(key).orElseThrow(() -> new IllegalStateException("Somehow got a missing biome in the palette map for schematic")));
        }
        byte[] blockData = (byte[])view.get(Constants.Sponge.Schematic.BLOCK_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
        SchematicTranslator.readByteArrayData(width, width * length, offset, palette, blockData, archetypeVolume, BlockVolume.Modifiable::setBlock);
        view.getViewList(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER).ifPresent(tileData -> tileData.forEach(SchematicTranslator.deserializeBlockEntities(offset, archetypeVolume, needsFixers)));
    }

    private static void deserializeBiomeContainer(DataView view, SpongeArchetypeVolume archetypeVolume, int width, int length, Vector3i offset) {
        DataView biomeMap = view.getView(Constants.Sponge.Schematic.BIOME_PALETTE).orElseThrow(() -> new InvalidDataException("Missing BiomePalette as required by the schematic spec"));
        Set<DataQuery> biomeKeys = biomeMap.keys(false);
        Registry biomeRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().registryAccess().registryOrThrow(Registries.BIOME));
        MutableBimapPalette<Biome, Biome> biomePalette = new MutableBimapPalette<Biome, Biome>(PaletteTypes.BIOME_PALETTE.get(), biomeRegistry, RegistryTypes.BIOME, biomeKeys.size());
        for (DataQuery biomeKey : biomeKeys) {
            ResourceKey key = ResourceKey.resolve(biomeKey.parts().get(0));
            Biome biome = (Biome)biomeRegistry.findValue(key).get();
            biomePalette.assign(biome, biomeMap.getInt(biomeKey).get());
        }
        byte[] biomeData = (byte[])view.get(Constants.Sponge.Schematic.BIOME_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
        SchematicTranslator.readByteArrayData(width, width * length, offset, biomePalette, biomeData, archetypeVolume, BiomeVolume.Modifiable::setBiome);
    }

    private static <Buffer, Type, ParentType> void readByteArrayData(int width, int i1, Vector3i offset, Palette<Type, ParentType> palette, byte[] data, Buffer buffer, PostSetter<Buffer, Type> setter) {
        int index = 0;
        int i = 0;
        int value = 0;
        int varint_length = 0;
        while (i < data.length) {
            value = 0;
            varint_length = 0;
            while (true) {
                value |= (data[i] & 0x7F) << varint_length++ * 7;
                if (varint_length > 5) {
                    throw new RuntimeException("VarInt too big (probably corrupted data)");
                }
                if ((data[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / i1;
            int z = index % i1 / width;
            int x = index % i1 % width;
            Type state = palette.get(value, Sponge.game()).get();
            setter.apply(buffer, x + offset.x(), y + offset.y(), z + offset.z(), state);
            ++index;
        }
    }

    @Override
    public DataContainer translate(Schematic schematic) throws InvalidDataException {
        DataContainer data = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        DataView view = data.createView(Constants.Sponge.Schematic.SCHEMATIC);
        this.addTo(schematic, view);
        return data;
    }

    @Override
    public DataView addTo(Schematic schematic, DataView data) {
        DataHolder state;
        int x0;
        int x;
        int z0;
        int z;
        int y0;
        ByteArrayOutputStream buffer2;
        int xMin = schematic.min().x();
        int yMin = schematic.min().y();
        int zMin = schematic.min().z();
        int width = schematic.size().x();
        int height = schematic.size().y();
        int length = schematic.size().z();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new IllegalArgumentException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        data.set(Constants.Sponge.Schematic.WIDTH, (short)width);
        data.set(Constants.Sponge.Schematic.HEIGHT, (short)height);
        data.set(Constants.Sponge.Schematic.LENGTH, (short)length);
        data.set(Constants.Sponge.Schematic.VERSION, 3);
        data.set(Constants.Sponge.Schematic.DATA_VERSION, SharedConstants.getCurrentVersion().getWorldVersion());
        for (DataQuery metaKey : schematic.metadata().keys(false)) {
            data.set(Constants.Sponge.Schematic.METADATA.then(metaKey), schematic.metadata().get(metaKey).get());
        }
        HashSet<String> requiredMods = new HashSet<String>();
        int[] offset = new int[]{xMin, yMin, zMin};
        data.set(Constants.Sponge.Schematic.OFFSET, offset);
        if (schematic.blockPalette().highestId() != 0) {
            DataView blockData = data.createView(Constants.Sponge.Schematic.BLOCK_CONTAINER);
            Palette.Mutable<BlockState, BlockType> palette = schematic.blockPalette().asMutable(Sponge.server());
            try {
                buffer2 = new ByteArrayOutputStream(width * height * length);
                try {
                    for (int y = 0; y < height; ++y) {
                        y0 = yMin + y;
                        for (z = 0; z < length; ++z) {
                            z0 = zMin + z;
                            for (x = 0; x < width; ++x) {
                                x0 = xMin + x;
                                state = schematic.block(x0, y0, z0);
                                SchematicTranslator.writeIdToBuffer(buffer2, palette.orAssign((BlockState)state));
                            }
                        }
                    }
                    blockData.set(Constants.Sponge.Schematic.BLOCK_DATA, buffer2.toByteArray());
                }
                finally {
                    buffer2.close();
                }
            }
            catch (IOException buffer2) {
                // empty catch block
            }
            Registry blockRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().registryAccess().registryOrThrow(Registries.BLOCK));
            SchematicTranslator.writePaletteToView(blockData, palette, blockRegistry, Constants.Sponge.Schematic.BLOCK_PALETTE, BlockState::type, requiredMods);
            List blockEntities = schematic.blockEntityArchetypes().entrySet().stream().map(entry -> {
                DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
                Vector3i pos = (Vector3i)entry.getKey();
                BlockEntityArchetype archetype = (BlockEntityArchetype)entry.getValue();
                DataContainer entityData = archetype.blockEntityData();
                int[] apos = new int[]{pos.x() - xMin, pos.y() - yMin, pos.z() - zMin};
                container.set(Constants.Sponge.Schematic.BLOCKENTITY_POS, apos);
                container.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, entityData);
                ResourceKey key = archetype.blockEntityType().key(RegistryTypes.BLOCK_ENTITY_TYPE);
                container.set(Constants.Sponge.Schematic.ENTITIES_ID, key.asString());
                String namespace = key.namespace();
                if (!"minecraft".equals(namespace)) {
                    requiredMods.add(namespace);
                }
                return container;
            }).collect(Collectors.toList());
            blockData.set(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER, blockEntities);
        }
        if (schematic.biomePalette().highestId() != 0) {
            DataView biomeContainer = data.createView(Constants.Sponge.Schematic.BIOME_CONTAINER);
            Palette.Mutable<Biome, Biome> biomePalette = schematic.biomePalette().asMutable(Sponge.game());
            try {
                buffer2 = new ByteArrayOutputStream(width * height * length);
                try {
                    for (int y = 0; y < height; ++y) {
                        y0 = yMin + y;
                        for (z = 0; z < length; ++z) {
                            z0 = zMin + z;
                            for (x = 0; x < width; ++x) {
                                x0 = xMin + x;
                                state = schematic.biome(x0, y0, z0);
                                SchematicTranslator.writeIdToBuffer(buffer2, biomePalette.orAssign((Biome)state));
                            }
                        }
                    }
                    biomeContainer.set(Constants.Sponge.Schematic.BIOME_DATA, buffer2.toByteArray());
                }
                finally {
                    buffer2.close();
                }
            }
            catch (IOException buffer3) {
                // empty catch block
            }
            Registry biomeRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().registryAccess().registryOrThrow(Registries.BIOME));
            SchematicTranslator.writePaletteToView(biomeContainer, biomePalette, biomeRegistry, Constants.Sponge.Schematic.BIOME_PALETTE, Function.identity(), requiredMods);
        }
        List entities = schematic.entityArchetypesByPosition().stream().map(entry -> {
            DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
            ArrayList<Double> entityPosition = new ArrayList<Double>();
            entityPosition.add(entry.position().x());
            entityPosition.add(entry.position().y());
            entityPosition.add(entry.position().z());
            container.set(Constants.Sponge.Schematic.ENTITIES_POS, entityPosition);
            ResourceKey key = entry.archetype().type().key(RegistryTypes.ENTITY_TYPE);
            if (!"minecraft".equals(key.namespace())) {
                requiredMods.add(key.namespace());
            }
            container.set(Constants.Sponge.Schematic.ENTITIES_ID, key.toString());
            DataContainer entityData = entry.archetype().entityData();
            container.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, entityData);
            return container;
        }).collect(Collectors.toList());
        data.set(Constants.Sponge.Schematic.ENTITIES, entities);
        if (!requiredMods.isEmpty()) {
            data.set(Constants.Sponge.Schematic.METADATA.then(Constants.Sponge.Schematic.REQUIRED_MODS), requiredMods);
        }
        return data;
    }

    private static <T, P> void writePaletteToView(DataView view, Palette.Mutable<T, P> palette, Registry<P> parentRegistryType, DataQuery paletteQuery, Function<T, P> parentGetter, Set<String> requiredMods) {
        palette.streamWithIds().forEach(entry -> {
            String stringified = palette.type().stringifier().apply(parentRegistryType, (Registry)entry.getKey());
            view.set(paletteQuery.then(stringified), entry.getValue());
            ResourceKey blockKey = parentRegistryType.findValueKey(parentGetter.apply(entry.getKey())).orElseThrow(() -> new IllegalStateException("Somehow have a BlockState that is not registered in the global BlockType registry"));
            if (!"minecraft".equals(blockKey.namespace())) {
                requiredMods.add(blockKey.namespace());
            }
        });
    }

    public static void writeIdToBuffer(ByteArrayOutputStream buffer, int orAssign) {
        int id = orAssign;
        while ((id & 0xFFFFFF80) != 0) {
            buffer.write(id & 0x7F | 0x80);
            id >>>= 7;
        }
        buffer.write(id);
    }

    static interface PostSetter<V, T> {
        public void apply(V var1, int var2, int var3, int var4, T var5);
    }
}

