/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch;

import com.google.inject.Injector;
import com.google.inject.Stage;
import net.minecraft.SharedConstants;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeLifecycle;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.packet.SpongePacketHandler;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;
import org.spongepowered.vanilla.launch.plugin.VanillaPluginManager;

public final class VanillaBootstrap {
    public static void perform(String engineName, Runnable engineStart) {
        SharedConstants.tryDetectVersion();
        Stage stage = SpongeGuice.getInjectorStage(((Launch)Launch.instance()).injectionStage());
        SpongeCommon.logger().debug("Creating injector in stage '{}'", (Object)stage);
        Injector bootstrapInjector = ((Launch)Launch.instance()).createInjector();
        SpongeLifecycle lifecycle = (SpongeLifecycle)bootstrapInjector.getInstance(SpongeLifecycle.class);
        ((Launch)Launch.instance()).setLifecycle(lifecycle);
        lifecycle.establishFactories();
        lifecycle.establishBuilders();
        ((VanillaPluginManager)((Launch)Launch.instance()).pluginManager()).loadPlugins((VanillaPluginPlatform)((Launch)Launch.instance()).pluginPlatform());
        lifecycle.callConstructEvent();
        lifecycle.callRegisterFactoryEvent();
        lifecycle.callRegisterBuilderEvent();
        lifecycle.callRegisterChannelEvent();
        lifecycle.establishGameServices();
        lifecycle.establishDataKeyListeners();
        SpongePacketHandler.init((SpongeChannelManager)Sponge.channelManager());
        ((Launch)Launch.instance()).logger().info("Loading Minecraft {}, please wait...", (Object)engineName);
        engineStart.run();
    }
}

