/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.profile.GameProfile;

public interface GameProfileProvider {
    public CompletableFuture<GameProfile> basicProfile(UUID var1);

    default public CompletableFuture<GameProfile> basicProfile(String name) {
        return this.basicProfile(name, null);
    }

    public CompletableFuture<GameProfile> basicProfile(String var1, @Nullable Instant var2);

    default public CompletableFuture<Map<String, GameProfile>> basicProfiles(Iterable<String> names) {
        return this.basicProfiles(names, null);
    }

    public CompletableFuture<Map<String, GameProfile>> basicProfiles(Iterable<String> var1, @Nullable Instant var2);

    default public CompletableFuture<GameProfile> profile(GameProfile profile) {
        return this.profile(profile.uniqueId(), true);
    }

    default public CompletableFuture<GameProfile> profile(GameProfile profile, boolean signed) {
        return this.profile(profile.uniqueId(), signed);
    }

    default public CompletableFuture<GameProfile> profile(String name) {
        return this.profile(name, true);
    }

    default public CompletableFuture<GameProfile> profile(UUID uniqueId) {
        return this.profile(uniqueId, true);
    }

    public CompletableFuture<GameProfile> profile(String var1, boolean var2);

    public CompletableFuture<GameProfile> profile(UUID var1, boolean var2);
}

