/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.ArrayList;
import java.util.List;
import java.util.random.RandomGenerator;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.RandomObjectTable;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;

public class ChanceTable<T>
extends RandomObjectTable<T> {
    public ChanceTable() {
        super(1);
    }

    public ChanceTable(int rolls) {
        super(rolls);
    }

    @Override
    public List<T> get(RandomGenerator rand) {
        ArrayList results = new ArrayList();
        if (this.entries.isEmpty()) {
            return results;
        }
        int rolls = this.rolls().flooredAmount(rand);
        for (int i = 0; i < rolls; ++i) {
            for (TableEntry next : this.entries) {
                if (!(rand.nextDouble() < next.weight())) continue;
                if (next instanceof NestedTableEntry) {
                    results.addAll(((NestedTableEntry)next).get(rand));
                    continue;
                }
                if (!(next instanceof WeightedObject)) continue;
                results.add(((WeightedObject)next).get());
            }
        }
        return results;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChanceTable)) {
            return false;
        }
        ChanceTable c = (ChanceTable)o;
        if (this.rolls() != c.rolls()) {
            return false;
        }
        if (this.entries.size() != c.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (((TableEntry)this.entries.get(i)).equals(c.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int r = 1;
        r = r * 37 + this.rolls().hashCode();
        for (TableEntry entry : this.entries) {
            r = r * 37 + entry.hashCode();
        }
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("ChanceTable (rolls=").append(this.rolls());
        r.append(",entries=").append(this.entries.size()).append(") {\n");
        for (TableEntry entry : this.entries) {
            r.append("\t").append(entry.toString()).append("\n");
        }
        r.append("}");
        return r.toString();
    }
}

