/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;

public final class SpongeCommandCauseFactory
implements CommandCause.Factory {
    @Override
    public @NonNull CommandCause create() {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            CommandSourceStack commandSource;
            Cause cause = frame.currentCause();
            CommandSource iCommandSource = cause.first(CommandSource.class).orElseGet(() -> SpongeCommon.game().systemSubject());
            if (iCommandSource instanceof CommandSourceProviderBridge) {
                commandSource = ((CommandSourceProviderBridge)iCommandSource).bridge$getCommandSource(cause);
            } else {
                Locatable locatable;
                EventContext context = cause.context();
                Locatable locatable2 = locatable = iCommandSource instanceof Locatable ? (Locatable)iCommandSource : null;
                Object displayName = iCommandSource instanceof Entity ? ((Entity)iCommandSource).get(Keys.DISPLAY_NAME).map(SpongeAdventure::asVanilla).orElseGet(() -> Component.literal((String)(iCommandSource instanceof Nameable ? ((Nameable)iCommandSource).name() : iCommandSource.getClass().getSimpleName()))) : Component.literal((String)(iCommandSource instanceof Nameable ? ((Nameable)iCommandSource).name() : iCommandSource.getClass().getSimpleName()));
                String name = displayName.getString();
                commandSource = new CommandSourceStack(iCommandSource, context.get(EventContextKeys.LOCATION).map(x -> VecHelper.toVanillaVector3d(x.position())).orElseGet(() -> locatable == null ? Vec3.ZERO : VecHelper.toVanillaVector3d(locatable.location().position())), context.get(EventContextKeys.ROTATION).map(rot -> new Vec2((float)rot.x(), (float)rot.y())).orElse(Vec2.ZERO), context.get(EventContextKeys.LOCATION).map(x -> (ServerLevel)x.world()).orElseGet(() -> locatable == null ? SpongeCommon.server().getLevel(Level.OVERWORLD) : (ServerLevel)locatable.serverLocation().world()), 4, name, (Component)displayName, SpongeCommon.server(), iCommandSource instanceof Entity ? (net.minecraft.world.entity.Entity)iCommandSource : null);
            }
            ((CommandSourceStackBridge)commandSource).bridge$setCause(frame.currentCause());
            CommandCause commandCause = (CommandCause)commandSource;
            return commandCause;
        }
    }
}

