/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.World;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.BaseConfig;
import org.spongepowered.common.config.inheritable.GlobalConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.config.tracker.TrackerConfig;

public final class SpongeGameConfigs {
    static final Logger LOGGER = LogManager.getLogger();
    private static final Lock initLock = new ReentrantLock();
    private static ConfigHandle<TrackerConfig> trackerConfigAdapter;
    private static volatile InheritableConfigHandle<GlobalConfig> global;

    private SpongeGameConfigs() {
    }

    public static ConfigHandle<TrackerConfig> getTracker() {
        if (trackerConfigAdapter == null) {
            trackerConfigAdapter = SpongeConfigs.create(TrackerConfig.class, null, "tracker.conf");
        }
        return trackerConfigAdapter;
    }

    public static InheritableConfigHandle<WorldConfig> getForWorld(World<?, ?> spongeWorld) {
        return SpongeGameConfigs.getForWorld((Level)spongeWorld);
    }

    public static InheritableConfigHandle<WorldConfig> getForWorld(Level mcWorld) {
        return ((PrimaryLevelDataBridge)mcWorld.getLevelData()).bridge$configAdapter();
    }

    public static boolean doesWorldConfigExist(ResourceKey world) {
        Path configPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", world.namespace(), world.value() + ".conf"));
        return Files.exists(configPath, new LinkOption[0]);
    }

    public static InheritableConfigHandle<WorldConfig> createWorld(@Nullable ResourceKey dimensionTypeKey, ResourceKey world) {
        Path legacyPath;
        String legacyName;
        Path configPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", world.namespace(), world.value() + ".conf"));
        if (dimensionTypeKey != null && (legacyName = SpongeGameConfigs.getLegacyWorldName(world)) != null && (legacyPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", dimensionTypeKey.namespace(), SpongeGameConfigs.getLegacyValue(dimensionTypeKey), legacyName, "world.conf"))).toFile().isFile() && !configPath.toFile().isFile()) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.move(legacyPath, configPath, new CopyOption[0]);
                Path legacyParent = legacyPath.getParent();
                try (DirectoryStream<Path> str = Files.newDirectoryStream(legacyParent);){
                    if (!str.iterator().hasNext()) {
                        Files.delete(legacyParent);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to migrate config for world {} from legacy location {}", (Object)world, (Object)legacyPath, (Object)ex);
            }
        }
        try {
            InheritableConfigHandle<WorldConfig> config = new InheritableConfigHandle<WorldConfig>(WorldConfig.class, BaseConfig::transformation, SpongeConfigs.createLoader(configPath), SpongeGameConfigs.getGlobalInheritable());
            config.load();
            return config;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load configuration for world {}. Sponge will use a fallback configuration with default values that will not save.", (Object)world, (Object)ex);
            return SpongeGameConfigs.createDetached();
        }
    }

    private static String getLegacyValue(ResourceKey dimensionType) {
        if (dimensionType.equals(Level.NETHER.location())) {
            return "nether";
        }
        return dimensionType.value();
    }

    private static @Nullable String getLegacyWorldName(ResourceKey world) {
        if (world.equals(Level.OVERWORLD.location())) {
            return "world";
        }
        if (world.equals(Level.END.location())) {
            return "DIM1";
        }
        if (world.equals(Level.NETHER.location())) {
            return "DIM-1";
        }
        return null;
    }

    public static InheritableConfigHandle<GlobalConfig> getGlobalInheritable() {
        if (global == null) {
            initLock.lock();
            try {
                if (global == null) {
                    try {
                        global = new InheritableConfigHandle<GlobalConfig>(GlobalConfig.class, BaseConfig::transformation, SpongeConfigs.createLoader(SpongeConfigs.getDirectory().resolve("global.conf")), null);
                        global.load();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to load global world configuration in {}. Sponge will run with default settings", (Object)"global.conf", (Object)e);
                        global = new InheritableConfigHandle<GlobalConfig>(GlobalConfig.class, null);
                    }
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return global;
    }

    public static InheritableConfigHandle<WorldConfig> createDetached() {
        return new InheritableConfigHandle<WorldConfig>(WorldConfig.class, SpongeGameConfigs.getGlobalInheritable());
    }
}

