/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.data.DataSerializer;
import org.spongepowered.common.data.MemoryDataContainer;
import org.spongepowered.common.data.builder.Coerce;
import org.spongepowered.common.registry.provider.KeyProvider;

public class MemoryDataView
implements DataView {
    protected final Map<String, Object> map = Maps.newLinkedHashMap();
    private final DataContainer container;
    private final DataView parent;
    private final DataQuery path;
    private final DataView.SafetyMode safety;

    MemoryDataView(DataView.SafetyMode safety) {
        Preconditions.checkState((boolean)(this instanceof DataContainer), (Object)"Cannot construct a root MemoryDataView without a container!");
        this.path = DataQuery.of();
        this.parent = this;
        this.container = (DataContainer)((Object)this);
        this.safety = Objects.requireNonNull(safety, "Safety mode");
    }

    private MemoryDataView(DataView parent, DataQuery path, DataView.SafetyMode safety) {
        Preconditions.checkArgument((path.parts().size() >= 1 ? 1 : 0) != 0, (Object)"Path must have at least one part");
        this.parent = parent;
        this.container = parent.container();
        this.path = parent.currentPath().then(path);
        this.safety = Objects.requireNonNull(safety, "Safety mode");
    }

    @Override
    public DataContainer container() {
        return this.container;
    }

    @Override
    public DataQuery currentPath() {
        return this.path;
    }

    @Override
    public String name() {
        List<String> parts = this.path.parts();
        return parts.isEmpty() ? "" : parts.get(parts.size() - 1);
    }

    @Override
    public Optional<DataView> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Set<DataQuery> keys(boolean deep) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            builder.add((Object)DataQuery.of(entry.getKey()));
        }
        if (deep) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                if (!(entry.getValue() instanceof DataView)) continue;
                for (DataQuery query : ((DataView)entry.getValue()).keys(true)) {
                    builder.add((Object)DataQuery.of(entry.getKey()).then(query));
                }
            }
        }
        return builder.build();
    }

    @Override
    public Map<DataQuery, Object> values(boolean deep) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataQuery query : this.keys(deep)) {
            Object value = this.get(query).get();
            if (value instanceof DataView) {
                builder.put((Object)query, ((DataView)value).values(deep));
                continue;
            }
            builder.put((Object)query, this.get(query).get());
        }
        return builder.build();
    }

    @Override
    public final boolean contains(DataQuery path) {
        Objects.requireNonNull(path, "path");
        List<String> queryParts = path.parts();
        String key = queryParts.get(0);
        if (queryParts.size() == 1) {
            return this.map.containsKey(key);
        }
        Optional<DataView> subViewOptional = this.getUnsafeView(key);
        return subViewOptional.isPresent() && subViewOptional.get().contains(path.popFirst());
    }

    @Override
    public boolean contains(DataQuery path, DataQuery ... paths) {
        Objects.requireNonNull(path, "DataQuery cannot be null!");
        Objects.requireNonNull(paths, "DataQuery varargs cannot be null!");
        if (paths.length == 0) {
            return this.contains(path);
        }
        ArrayList<DataQuery> queries = new ArrayList<DataQuery>();
        queries.add(path);
        for (DataQuery query : paths) {
            queries.add(Objects.requireNonNull(query, "No null queries!"));
        }
        for (DataQuery query : queries) {
            if (this.contains(query)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<Object> get(DataQuery path) {
        Objects.requireNonNull(path, "path");
        List<String> queryParts = path.parts();
        int sz = queryParts.size();
        if (sz == 0) {
            return Optional.of(this);
        }
        String key = queryParts.get(0);
        if (sz == 1) {
            Object object = this.map.get(key);
            if (object == null) {
                return Optional.empty();
            }
            if (this.safety == DataView.SafetyMode.ALL_DATA_CLONED && object.getClass().isArray()) {
                if (object instanceof byte[]) {
                    return Optional.of(ArrayUtils.clone((byte[])((byte[])object)));
                }
                if (object instanceof short[]) {
                    return Optional.of(ArrayUtils.clone((short[])((short[])object)));
                }
                if (object instanceof int[]) {
                    return Optional.of(ArrayUtils.clone((int[])((int[])object)));
                }
                if (object instanceof long[]) {
                    return Optional.of(ArrayUtils.clone((long[])((long[])object)));
                }
                if (object instanceof float[]) {
                    return Optional.of(ArrayUtils.clone((float[])((float[])object)));
                }
                if (object instanceof double[]) {
                    return Optional.of(ArrayUtils.clone((double[])((double[])object)));
                }
                if (object instanceof boolean[]) {
                    return Optional.of(ArrayUtils.clone((boolean[])((boolean[])object)));
                }
                return Optional.of(ArrayUtils.clone((Object[])((Object[])object)));
            }
            return Optional.of(object);
        }
        Optional<DataView> subViewOptional = this.getUnsafeView(key);
        if (!subViewOptional.isPresent()) {
            return Optional.empty();
        }
        DataView subView = subViewOptional.get();
        return subView.get(path.popFirst());
    }

    @Override
    public DataView set(DataQuery path, Object value) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(value, "value");
        Preconditions.checkState((this.container != null ? 1 : 0) != 0);
        Preconditions.checkState((!path.parts().isEmpty() ? 1 : 0) != 0, (Object)"The path is empty");
        Preconditions.checkArgument((value != this ? 1 : 0) != 0, (Object)"Cannot set a DataView to itself.");
        List<String> parts = path.parts();
        String key = parts.get(0);
        if (parts.size() > 1) {
            DataView subView;
            DataQuery subQuery = DataQuery.of(key);
            Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
            if (!subViewOptional.isPresent()) {
                this.createView(subQuery);
                subView = (DataView)this.map.get(key);
            } else {
                subView = subViewOptional.get();
            }
            subView.set(path.popFirst(), value);
            return this;
        }
        Object serialized = DataSerializer.serialize(this.safetyMode(), value);
        Preconditions.checkArgument((this.isEmpty() || !this.equals(serialized) ? 1 : 0) != 0, (Object)"Cannot insert self-referencing DataView!");
        if (serialized instanceof DataView) {
            Set<DataQuery> valueKeys = ((DataView)serialized).keys(true);
            for (DataQuery oldKey : valueKeys) {
                this.set(path.then(oldKey), ((DataView)serialized).get(oldKey).get());
            }
        } else {
            this.map.put(key, serialized);
        }
        return this;
    }

    @Override
    public DataView remove(DataQuery path) {
        Objects.requireNonNull(path, "path");
        List<String> parts = path.parts();
        if (parts.size() > 1) {
            String subKey = parts.get(0);
            DataQuery subQuery = DataQuery.of(subKey);
            Optional<DataView> subViewOptional = this.getUnsafeView(subQuery);
            if (!subViewOptional.isPresent()) {
                return this;
            }
            DataView subView = subViewOptional.get();
            subView.remove(path.popFirst());
        } else {
            this.map.remove(parts.get(0));
        }
        return this;
    }

    @Override
    public DataView createView(DataQuery path) {
        Objects.requireNonNull(path, "path");
        List<String> queryParts = path.parts();
        int sz = queryParts.size();
        Preconditions.checkArgument((sz != 0 ? 1 : 0) != 0, (Object)"The size of the query must be at least 1");
        String key = queryParts.get(0);
        DataQuery keyQuery = DataQuery.of(key);
        if (sz == 1) {
            MemoryDataView result = new MemoryDataView(this, keyQuery, this.safety);
            this.map.put(key, result);
            return result;
        }
        DataQuery subQuery = path.popFirst();
        DataView subView = (DataView)this.map.get(key);
        if (subView == null) {
            subView = new MemoryDataView(this.parent, keyQuery, this.safety);
            this.map.put(key, subView);
        }
        return subView.createView(subQuery);
    }

    @Override
    public DataView createView(DataQuery path, Map<?, ?> map) {
        Objects.requireNonNull(path, "path");
        DataView section = this.createView(path);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createView(DataQuery.of('.', entry.getKey().toString()), (Map)entry.getValue());
                continue;
            }
            section.set(DataQuery.of('.', entry.getKey().toString()), entry.getValue());
        }
        return section;
    }

    @Override
    public Optional<DataView> getView(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj);
    }

    @Override
    public Optional<? extends Map<?, ?>> getMap(DataQuery path) {
        Optional<Object> val = this.get(path);
        if (val.isPresent()) {
            if (val.get() instanceof DataView) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<DataQuery, Object> entry : ((DataView)val.get()).values(false).entrySet()) {
                    builder.put((Object)entry.getKey().asString('.'), this.ensureMappingOf(entry.getValue()));
                }
                return Optional.of(builder.build());
            }
            if (val.get() instanceof Map) {
                return Optional.of((Map)this.ensureMappingOf(val.get()));
            }
        }
        return Optional.empty();
    }

    private Object ensureMappingOf(Object object) {
        if (object instanceof DataView) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<DataQuery, Object> entry : ((DataView)object).values(false).entrySet()) {
                builder.put((Object)entry.getKey().asString('.'), this.ensureMappingOf(entry.getValue()));
            }
            return builder.build();
        }
        if (object instanceof Map) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                builder.put((Object)entry.getKey().toString(), this.ensureMappingOf(entry.getValue()));
            }
            return builder.build();
        }
        if (object instanceof Collection) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object entry : (Collection)object) {
                builder.add(this.ensureMappingOf(entry));
            }
            return builder.build();
        }
        return object;
    }

    private Optional<DataView> getUnsafeView(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj);
    }

    private Optional<DataView> getUnsafeView(String path) {
        Object object = this.map.get(path);
        if (!(object instanceof DataView)) {
            return Optional.empty();
        }
        return Optional.of((DataView)object);
    }

    @Override
    public Optional<Boolean> getBoolean(DataQuery path) {
        return this.get(path).flatMap(Coerce::asBoolean);
    }

    @Override
    public Optional<Byte> getByte(DataQuery path) {
        return this.get(path).flatMap(Coerce::asByte);
    }

    @Override
    public Optional<Short> getShort(DataQuery path) {
        return this.get(path).flatMap(Coerce::asShort);
    }

    @Override
    public Optional<Integer> getInt(DataQuery path) {
        return this.get(path).flatMap(Coerce::asInteger);
    }

    @Override
    public Optional<Long> getLong(DataQuery path) {
        return this.get(path).flatMap(Coerce::asLong);
    }

    @Override
    public Optional<Float> getFloat(DataQuery path) {
        return this.get(path).flatMap(Coerce::asFloat);
    }

    @Override
    public Optional<Double> getDouble(DataQuery path) {
        return this.get(path).flatMap(Coerce::asDouble);
    }

    @Override
    public Optional<String> getString(DataQuery path) {
        return this.get(path).flatMap(Coerce::asString);
    }

    @Override
    public Optional<List<?>> getList(DataQuery path) {
        Optional<Object> val = this.get(path);
        if (val.isPresent()) {
            if (val.get() instanceof List) {
                return Optional.of(Lists.newArrayList((Iterable)((List)val.get())));
            }
            if (val.get() instanceof Object[]) {
                return Optional.of(Lists.newArrayList((Object[])((Object[])val.get())));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<List<String>> getStringList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asString).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private Optional<List<?>> getUnsafeList(DataQuery path) {
        return this.get(path).filter(obj -> obj instanceof List || obj instanceof Object[]).map(obj -> {
            if (obj instanceof List) {
                return (List)obj;
            }
            return Arrays.asList((Object[])obj);
        });
    }

    @Override
    public Optional<List<Character>> getCharacterList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asChar).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Boolean>> getBooleanList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asBoolean).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Byte>> getByteList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asByte).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Short>> getShortList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asShort).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Integer>> getIntegerList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asInteger).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Long>> getLongList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asLong).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Float>> getFloatList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asFloat).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Double>> getDoubleList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().map(Coerce::asDouble).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Map<?, ?>>> getMapList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().filter(obj -> obj instanceof Map).map(obj -> (Map)obj).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<DataView>> getViewList(DataQuery path) {
        return this.getUnsafeList(path).map(list -> list.stream().filter(obj -> obj instanceof DataView).map(obj -> (DataView)obj).collect(Collectors.toList()));
    }

    @Override
    public <T extends DataSerializable> Optional<T> getSerializable(DataQuery path, Class<T> clazz) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(clazz, "clazz");
        return this.getUnsafeView(path).flatMap(view -> Sponge.dataManager().builder(clazz).flatMap(builder -> builder.build((DataView)view)));
    }

    @Override
    public <T extends DataSerializable> Optional<List<T>> getSerializableList(DataQuery path, Class<T> clazz) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(clazz, "clazz");
        return Stream.of(() -> this.getViewList(path).flatMap(list -> Sponge.dataManager().builder(clazz).map(builder -> list.stream().map(builder::build).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())))).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public <T> Optional<T> getRegistryValue(DataQuery path, RegistryType<T> registryType, RegistryHolder holder) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(registryType, "registry type");
        return this.getString(path).flatMap(string -> holder.findRegistry(registryType).flatMap(r -> r.findValue(ResourceKey.resolve(string))));
    }

    @Override
    public <T> Optional<List<T>> getRegistryValueList(DataQuery path, RegistryType<T> registryType, RegistryHolder holder) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(registryType, "registry type");
        return this.getStringList(path).map(list -> list.stream().map(string -> holder.findRegistry(registryType).flatMap(r -> r.findValue(ResourceKey.resolve(string)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public <E, V extends Value<E>> Optional<Key<V>> getDataKey(DataQuery path) {
        Objects.requireNonNull(path, "path");
        return this.getResourceKey(path).flatMap(r -> KeyProvider.INSTANCE.get((ResourceKey)r));
    }

    @Override
    public Optional<List<Key<? extends Value<?>>>> getDataKeyList(DataQuery path) {
        Objects.requireNonNull(path, "path");
        Optional<List<ResourceKey>> resourceKeys = this.getResourceKeyList(path);
        if (!resourceKeys.isPresent()) {
            return Optional.empty();
        }
        ArrayList keys = new ArrayList();
        for (ResourceKey resourceKey : resourceKeys.get()) {
            KeyProvider.INSTANCE.get(resourceKey).ifPresent(keys::add);
        }
        if (keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(keys);
    }

    @Override
    public <T> Optional<T> getObject(DataQuery path, Class<T> objectClass) {
        return this.getView(path).flatMap(view -> Sponge.dataManager().translator(objectClass).flatMap(serializer -> Optional.of(serializer.translate((DataView)view))));
    }

    @Override
    public <T> Optional<List<T>> getObjectList(DataQuery path, Class<T> objectClass) {
        return this.getViewList(path).flatMap(viewList -> Sponge.dataManager().translator(objectClass).map(serializer -> viewList.stream().map(serializer::translate).collect(Collectors.toList())));
    }

    @Override
    public DataContainer copy() {
        MemoryDataContainer container = new MemoryDataContainer(this.safety);
        this.keys(false).forEach(query -> this.get((DataQuery)query).ifPresent(obj -> container.set((DataQuery)query, obj)));
        return container;
    }

    @Override
    public DataContainer copy(DataView.SafetyMode safety) {
        MemoryDataContainer container = new MemoryDataContainer(safety);
        this.keys(false).forEach(query -> this.get((DataQuery)query).ifPresent(obj -> container.set((DataQuery)query, obj)));
        return container;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public DataView.SafetyMode safetyMode() {
        return this.safety;
    }

    public int hashCode() {
        return Objects.hash(this.map, this.path);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataView other = (MemoryDataView)obj;
        return com.google.common.base.Objects.equal(this.map.entrySet(), other.map.entrySet()) && com.google.common.base.Objects.equal((Object)this.path, (Object)other.path);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (!this.path.toString().isEmpty()) {
            helper.add("path", (Object)this.path);
        }
        helper.add("safety", (Object)this.safety.name());
        return helper.add("map", this.map).toString();
    }
}

