/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.common.PhaseTrackerCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.event.cause.entity.SpongeSpawnTypes;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseStack;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.SpongeCauseStackFrame;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.ThreadUtil;

public final class PhaseTracker
implements CauseStackManager {
    public static final PhaseTracker CLIENT = new PhaseTracker();
    public static final PhaseTracker SERVER = new PhaseTracker();
    public static final Logger LOGGER = LogManager.getLogger(PhaseTracker.class);
    static final CopyOnWriteArrayList<Entity> ASYNC_CAPTURED_ENTITIES = new CopyOnWriteArrayList();
    private static final Map<Thread, PhaseTracker> SPINOFF_TRACKERS = new MapMaker().weakKeys().concurrencyLevel(8).makeMap();
    private static final boolean DEBUG_CAUSE_FRAMES = Boolean.parseBoolean(System.getProperty("sponge.debugcauseframes", "false"));
    private static final String INITIAL_POOL_SIZE_PROPERTY = "sponge.cause.initialFramePoolSize";
    private static final String MAX_POOL_SIZE_PROPERTY = "sponge.cause.maxFramePoolSize";
    private static final int INITIAL_POOL_SIZE;
    private static final int MAX_POOL_SIZE;
    private final Deque<Object> cause = Queues.newArrayDeque();
    private final Deque<SpongeCauseStackFrame> frames = Queues.newArrayDeque();
    private final Deque<SpongeCauseStackFrame> framePool = new ArrayDeque<SpongeCauseStackFrame>(MAX_POOL_SIZE);
    private final Map<EventContextKey<?>, Object> ctx = Maps.newHashMap();
    private int min_depth = 0;
    private int[] duplicateCauses = new int[100];
    private @Nullable Cause cached_cause;
    private @Nullable EventContext cached_ctx;
    private final AtomicBoolean pendingProviders = new AtomicBoolean(false);
    private @Nullable WeakReference<Thread> sidedThread;
    private boolean hasRun = false;
    private final Deque<PhaseContext<?>> phaseContextProviders = new ArrayDeque();
    final PhaseStack stack = new PhaseStack();
    private final IdentityHashMap<IPhaseState<?>, ArrayDeque<? extends PhaseContext<?>>> stateContextPool = new IdentityHashMap();

    public static PhaseTracker getInstance() {
        Thread current = Thread.currentThread();
        if (current == SERVER.getSidedThread()) {
            return SERVER;
        }
        if (current == CLIENT.getSidedThread()) {
            return CLIENT;
        }
        return SPINOFF_TRACKERS.computeIfAbsent(current, thread -> {
            try {
                PhaseTracker phaseTracker = new PhaseTracker();
                phaseTracker.setThread((Thread)thread);
                return phaseTracker;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to create a new PhaseTracker for Thread: " + thread, e);
            }
        });
    }

    public static CauseStackManager getCauseStackManager() {
        return PhaseTracker.getInstance();
    }

    public static Block validateBlockForNeighborNotification(ServerLevel worldServer, BlockPos pos, @Nullable Block blockIn, BlockPos otherPos, LevelChunk chunk) {
        if (blockIn == null) {
            PhaseContext<?> currentContext = PhaseTracker.getInstance().getPhaseContext();
            PhaseTrackerCategory trackerConfig = SpongeConfigs.getCommon().get().phaseTracker;
            if (currentContext.state == TickPhase.Tick.TILE_ENTITY) {
                @Nullable BlockEntity source = (BlockEntity)currentContext.getSource();
                @Nullable BlockEntityType type = Optional.ofNullable(source).map(BlockEntity::getType).orElse(null);
                if (type != null) {
                    boolean useTile;
                    Map<String, Boolean> autoFixedTiles;
                    boolean contained;
                    @Nullable ResourceLocation id = BlockEntityType.getKey((BlockEntityType)type);
                    if (id == null) {
                        id = new ResourceLocation(source.getClass().getCanonicalName());
                    }
                    if (!(contained = (autoFixedTiles = trackerConfig.autoFixNullSourceBlockProvidingBlockEntities).containsKey(type.toString()))) {
                        autoFixedTiles.put(id.toString(), pos.equals((Object)source.getBlockPos()));
                    }
                    boolean bl = useTile = contained && autoFixedTiles.get(id.toString()) != false;
                    if (useTile) {
                        blockIn = source.getBlockState().getBlock();
                    } else {
                        Block block = blockIn = pos.getX() >> 4 == chunk.getPos().x && pos.getZ() >> 4 == chunk.getPos().z ? chunk.getBlockState(pos).getBlock() : worldServer.getBlockState(pos).getBlock();
                    }
                    if (!contained && trackerConfig.reportNullSourceBlocksOnNeighborNotifications) {
                        PhasePrinter.printNullSourceBlockWithTile(pos, blockIn, otherPos, id, useTile, new NullPointerException("Null Source Block For TileEntity Neighbor Notification"));
                    }
                } else {
                    Block block = blockIn = pos.getX() >> 4 == chunk.getPos().x && pos.getZ() >> 4 == chunk.getPos().z ? chunk.getBlockState(pos).getBlock() : worldServer.getBlockState(pos).getBlock();
                    if (trackerConfig.reportNullSourceBlocksOnNeighborNotifications) {
                        PhasePrinter.printNullSourceBlockNeighborNotificationWithNoTileSource(pos, blockIn, otherPos, new NullPointerException("Null Source Block For Neighbor Notification"));
                    }
                }
            } else {
                Block block = blockIn = pos.getX() >> 4 == chunk.getPos().x && pos.getZ() >> 4 == chunk.getPos().z ? chunk.getBlockState(pos).getBlock() : worldServer.getBlockState(pos).getBlock();
                if (trackerConfig.reportNullSourceBlocksOnNeighborNotifications) {
                    PhasePrinter.printNullSourceForBlock(worldServer, pos, blockIn, otherPos, new NullPointerException("Null Source Block For Neighbor Notification"));
                }
            }
        }
        return blockIn;
    }

    PhaseTracker() {
        for (int i = 0; i < INITIAL_POOL_SIZE; ++i) {
            this.framePool.push(new SpongeCauseStackFrame(this));
        }
    }

    public void init() {
        if (this != SERVER) {
            return;
        }
        if (this.hasRun) {
            return;
        }
        this.hasRun = true;
        Task task = Task.builder().interval(Ticks.single()).execute(() -> {
            if (ASYNC_CAPTURED_ENTITIES.isEmpty()) {
                return;
            }
            ArrayList<Entity> entities = new ArrayList<Entity>(ASYNC_CAPTURED_ENTITIES);
            ASYNC_CAPTURED_ENTITIES.removeAll(entities);
            try (CauseStackManager.StackFrame frame = this.pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpongeSpawnTypes.FORCED);
                for (Entity entity : entities) {
                    entity.getCommandSenderWorld().addFreshEntity(entity);
                }
            }
        }).plugin(((Launch)Launch.instance()).commonPlugin()).build();
        Sponge.server().scheduler().submit(task, "Sponge Async To Sync Entity Spawn Task");
    }

    public void setThread(@Nullable Thread thread) throws IllegalAccessException {
        if ((this == SERVER || this == CLIENT) && thread == null) {
            this.sidedThread = new WeakReference<Object>(null);
            return;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < 3) {
            throw new IllegalAccessException("Cannot call directly to change thread.");
        }
        if (this != SERVER && this != CLIENT && this.sidedThread == null) {
            this.sidedThread = new WeakReference<Thread>(thread);
            return;
        }
        String callingClass = stackTrace[1].getClassName();
        String callingParent = stackTrace[2].getClassName();
        if (!("net.minecraft.client.Minecraft".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent) || "net.minecraft.server.MinecraftServer".equals(callingClass) && "net.minecraft.server.MinecraftServer".equals(callingParent) || "net.minecraft.server.dedicated.DedicatedServer".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent) || "net.minecraft.client.server.IntegratedServer".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent))) {
            throw new IllegalAccessException("Illegal Attempts to re-assign PhaseTracker threads on Sponge");
        }
        this.sidedThread = new WeakReference<Thread>(thread);
    }

    public boolean onSidedThread() {
        return Thread.currentThread() == this.getSidedThread();
    }

    public IPhaseState<?> getCurrentState() {
        if (Thread.currentThread() != this.getSidedThread()) {
            throw new UnsupportedOperationException("Cannot access the PhaseTracker off-thread, please use the respective PhaseTracker for their proper thread.");
        }
        return this.stack.peekState();
    }

    public PhaseContext<?> getPhaseContext() {
        if (Thread.currentThread() != this.getSidedThread()) {
            throw new UnsupportedOperationException("Cannot access the PhaseTracker off-thread, please use the respective PhaseTracker for their proper thread.");
        }
        return this.stack.peekContext();
    }

    public @Nullable Thread getSidedThread() {
        return this.sidedThread != null ? (Thread)this.sidedThread.get() : null;
    }

    void switchToPhase(IPhaseState<?> state, PhaseContext<?> phaseContext) {
        if (phaseContext.createdTracker != this && Thread.currentThread() != this.getSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped("Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.", new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        Preconditions.checkNotNull(state, (Object)"State cannot be null!");
        Preconditions.checkNotNull(phaseContext, (Object)"PhaseContext cannot be null!");
        Preconditions.checkArgument((boolean)phaseContext.isComplete(), (Object)"PhaseContext must be complete!");
        if (this == SERVER && SpongeConfigs.getCommon().get().phaseTracker.verbose && this.stack.size() > 6 && this.stack.checkForRunaways(state, phaseContext)) {
            PhasePrinter.printRunawayPhase(this.stack, state, phaseContext);
        }
        if (phaseContext.shouldProvideModifiers()) {
            this.registerPhaseContextProvider(phaseContext);
        }
        this.stack.push(state, phaseContext);
    }

    void completePhase(PhaseContext<?> context) {
        if (context.createdTracker != this && Thread.currentThread() != this.getSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped("Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.", new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        PhaseContext<?> currentContext = this.stack.peek();
        IPhaseState state = currentContext.state;
        boolean isEmpty = this.stack.isEmpty();
        if (isEmpty) {
            PhasePrinter.printEmptyStackOnCompletion(currentContext);
            return;
        }
        if (context.state != state) {
            PhasePrinter.printIncorrectPhaseCompletion(this.stack, context.state, state);
            this.stack.pop();
            return;
        }
        if (SpongeConfigs.getCommon().get().phaseTracker.verbose && this.stack.checkForRunaways(GeneralPhase.Post.UNWINDING, null)) {
            PhasePrinter.printRunAwayPhaseCompletion(this.stack, state);
        }
        boolean hasCaptures = currentContext.hasCaptures();
        try (@Nullable UnwindingPhaseContext unwinding = UnwindingPhaseContext.unwind(currentContext, hasCaptures);){
            try {
                if (hasCaptures) {
                    state.unwind(currentContext);
                }
            }
            catch (Exception e) {
                PhasePrinter.printMessageWithCaughtException(this.stack, "Exception Exiting Phase", "Something happened when trying to unwind", state, currentContext, (Throwable)e);
            }
        }
        catch (Exception e) {
            PhasePrinter.printMessageWithCaughtException(this.stack, "Exception Post Dispatching Phase", "Something happened when trying to post dispatch state", state, currentContext, (Throwable)e);
        }
        this.checkPhaseContextProcessed(state, currentContext);
        this.stack.pop();
    }

    private void checkPhaseContextProcessed(IPhaseState<?> state, PhaseContext<?> context) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && PhasePrinter.printedExceptionsForUnprocessedState.contains(state)) {
            return;
        }
        if (context.notAllCapturesProcessed()) {
            PhasePrinter.printUnprocessedPhaseContextObjects(this.stack, state, context);
            PhasePrinter.printedExceptionsForUnprocessedState.add(state);
        }
    }

    String dumpStack() {
        if (this.stack.isEmpty()) {
            return "[Empty stack]";
        }
        PrettyPrinter printer = new PrettyPrinter(40);
        this.stack.forEach(data -> PhasePrinter.PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        printer.print(new PrintStream(stream));
        return stream.toString();
    }

    public void ensureEmpty() {
        if (!this.stack.isEmpty()) {
            PhasePrinter.printNonEmptyStack(this.stack);
            while (!this.stack.isEmpty()) {
                this.getPhaseContext().close();
            }
        }
    }

    public <C extends PhaseContext<C>> ArrayDeque<C> getContextPoolFor(PooledPhaseState<? extends C> state) {
        return this.stateContextPool.computeIfAbsent(state, newState -> new ArrayDeque());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseTracker that = (PhaseTracker)o;
        return this.hasRun == that.hasRun && this.sidedThread != null && that.sidedThread != null && this.sidedThread.equals(that.sidedThread) || this.sidedThread == null && that.sidedThread == null;
    }

    public int hashCode() {
        return Objects.hash(this.sidedThread);
    }

    public String toString() {
        return new StringJoiner(", ", PhaseTracker.class.getSimpleName() + "[", "]").add("sidedThread=" + this.sidedThread).add("hasRun=" + this.hasRun).toString();
    }

    @Override
    public Cause currentCause() {
        this.enforceMainThread();
        if (this.cached_cause == null || this.cached_ctx == null) {
            this.cached_cause = this.cause.isEmpty() ? Cause.of(this.currentContext(), SpongeCommon.game()) : Cause.of(this.currentContext(), this.cause);
        }
        return this.cached_cause;
    }

    @Override
    public EventContext currentContext() {
        this.enforceMainThread();
        if (this.cached_ctx == null) {
            this.cached_ctx = EventContext.of(this.ctx);
        }
        return this.cached_ctx;
    }

    @Override
    public CauseStackManager pushCause(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"obj");
        this.enforceMainThread();
        this.cached_cause = null;
        if (this.cause.peek() == obj) {
            int dupedIndex = this.cause.size();
            if (this.duplicateCauses.length <= dupedIndex) {
                this.duplicateCauses = Arrays.copyOf(this.duplicateCauses, (int)((double)dupedIndex * 1.5));
            }
            this.duplicateCauses[dupedIndex] = this.duplicateCauses[dupedIndex] + 1;
            return this;
        }
        this.cause.push(obj);
        return this;
    }

    @Override
    public Object popCause() {
        this.enforceMainThread();
        int size = this.cause.size();
        int dupeCause = this.duplicateCauses[size];
        if (dupeCause > 0) {
            this.duplicateCauses[size] = dupeCause - 1;
            return Preconditions.checkNotNull((Object)this.cause.peek());
        }
        if (size <= this.min_depth) {
            throw new IllegalStateException("Cause stack corruption, tried to pop more objects off than were pushed since last frame (Size was " + size + " but mid depth is " + this.min_depth + ")");
        }
        this.cached_cause = null;
        return this.cause.pop();
    }

    @Override
    public void popCauses(int n) {
        this.enforceMainThread();
        for (int i = 0; i < n; ++i) {
            this.popCause();
        }
    }

    @Override
    public Object peekCause() {
        this.enforceMainThread();
        return this.cause.peek();
    }

    @Override
    public CauseStackManager.StackFrame pushCauseFrame() {
        SpongeCauseStackFrame frame;
        this.enforceMainThread();
        int size = this.cause.size();
        if (this.duplicateCauses.length <= size) {
            this.duplicateCauses = Arrays.copyOf(this.duplicateCauses, (int)((double)size * 1.5));
        }
        if (this.framePool.isEmpty()) {
            frame = new SpongeCauseStackFrame(this).set(this.min_depth, this.duplicateCauses[size]);
        } else {
            frame = this.framePool.pop();
            frame.clear();
            frame.old_min_depth = this.min_depth;
            frame.lastCauseSize = this.duplicateCauses[size];
        }
        this.frames.push(frame);
        this.min_depth = size;
        if (DEBUG_CAUSE_FRAMES) {
            frame.stackDebug = new Exception();
        }
        return frame;
    }

    @Override
    public void popCauseFrame(CauseStackManager.StackFrame oldFrame) {
        Preconditions.checkNotNull((Object)oldFrame, (Object)"oldFrame");
        this.enforceMainThread();
        @Nullable SpongeCauseStackFrame frame = this.frames.peek();
        if (frame != oldFrame) {
            int offset = -1;
            int i = 0;
            for (SpongeCauseStackFrame f : this.frames) {
                if (f == oldFrame) {
                    offset = i;
                    break;
                }
                ++i;
            }
            if (!DEBUG_CAUSE_FRAMES && offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            PrettyPrinter printer = new PrettyPrinter(100).add("Cause Stack Frame Corruption!").centre().hr().add("Found %d frames left on the stack. Clearing them all.", offset + 1);
            if (!DEBUG_CAUSE_FRAMES) {
                printer.add().add("Please add -Dsponge.debugcauseframes=true to your startup flags to enable further debugging output.");
                SpongeCommon.logger().warn("  Add -Dsponge.debugcauseframes to your startup flags to enable further debugging output.");
            } else {
                printer.add().add("Attempting to pop frame:").add(frame.stackDebug).add().add("Frames being popped are:").add(((SpongeCauseStackFrame)oldFrame).stackDebug);
            }
            while (offset >= 0) {
                SpongeCauseStackFrame f;
                f = this.frames.peek();
                if (DEBUG_CAUSE_FRAMES && offset > 0) {
                    printer.add("   Stack frame in position %d :", offset);
                    printer.add(f.stackDebug);
                }
                this.popCauseFrame(f);
                --offset;
            }
            printer.trace(System.err, SpongeCommon.logger(), Level.ERROR);
            if (offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            return;
        }
        this.frames.pop();
        for (Map.Entry<EventContextKey<?>, Object> entry : frame.getOriginalContextDelta().entrySet()) {
            this.cached_ctx = null;
            this.cached_cause = null;
            if (entry.getValue() == null) {
                this.ctx.remove(entry.getKey());
                continue;
            }
            this.ctx.put(entry.getKey(), entry.getValue());
        }
        while (this.cause.size() > this.min_depth) {
            int index = this.cause.size();
            if (this.duplicateCauses.length > index) {
                this.duplicateCauses[index] = 0;
            }
            this.cause.pop();
            this.cached_cause = null;
        }
        this.min_depth = frame.old_min_depth;
        int size = this.cause.size();
        if (this.duplicateCauses.length > size) {
            this.duplicateCauses[size] = frame.lastCauseSize;
        }
        if (this.framePool.size() < MAX_POOL_SIZE) {
            frame.clear();
            this.framePool.push(frame);
        }
    }

    @Override
    public <T> CauseStackManager addContext(EventContextKey<T> key, T value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(value, (Object)"value");
        this.enforceMainThread();
        this.cached_ctx = null;
        this.cached_cause = null;
        @Nullable Object existing = this.ctx.put(key, value);
        if (!this.frames.isEmpty()) {
            this.frames.peek().storeOriginalContext(key, existing);
        }
        return this;
    }

    @Override
    public <T> Optional<T> context(EventContextKey<T> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        this.enforceMainThread();
        return Optional.ofNullable(this.ctx.get(key));
    }

    @Override
    public <T> Optional<T> removeContext(EventContextKey<T> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        this.enforceMainThread();
        this.cached_ctx = null;
        this.cached_cause = null;
        Object existing = this.ctx.remove(key);
        if (!this.frames.isEmpty()) {
            this.frames.peek().storeOriginalContext(key, existing);
        }
        return Optional.ofNullable(existing);
    }

    private void enforceMainThread() {
        if (Thread.currentThread() != this.getSidedThread()) {
            throw new IllegalStateException(String.format("CauseStackManager called from off main thread (current='%s', expected='%s')!", ThreadUtil.getDescription(Thread.currentThread()), ThreadUtil.getDescription(SpongeCommon.server().getRunningThread())));
        }
        this.checkProviders();
    }

    private void checkProviders() {
        if (!this.pendingProviders.compareAndSet(true, false)) {
            return;
        }
        Iterator<PhaseContext<@NonNull ?>> iterator = this.phaseContextProviders.descendingIterator();
        while (iterator.hasNext()) {
            PhaseContext<@NonNull ?> context = iterator.next();
            CauseStackManager.StackFrame frame = this.pushCauseFrame();
            context.getFrameModifier().accept(frame);
        }
        this.phaseContextProviders.clear();
    }

    private void registerPhaseContextProvider(PhaseContext<?> context) {
        Preconditions.checkNotNull(context.state.getFrameModifier(), (Object)"Consumer");
        this.pendingProviders.compareAndSet(false, true);
        this.cached_cause = null;
        this.cached_ctx = null;
        this.phaseContextProviders.push(context);
    }

    void popFrameMutator(PhaseContext<?> context) {
        @Nullable PhaseContext<?> peek = this.phaseContextProviders.peek();
        if (peek == null) {
            return;
        }
        if (peek != context) {
            System.err.println("oops. corrupted phase context providers!");
        }
        this.phaseContextProviders.pop();
        if (this.phaseContextProviders.isEmpty()) {
            this.pendingProviders.compareAndSet(true, false);
        }
    }

    static {
        int initialPoolSize = 50;
        int maxPoolSize = 100;
        try {
            initialPoolSize = Integer.parseInt(System.getProperty(INITIAL_POOL_SIZE_PROPERTY, "50"));
        }
        catch (NumberFormatException ex) {
            SpongeCommon.logger().warn("{} must be an integer, was set to {}. Defaulting to 50.", (Object)INITIAL_POOL_SIZE_PROPERTY, (Object)System.getProperty(INITIAL_POOL_SIZE_PROPERTY));
        }
        try {
            maxPoolSize = Integer.parseInt(System.getProperty(MAX_POOL_SIZE_PROPERTY, "100"));
        }
        catch (NumberFormatException ex) {
            SpongeCommon.logger().warn("{} must be an integer, was set to {}. Defaulting to 100.", (Object)MAX_POOL_SIZE_PROPERTY, (Object)System.getProperty(MAX_POOL_SIZE_PROPERTY));
        }
        MAX_POOL_SIZE = Math.max(0, maxPoolSize);
        INITIAL_POOL_SIZE = Math.max(0, Math.min(MAX_POOL_SIZE, initialPoolSize));
    }
}

