/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateLightSideEffect
implements ProcessingSideEffect {
    public static UpdateLightSideEffect getInstance() {
        return Holder.INSTANCE;
    }

    UpdateLightSideEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        if (!flag.updateLighting()) {
            return EffectResult.NULL_PASS;
        }
        int originalOpactiy = oldState.opacity;
        ServerLevel serverWorld = pipeline.getServerWorld();
        BlockState currentState = pipeline.getAffectedChunk().getBlockState(oldState.pos);
        if (oldState.state != currentState && (currentState.getLightBlock((BlockGetter)serverWorld, oldState.pos) != originalOpactiy || currentState.getLightEmission() != oldState.state.getLightEmission() || currentState.useShapeForLightOcclusion() || oldState.state.useShapeForLightOcclusion())) {
            serverWorld.getProfiler().push("queueCheckLight");
            serverWorld.getChunkSource().getLightEngine().checkBlock(oldState.pos);
            serverWorld.getProfiler().pop();
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateLightSideEffect INSTANCE = new UpdateLightSideEffect();

        private Holder() {
        }
    }
}

