/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

class PlayerTickPhaseState
extends TickPhaseState<PlayerTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, PlayerTickContext> FRAME_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(Player.class).ifPresent(frame::pushCause));

    PlayerTickPhaseState() {
    }

    @Override
    protected PlayerTickContext createNewContext(PhaseTracker tracker) {
        return new PlayerTickContext(tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, PlayerTickContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public void unwind(PlayerTickContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.creator(player.uniqueId());
        explosionContext.notifier(player.uniqueId());
        explosionContext.source(player);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(PlayerTickContext context) {
        ServerPlayer entity = context.getSource(ServerPlayer.class).orElseThrow(() -> new IllegalStateException("Expected to be ticking a Player, but we're not ticking a player"));
        return () -> entity.world().key();
    }
}

