/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;

public final class SpongeEnchantmentBuilder
extends AbstractDataBuilder<Enchantment>
implements Enchantment.Builder {
    private @Nullable EnchantmentType enchantmentType;
    private @Nullable Integer level;

    public SpongeEnchantmentBuilder() {
        super(Enchantment.class, 1);
    }

    @Override
    public Enchantment.Builder from(Enchantment value) {
        Preconditions.checkNotNull((Object)value, (Object)"The enchantment to create a builder from cannot be null!");
        this.enchantmentType = value.type();
        this.level = value.level();
        return this;
    }

    @Override
    public Enchantment.Builder reset() {
        this.enchantmentType = null;
        this.level = null;
        return this;
    }

    @Override
    public Enchantment.Builder type(EnchantmentType enchantmentType) {
        this.enchantmentType = (EnchantmentType)Preconditions.checkNotNull((Object)enchantmentType, (Object)"Enchantment type cannot be null!");
        return this;
    }

    @Override
    public Enchantment.Builder level(int level) {
        Preconditions.checkArgument((level >= Short.MIN_VALUE ? 1 : 0) != 0, (String)"The specified level must be greater than %s (was %s)!", (int)Short.MIN_VALUE, (int)level);
        Preconditions.checkArgument((level <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"The specified level must not be greater than %s (was %s)!", (int)Short.MAX_VALUE, (int)level);
        this.level = level;
        return this;
    }

    @Override
    public Enchantment build() {
        Preconditions.checkState((this.enchantmentType != null ? 1 : 0) != 0, (Object)"The enchantment type must be set!");
        Preconditions.checkState((this.level != null ? 1 : 0) != 0, (Object)"The level of the enchantment must be set!");
        return new SpongeEnchantment(this.enchantmentType, this.level);
    }

    @Override
    protected Optional<Enchantment> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container, (Object)"The data view cannot be null!");
        if (!container.contains(Queries.ENCHANTMENT_ID, Queries.LEVEL)) {
            return Optional.empty();
        }
        Optional<EnchantmentType> enchantmentType = container.getRegistryValue(Queries.ENCHANTMENT_ID, RegistryTypes.ENCHANTMENT_TYPE);
        Optional<Integer> level = container.getInt(Queries.LEVEL);
        Enchantment.Builder builder = Enchantment.builder();
        level.map(builder::level);
        return enchantmentType.map(builder::type).map(Enchantment.Builder::build);
    }
}

