/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeCookingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient ingredient;
    private final Item result;
    private final float experience;
    private final Ticks cookingTime;
    private final ItemStack spongeResult;
    private final Function<Container, ItemStack> resultFunction;

    public SpongeCookingRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, String group, Ingredient ingredient, float experience, Ticks cookingTime, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category) {
        super(key, serializer, spongeResult.getItem(), group, pack, category);
        this.ingredient = ingredient;
        this.result = spongeResult.getItem();
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.spongeResult = spongeResult.hasTag() ? spongeResult : null;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("ingredient", this.ingredient.toJson());
    }

    @Override
    public void serializeResult(JsonObject json) {
        DefaultedRegistry itemRegistry = BuiltInRegistries.ITEM;
        json.addProperty("result", itemRegistry.getKey((Object)this.result).toString());
        if (this.spongeResult != null) {
            this.spongeResult.setCount(1);
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.getId(), this.resultFunction));
        }
    }

    @Override
    public void serializeAdditional(JsonObject json) {
        json.addProperty("experience", Float.valueOf(this.experience));
        json.addProperty("cookingtime", this.cookingTime.ticks());
    }
}

