/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.world.ChangeWorldBorderEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.network.ServerGamePacketListenerImplAccessor;
import org.spongepowered.common.accessor.world.level.border.WorldBorderAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeMusicDisc;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.api.minecraft.world.entity.player.PlayerMixin_API;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.util.BookUtil;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.server.level.ServerPlayer.class})
public abstract class ServerPlayerMixin_API
extends PlayerMixin_API
implements ServerPlayer {
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    @Final
    private PlayerAdvancements advancements;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Shadow
    @Nullable
    private Vec3 enteredLavaOnVehiclePosition;
    private volatile Pointers api$pointers;
    private final TabList api$tabList = new SpongeTabList((net.minecraft.server.level.ServerPlayer)this);

    @Shadow
    public abstract ServerLevel shadow$getLevel();

    @Shadow
    public abstract void shadow$sendSystemMessage(net.minecraft.network.chat.Component var1);

    @Override
    public ServerWorld world() {
        return (ServerWorld)this.shadow$getLevel();
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(particleEffect, "particleEffect");
        Objects.requireNonNull(position, "position");
        if (radius <= 0) {
            throw new IllegalArgumentException("The radius has to be greater then zero!");
        }
        List<Packet<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty() && position.sub(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ()).lengthSquared() < (double)((long)radius * (long)radius)) {
            for (Packet<?> packet : packets) {
                this.connection.send(packet);
            }
        }
    }

    @Override
    public User user() {
        return SpongeUserView.create(this.uuid);
    }

    @Override
    public boolean isOnline() {
        if (this.impl$isFake) {
            return true;
        }
        return this.server.getPlayerList().getPlayer(this.uuid) == (net.minecraft.server.level.ServerPlayer)this;
    }

    @Override
    public GameProfile profile() {
        return SpongeGameProfile.of(this.shadow$getGameProfile());
    }

    @Override
    public void sendWorldType(WorldType worldType) {
        if (this.impl$isFake) {
            return;
        }
        ((ServerPlayerBridge)((Object)this)).bridge$sendViewerEnvironment((DimensionType)Objects.requireNonNull(worldType, "worldType"));
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        if (this.impl$isFake) {
            return;
        }
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public ServerPlayerConnection connection() {
        return (ServerPlayerConnection)this.connection;
    }

    @Overwrite
    public String getIpAddress() {
        return NetworkUtil.getHostString(((ServerGamePacketListenerImplAccessor)this.connection).accessor$connection().getRemoteAddress());
    }

    @Override
    public String identifier() {
        return this.uuid.toString();
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Objects.requireNonNull(scoreboard, "scoreboard");
        ((ServerScoreboardBridge)((Object)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard())).bridge$removePlayer((net.minecraft.server.level.ServerPlayer)this, true);
        ((ServerPlayerBridge)((Object)this)).bridge$replaceScoreboard(scoreboard);
        ((ServerScoreboardBridge)((Object)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard())).bridge$addPlayer((net.minecraft.server.level.ServerPlayer)this, true);
    }

    @Override
    public Component teamRepresentation() {
        return SpongeAdventure.asAdventure(this.shadow$getName());
    }

    @Override
    public Scoreboard scoreboard() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getScoreboard();
    }

    @Override
    public boolean kick() {
        return this.kick((Component)Component.translatable((String)"disconnect.disconnected"));
    }

    @Override
    public boolean kick(Component message) {
        return ((ServerPlayerBridge)((Object)this)).bridge$kick(Objects.requireNonNull(message, "message"));
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc recordType) {
        this.connection.send((Packet)SpongeMusicDisc.createPacket(Objects.requireNonNull(position, "position"), Objects.requireNonNull(recordType, "recordType")));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.connection.send((Packet)SpongeMusicDisc.createPacket(position, null));
    }

    @Override
    public void sendResourcePack(ResourcePack pack) {
        this.connection.send((Packet)new ClientboundResourcePackPacket(((SpongeResourcePack)Objects.requireNonNull(pack, "pack")).getUrlString(), pack.hash().orElse(""), false, SpongeAdventure.asVanilla(pack.prompt())));
    }

    @Override
    public TabList tabList() {
        return this.api$tabList;
    }

    @Override
    public boolean hasPlayedBefore() {
        Instant instant = ((SpongeServer)this.shadow$getServer()).getPlayerDataManager().getFirstJoined(this.uniqueId()).get();
        Instant toTheMinute = instant.truncatedTo(ChronoUnit.MINUTES);
        Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);
        Duration timeSinceFirstJoined = Duration.of(now.minusMillis(toTheMinute.toEpochMilli()).toEpochMilli(), ChronoUnit.MINUTES);
        return timeSinceFirstJoined.getSeconds() > 0L;
    }

    @Override
    public void sendBlockChange(int x, int y, int z, org.spongepowered.api.block.BlockState state) {
        this.connection.send((Packet)new ClientboundBlockUpdatePacket(new BlockPos(x, y, z), (BlockState)state));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        this.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.shadow$getCommandSenderWorld(), new BlockPos(x, y, z)));
    }

    @Override
    public boolean respawn() {
        if (this.impl$isFake) {
            return false;
        }
        if (this.shadow$getHealth() > 0.0f) {
            return false;
        }
        this.connection.player = this.server.getPlayerList().respawn((net.minecraft.server.level.ServerPlayer)this, false);
        return true;
    }

    @Override
    public void simulateChat(Component message, Cause cause) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(cause, "cause");
        PlayerChatEvent.Decorate event = SpongeEventFactory.createPlayerChatEventDecorate(cause, message, message, Optional.of(this));
        if (!SpongeCommon.post(event)) {
            net.minecraft.network.chat.Component decoratedMessage = SpongeAdventure.asVanilla(event.message());
            ChatType.Bound boundType = ChatType.bind((ResourceKey)ChatType.CHAT, (RegistryAccess)this.server.registryAccess(), (net.minecraft.network.chat.Component)this.getName());
            net.minecraft.server.level.ServerPlayer thisPlayer = (net.minecraft.server.level.ServerPlayer)this;
            this.server.getPlayerList().broadcastChatMessage(PlayerChatMessage.system((String)decoratedMessage.getString()), thisPlayer, boundType);
        }
    }

    @Override
    public @NonNull Optional<WorldBorder> worldBorder() {
        net.minecraft.world.level.border.WorldBorder border = ((ServerPlayerBridge)((Object)this)).bridge$getWorldBorder();
        if (border == null) {
            return Optional.empty();
        }
        return Optional.of(((WorldBorderBridge)border).bridge$asImmutable());
    }

    @Override
    public CooldownTracker cooldownTracker() {
        return (CooldownTracker)this.shadow$getCooldowns();
    }

    @Override
    public AdvancementProgress progress(org.spongepowered.api.advancement.Advancement advancement) {
        return (AdvancementProgress)this.advancements.getOrStartProgress((Advancement)Objects.requireNonNull(advancement, "advancement"));
    }

    @Override
    public Collection<AdvancementTree> unlockedAdvancementTrees() {
        if (this.impl$isFake) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(((PlayerAdvancementsBridge)this.advancements).bridge$getAdvancementTrees());
    }

    @Override
    public @NonNull Optional<WorldBorder> setWorldBorder(@Nullable WorldBorder border) {
        Optional<WorldBorder> toSet;
        if (this.impl$isFake) {
            return Optional.empty();
        }
        Optional<WorldBorder> currentBorder = this.worldBorder();
        if (Objects.equals(currentBorder.orElse(null), border)) {
            return currentBorder;
        }
        ChangeWorldBorderEvent.Player event = SpongeEventFactory.createChangeWorldBorderEventPlayer(PhaseTracker.getCauseStackManager().currentCause(), Optional.ofNullable(border), Optional.ofNullable(border), this, Optional.ofNullable(border));
        if (SpongeCommon.post(event)) {
            return currentBorder;
        }
        net.minecraft.world.level.border.WorldBorder oldWorldBorder = ((ServerPlayerBridge)((Object)this)).bridge$getWorldBorder();
        if (oldWorldBorder != null) {
            ((WorldBorderAccessor)oldWorldBorder).accessor$listeners().remove(((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
        }
        if ((toSet = event.newBorder()).isPresent()) {
            net.minecraft.world.level.border.WorldBorder mutableWorldBorder = new net.minecraft.world.level.border.WorldBorder();
            ((WorldBorderBridge)mutableWorldBorder).bridge$applyFrom(toSet.get());
            ((ServerPlayerBridge)((Object)this)).bridge$replaceWorldBorder(mutableWorldBorder);
            mutableWorldBorder.addListener((BorderChangeListener)((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
            this.connection.send((Packet)new ClientboundInitializeBorderPacket(mutableWorldBorder));
        } else {
            ((ServerPlayerBridge)((Object)this)).bridge$replaceWorldBorder(null);
            this.connection.send((Packet)new ClientboundInitializeBorderPacket(this.shadow$getCommandSenderWorld().getWorldBorder()));
        }
        return toSet;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.requireValue(Keys.CHAT_COLORS_ENABLED).asImmutable());
        values.add(this.requireValue(Keys.CHAT_VISIBILITY).asImmutable());
        values.add(this.requireValue(Keys.GAME_MODE).asImmutable());
        values.add(this.requireValue(Keys.HAS_VIEWED_CREDITS).asImmutable());
        values.add(this.requireValue(Keys.LOCALE).asImmutable());
        values.add(this.requireValue(Keys.PREVIOUS_GAME_MODE).asImmutable());
        values.add(((SetValue)this.requireValue(Keys.SKIN_PARTS)).asImmutable());
        values.add(this.requireValue(Keys.SPECTATOR_TARGET).asImmutable());
        values.add(this.requireValue(Keys.VIEW_DISTANCE).asImmutable());
        this.getValue(Keys.HEALTH_SCALE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SKIN_PROFILE_PROPERTY).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pointers pointers() {
        Pointers pointers = this.api$pointers;
        if (pointers == null) {
            ServerPlayerMixin_API serverPlayerMixin_API = this;
            synchronized (serverPlayerMixin_API) {
                if (this.api$pointers != null) {
                    return this.api$pointers;
                }
                this.api$pointers = pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, () -> ((net.minecraft.server.level.ServerPlayer)this).getGameProfile().getName()).withDynamic(Identity.DISPLAY_NAME, () -> (Component)this.displayName().get()).withDynamic(Identity.UUID, () -> ((net.minecraft.world.entity.Entity)((net.minecraft.world.entity.Entity)this)).getUUID()).withDynamic(Identity.LOCALE, this::locale).withStatic(PermissionChecker.POINTER, permission -> SpongeAdventure.asAdventure(this.permissionValue(permission))).build();
            }
        }
        return pointers;
    }

    @Deprecated
    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.impl$isFake) {
            return;
        }
        this.shadow$sendSystemMessage(SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message")));
    }

    public void sendMessage(@NotNull Component message) {
        if (this.impl$isFake) {
            return;
        }
        this.shadow$sendSystemMessage(SpongeAdventure.asVanilla(message));
    }

    public void sendMessage(@NotNull Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        if (this.impl$isFake) {
            return;
        }
        this.connection.sendDisguisedChatMessage(SpongeAdventure.asVanilla(message), SpongeAdventure.asVanilla(this.level.registryAccess(), boundChatType));
    }

    public void sendMessage(@NotNull SignedMessage signedMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        if (this.impl$isFake) {
            return;
        }
        this.connection.sendDisguisedChatMessage(SpongeAdventure.asVanilla((Component)Objects.requireNonNullElse(signedMessage.unsignedContent(), Component.text((String)signedMessage.message()))), SpongeAdventure.asVanilla(this.level.registryAccess(), boundChatType));
    }

    public void deleteMessage(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SignedMessage.Signature signature) {
        if (this.impl$isFake) {
            return;
        }
        this.connection.send((Packet)new ClientboundDeleteChatPacket(((MessageSignature)signature).pack(((ServerGamePacketListenerImplAccessor)this.connection).accessor$messageSignatureCache())));
    }

    public void sendActionBar(Component message) {
        if (this.impl$isFake) {
            return;
        }
        this.connection.send((Packet)new ClientboundSetActionBarTextPacket(SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message"))));
    }

    public void sendPlayerListHeader(Component header) {
        this.api$tabList.setHeader(Objects.requireNonNull(header, "header"));
    }

    public void sendPlayerListFooter(Component footer) {
        this.api$tabList.setFooter(Objects.requireNonNull(footer, "footer"));
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.api$tabList.setHeaderAndFooter(Objects.requireNonNull(header, "header"), Objects.requireNonNull(footer, "footer"));
    }

    public void showTitle(Title title) {
        if (this.impl$isFake) {
            return;
        }
        Title.Times times = Objects.requireNonNull(title, "title").times();
        if (times != null) {
            this.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(this.api$durationToTicks(times.fadeIn()), this.api$durationToTicks(times.stay()), this.api$durationToTicks(times.fadeOut())));
        }
        this.connection.send((Packet)new ClientboundSetSubtitleTextPacket(SpongeAdventure.asVanilla(title.subtitle())));
        this.connection.send((Packet)new ClientboundSetTitleTextPacket(SpongeAdventure.asVanilla(title.title())));
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            this.connection.send((Packet)new ClientboundSetTitleTextPacket(SpongeAdventure.asVanilla((Component)value)));
        } else if (part == TitlePart.SUBTITLE) {
            this.connection.send((Packet)new ClientboundSetSubtitleTextPacket(SpongeAdventure.asVanilla((Component)value)));
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(this.api$durationToTicks(times.fadeIn()), this.api$durationToTicks(times.stay()), this.api$durationToTicks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + part + "'");
        }
    }

    public void clearTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.connection.send((Packet)new ClientboundClearTitlesPacket(false));
    }

    public void resetTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.connection.send((Packet)new ClientboundClearTitlesPacket(true));
    }

    public void showBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        ServerBossEvent vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.addPlayer((net.minecraft.server.level.ServerPlayer)this);
    }

    public void hideBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        ServerBossEvent vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.removePlayer((net.minecraft.server.level.ServerPlayer)this);
    }

    public void playSound(Sound sound) {
        this.playSound(Objects.requireNonNull(sound, "sound"), this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
    }

    private Holder<SoundEvent> api$resolveEvent(@NonNull Sound sound) {
        ResourceLocation eventId = SpongeAdventure.asVanilla(Objects.requireNonNull(sound, "sound").name());
        Registry soundEventRegistry = SpongeCommon.vanillaRegistry(Registries.SOUND_EVENT);
        SoundEvent event = soundEventRegistry.getOptional(eventId).orElseGet(() -> SoundEvent.createVariableRangeEvent((ResourceLocation)eventId));
        return soundEventRegistry.wrapAsHolder((Object)event);
    }

    public void playSound(@NonNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        net.minecraft.world.entity.Entity tracked;
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(emitter, "emitter");
        if (this.impl$isFake) {
            return;
        }
        if (emitter == Sound.Emitter.self()) {
            tracked = (net.minecraft.world.entity.Entity)this;
        } else if (emitter instanceof Entity) {
            tracked = (net.minecraft.world.entity.Entity)emitter;
        } else {
            throw new IllegalArgumentException("Specified emitter '" + emitter + "' is not a Sponge Entity or Emitter.self(), was of type '" + emitter.getClass() + "'");
        }
        this.connection.send((Packet)new ClientboundSoundEntityPacket(this.api$resolveEvent(sound), SpongeAdventure.asVanilla(sound.source()), tracked, sound.volume(), sound.pitch(), sound.seed().orElseGet(() -> tracked.level.getRandom().nextLong())));
    }

    public void playSound(Sound sound, double x, double y, double z) {
        if (this.impl$isFake) {
            return;
        }
        SoundSource source = SpongeAdventure.asVanilla(sound.source());
        Holder<SoundEvent> event = this.api$resolveEvent(sound);
        long random = sound.seed().orElseGet(() -> this.shadow$getLevel().getRandom().nextLong());
        this.connection.send((Packet)new ClientboundSoundPacket(event, source, x, y, z, sound.volume(), sound.pitch(), random));
    }

    public void stopSound(SoundStop stop) {
        if (this.impl$isFake) {
            return;
        }
        this.connection.send((Packet)new ClientboundStopSoundPacket(SpongeAdventure.asVanillaNullable(Objects.requireNonNull(stop, "stop").sound()), SpongeAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(@NonNull Book book) {
        if (this.impl$isFake) {
            return;
        }
        BookUtil.fakeBookView(Objects.requireNonNull(book, "book"), Collections.singletonList(this));
    }

    @Override
    public @NonNull Locale locale() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getLanguage();
    }

    private int api$durationToTicks(Duration duration) {
        return (int)(duration.toMillis() / 50L);
    }
}

