/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.world.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$", remap=Interface.Remap.NONE)})
public abstract class EntityMixin_API
implements Entity {
    @Shadow
    public float yRot;
    @Shadow
    public float xRot;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    protected UUID uuid;
    @Shadow
    @Final
    private net.minecraft.world.entity.EntityType<?> type;
    @Shadow
    public Level level;

    @Shadow
    public abstract double shadow$getX();

    @Shadow
    public abstract double shadow$getY();

    @Shadow
    public abstract double shadow$getZ();

    @Shadow
    public abstract Level shadow$getCommandSenderWorld();

    @Shadow
    @Nullable
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    public abstract boolean shadow$isRemoved();

    @Shadow
    public abstract UUID shadow$getUUID();

    @Shadow
    public abstract boolean shadow$hurt(net.minecraft.world.damagesource.DamageSource var1, float var2);

    @Shadow
    protected abstract void shadow$setRot(float var1, float var2);

    @Shadow
    public abstract AABB shadow$getBoundingBox();

    @Shadow
    public abstract void shadow$setRemoved(Entity.RemovalReason var1);

    @Shadow
    public abstract void shadow$discard();

    @Shadow
    public abstract void shadow$lookAt(EntityAnchorArgument.Anchor var1, Vec3 var2);

    @Shadow
    public abstract CompoundTag shadow$saveWithoutId(CompoundTag var1);

    @Override
    public RandomProvider.Source random() {
        return (RandomProvider.Source)this.random;
    }

    @Override
    public Vector3d position() {
        return new Vector3d(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
    }

    @Override
    public boolean setPosition(Vector3d position) {
        return ((EntityBridge)((Object)this)).bridge$setPosition(Objects.requireNonNull(position, "The position was null!"));
    }

    @Override
    public World<?, ?> world() {
        return (World)this.level;
    }

    public ServerLocation location() {
        return ServerLocation.of((ServerWorld)this.shadow$getCommandSenderWorld(), this.position());
    }

    @Override
    public boolean setLocation(ServerLocation location) {
        return ((EntityBridge)((Object)this)).bridge$setLocation(Objects.requireNonNull(location, "The location was null!"));
    }

    @Override
    public boolean setLocationAndRotation(ServerLocation location, Vector3d rotation) {
        if (this.setLocation(location)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    @Override
    public Vector3d scale() {
        return Vector3d.ONE;
    }

    @Override
    public void setScale(Vector3d scale) {
    }

    @Override
    public Transform transform() {
        return Transform.of(this.position(), this.rotation(), this.scale());
    }

    @Override
    public boolean setTransform(Transform transform) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return false;
        }
        Objects.requireNonNull(transform, "The transform cannot be null!");
        if (((EntityBridge)((Object)this)).bridge$setPosition(transform.position())) {
            this.setRotation(transform.rotation());
            this.setScale(transform.scale());
            return true;
        }
        return false;
    }

    @Override
    public boolean transferToWorld(ServerWorld world, Vector3d position) {
        Objects.requireNonNull(world, "World was null!");
        Objects.requireNonNull(position, "Position was null!");
        return this.setLocation(ServerLocation.of(world, position));
    }

    @Override
    public Vector3d rotation() {
        return new Vector3d(this.xRot, this.yRot, 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Objects.requireNonNull(rotation, "Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((net.minecraft.world.entity.Entity)this instanceof ServerPlayer && ((ServerPlayer)this).connection != null) {
            ((ServerPlayer)this).connection.teleport(this.position().x(), this.position().y(), this.position().z(), (float)rotation.y(), (float)rotation.x(), EnumSet.noneOf(RelativeMovement.class));
        } else {
            this.shadow$setRot((float)rotation.y(), (float)rotation.x());
        }
    }

    @Override
    public Optional<org.spongepowered.api.util.AABB> boundingBox() {
        AABB boundingBox = this.shadow$getBoundingBox();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Intrinsic
    public boolean entity$isRemoved() {
        return this.shadow$isRemoved();
    }

    @Override
    public boolean isLoaded() {
        return !this.shadow$isRemoved();
    }

    @Intrinsic
    public void entity$remove() {
        this.shadow$setRemoved(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public boolean damage(double damage, DamageSource damageSource) {
        if (!(damageSource instanceof net.minecraft.world.damagesource.DamageSource)) {
            SpongeCommon.logger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.shadow$hurt((net.minecraft.world.damagesource.DamageSource)damageSource, (float)damage);
    }

    public EntityType type() {
        return (EntityType)this.type;
    }

    @Override
    public UUID uniqueId() {
        return this.uuid;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
        CompoundTag compound = new CompoundTag();
        compound.putString("id", entityTypeRegistry.getKey((Object)((net.minecraft.world.entity.EntityType)this.type())).toString());
        this.shadow$saveWithoutId(compound);
        DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Entity.CLASS, this.getClass().getName()).set(Queries.WORLD_KEY, ((ServerWorld)this.world()).key().formatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, this.position().x()).set(Queries.POSITION_Y, this.position().y()).set(Queries.POSITION_Z, this.position().z()).container().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, this.rotation().x()).set(Queries.POSITION_Y, this.rotation().y()).set(Queries.POSITION_Z, this.rotation().z()).container().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, this.scale().x()).set(Queries.POSITION_Y, this.scale().y()).set(Queries.POSITION_Z, this.scale().z()).container().set(Constants.Entity.TYPE, entityTypeRegistry.getKey((Object)((net.minecraft.world.entity.EntityType)this.type()))).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        return container;
    }

    @Override
    public Entity copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
            CompoundTag compound = new CompoundTag();
            compound.putString("id", entityTypeRegistry.getKey((Object)((net.minecraft.world.entity.EntityType)this.type())).toString());
            this.shadow$saveWithoutId(compound);
            net.minecraft.world.entity.Entity entity = net.minecraft.world.entity.EntityType.loadEntityRecursive((CompoundTag)compound, (Level)this.shadow$getCommandSenderWorld(), createdEntity -> {
                createdEntity.setUUID(UUID.randomUUID());
                return createdEntity;
            });
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public boolean canSee(Entity entity) {
        return !((VanishableBridge)((Object)entity)).bridge$vanishState().invisible();
    }

    @Override
    public void lookAt(Vector3d targetPos) {
        Vec3 vec = VecHelper.toVanillaVector3d(targetPos);
        this.shadow$lookAt(EntityAnchorArgument.Anchor.EYES, vec);
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return (EntitySnapshot)EntitySnapshot.builder().from(this).build();
    }

    @Override
    public EntityArchetype createArchetype() {
        return SpongeEntityArchetypeBuilder.pooled().from(this).build();
    }

    @Override
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(UnaryOperator<HoverEvent.ShowEntity> op) {
        Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
        ResourceLocation entityTypeKey = entityTypeRegistry.getKey((Object)((net.minecraft.world.entity.EntityType)this.type()));
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)((Key)entityTypeKey), (UUID)this.uniqueId(), (Component)((Component)this.displayName().get())))));
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        HashSet values = new HashSet();
        values.add(this.requireValue(Keys.AGE).asImmutable());
        values.add(this.requireValue(Keys.BASE_SIZE).asImmutable());
        values.add(this.requireValue(Keys.DISPLAY_NAME).asImmutable());
        values.add(this.requireValue(Keys.EYE_HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.EYE_POSITION).asImmutable());
        values.add(this.requireValue(Keys.FALL_DISTANCE).asImmutable());
        values.add(this.requireValue(Keys.FIRE_DAMAGE_DELAY).asImmutable());
        values.add(this.requireValue(Keys.FROZEN_TIME).asImmutable());
        values.add(this.requireValue(Keys.HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABILITY_TICKS).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABLE).asImmutable());
        values.add(this.requireValue(Keys.IS_CUSTOM_NAME_VISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_GLOWING).asImmutable());
        values.add(this.requireValue(Keys.IS_GRAVITY_AFFECTED).asImmutable());
        values.add(this.requireValue(Keys.IS_INVISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_SILENT).asImmutable());
        values.add(this.requireValue(Keys.IS_SNEAKING).asImmutable());
        values.add(this.requireValue(Keys.IS_SPRINTING).asImmutable());
        values.add(this.requireValue(Keys.IS_WET).asImmutable());
        values.add(this.requireValue(Keys.MAX_AIR).asImmutable());
        values.add(this.requireValue(Keys.MAX_FROZEN_TIME).asImmutable());
        values.add(this.requireValue(Keys.ON_GROUND).asImmutable());
        values.add(((ListValue)this.requireValue(Keys.PASSENGERS)).asImmutable());
        values.add(this.requireValue(Keys.REMAINING_AIR).asImmutable());
        values.add(this.requireValue(Keys.SCALE).asImmutable());
        values.add(((SetValue)this.requireValue(Keys.SCOREBOARD_TAGS)).asImmutable());
        values.add(this.requireValue(Keys.TRANSIENT).asImmutable());
        values.add(this.requireValue(Keys.VANISH_STATE).asImmutable());
        values.add(this.requireValue(Keys.VELOCITY).asImmutable());
        this.getValue(Keys.BASE_VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CREATOR).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CUSTOM_NAME).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.FIRE_TICKS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.NOTIFIER).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SWIFTNESS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    @Override
    public Component teamRepresentation() {
        return Component.text((String)this.shadow$getUUID().toString());
    }
}

