/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.accessor.network.Connection_PacketHolderAccessor;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.util.Constants;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin
extends SimpleChannelInboundHandler<Packet<?>>
implements ConnectionBridge {
    @Shadow
    private PacketListener packetListener;
    @Shadow
    private Channel channel;
    @Shadow
    private boolean disconnectionHandled;
    @Shadow
    @Final
    private Queue<Connection_PacketHolderAccessor> queue;
    private final TransactionStore impl$transactionStore = new TransactionStore(() -> (EngineConnection)this.packetListener);
    private final Set<ResourceKey> impl$registeredChannels = Sets.newConcurrentHashSet();
    @Nullable
    private InetSocketAddress impl$virtualHost;
    @Nullable
    private MinecraftVersion impl$version;
    @Nullable
    private Component impl$kickReason;
    private ClientType impl$clientType = ClientType.VANILLA;
    private volatile boolean impl$disconnected;

    @Shadow
    public abstract SocketAddress getRemoteAddress();

    @Override
    public TransactionStore bridge$getTransactionStore() {
        return this.impl$transactionStore;
    }

    @Override
    public Set<ResourceKey> bridge$getRegisteredChannels() {
        return this.impl$registeredChannels;
    }

    @Override
    public ClientType bridge$getClientType() {
        return this.impl$clientType;
    }

    @Override
    public void bridge$setClientType(ClientType clientType) {
        this.impl$clientType = clientType;
    }

    @Override
    public InetSocketAddress bridge$getAddress() {
        SocketAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress bridge$getVirtualHost() {
        if (this.impl$virtualHost != null) {
            return this.impl$virtualHost;
        }
        SocketAddress local = this.channel.localAddress();
        if (local instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void bridge$setVirtualHost(String host, int port) {
        try {
            this.impl$virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.channel.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.impl$virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    @Nullable
    public Component bridge$getKickReason() {
        return this.impl$kickReason;
    }

    @Override
    public void bridge$setKickReason(Component component) {
        this.impl$kickReason = component;
    }

    @Override
    public MinecraftVersion bridge$getVersion() {
        return this.impl$version;
    }

    @Override
    public void bridge$setVersion(int version) {
        this.impl$version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSend(Packet<?> $$0, @Nullable PacketSendListener $$1, CallbackInfo ci) {
        if (this.disconnectionHandled) {
            if ($$1 instanceof PacketSender.SpongePacketSendListener) {
                PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$1;
                spongeListener.accept(new IOException("Connection has been closed."));
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleDisconnection"}, at={@At(value="FIELD", target="Lnet/minecraft/network/Connection;disconnectionHandled:Z", opcode=181, shift=At.Shift.AFTER)})
    private void impl$onDisconnected(CallbackInfo ci) {
        Connection_PacketHolderAccessor packetHolder;
        while ((packetHolder = this.queue.poll()) != null) {
            PacketSendListener packetSendListener = packetHolder.accessor$listener();
            if (!(packetSendListener instanceof PacketSender.SpongePacketSendListener)) continue;
            PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)packetSendListener;
            spongeListener.accept(new IOException("Connection has been closed."));
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;awaitUninterruptibly()Lio/netty/channel/ChannelFuture;")}, cancellable=true)
    private void impl$disconnectAsync(CallbackInfo ci) {
        ci.cancel();
        this.impl$disconnected = true;
    }

    @Inject(method={"isConnected"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onIsConnected(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$disconnected) {
            cir.setReturnValue((Object)false);
        }
    }
}

