/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTicks;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.event.world.ChangeWeatherEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.PlatformServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.bridge.world.ticks.LevelTicksBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.LevelMixin;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends LevelMixin
implements ServerLevelBridge,
PlatformServerLevelBridge,
ResourceKeyBridge {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;
    @Shadow
    @Final
    private LevelTicks<Block> blockTicks;
    @Shadow
    @Final
    private LevelTicks<Fluid> fluidTicks;
    @Shadow
    private int emptyTime;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    @Mutable
    @Nullable
    private EndDragonFight dragonFight;
    private final long[] impl$recentTickTimes = new long[100];
    private LevelStorageSource.LevelStorageAccess impl$levelSave;
    private CustomBossEvents impl$bossBarManager;
    private ChunkProgressListener impl$chunkStatusListener;
    private Weather impl$prevWeather;
    private boolean impl$isManualSave = false;
    private long impl$preTickTime = 0L;

    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    protected abstract void shadow$saveLevelData();

    @Shadow
    public abstract void levelEvent(@org.jetbrains.annotations.Nullable Player var1, int var2, BlockPos var3, int var4);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$cacheLevelSave(MinecraftServer $$0, Executor $$1, LevelStorageSource.LevelStorageAccess $$2, ServerLevelData $$3, net.minecraft.resources.ResourceKey $$4, LevelStem $$5, ChunkProgressListener $$6, boolean $$7, long $$8, List $$9, boolean $$10, CallbackInfo ci) {
        this.impl$levelSave = $$2;
        this.impl$chunkStatusListener = $$6;
        this.impl$prevWeather = ((ServerWorld)((Object)this)).weather();
        ((LevelTicksBridge)this.blockTicks).bridge$setGameTimeSupplier(() -> ((WritableLevelData)this.levelData).getGameTime());
        ((LevelTicksBridge)this.fluidTicks).bridge$setGameTimeSupplier(() -> ((WritableLevelData)this.levelData).getGameTime());
        Boolean createDragonFight = ((DimensionTypeBridge)this.shadow$dimensionType()).bridge$createDragonFight();
        if (createDragonFight != null) {
            if (createDragonFight.booleanValue()) {
                long seed = $$0.getWorldData().worldGenOptions().seed();
                this.dragonFight = new EndDragonFight((ServerLevel)this, seed, $$0.getWorldData().endDragonFightData());
            } else {
                this.dragonFight = null;
            }
        }
    }

    @Redirect(method={"getSeed"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/WorldData;worldGenOptions()Lnet/minecraft/world/level/levelgen/WorldOptions;"))
    public WorldOptions impl$onGetSeed(WorldData iServerConfiguration) {
        return ((PrimaryLevelData)this.serverLevelData).worldGenOptions();
    }

    @Override
    public LevelStorageSource.LevelStorageAccess bridge$getLevelSave() {
        return this.impl$levelSave;
    }

    @Override
    public ChunkProgressListener bridge$getChunkStatusListener() {
        return this.impl$chunkStatusListener;
    }

    @Override
    public boolean bridge$isLoaded() {
        if (this.bridge$isFake()) {
            return false;
        }
        ServerLevel world = this.shadow$getServer().getLevel(this.shadow$dimension());
        if (world == null) {
            return false;
        }
        return world == this;
    }

    @Override
    public void bridge$adjustDimensionLogic(DimensionType dimensionType) {
        if (this.bridge$isFake()) {
            return;
        }
        super.bridge$adjustDimensionLogic(dimensionType);
        this.impl$setWorldOnBorder();
    }

    @Override
    public CustomBossEvents bridge$getBossBarManager() {
        if (this.impl$bossBarManager == null) {
            this.impl$bossBarManager = Level.OVERWORLD.equals(this.shadow$dimension()) || this.bridge$isFake() ? this.shadow$getServer().getCustomBossEvents() : new CustomBossEvents();
        }
        return this.impl$bossBarManager;
    }

    @Override
    public void bridge$triggerExplosion(Explosion explosion) {
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.getCauseStackManager().currentCause(), explosion, (ServerWorld)((Object)this));
            if (SpongeCommon.post(event)) {
                return;
            }
            explosion = event.explosion();
        }
        net.minecraft.world.level.Explosion mcExplosion = (net.minecraft.world.level.Explosion)explosion;
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((net.minecraft.world.level.Explosion)explosion).source(explosion.sourceExplosive().isPresent() ? explosion.sourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean shouldBreakBlocks = explosion.shouldBreakBlocks();
            mcExplosion.explode();
            mcExplosion.finalizeExplosion(explosion.shouldPlaySmoke());
            if (!shouldBreakBlocks) {
                mcExplosion.clearToBlow();
            }
        }
    }

    @Override
    public void bridge$setManualSave(boolean state) {
        this.impl$isManualSave = state;
    }

    @Override
    public BlockSnapshot bridge$createSnapshot(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!((ServerLevel)this).isInWorldBounds(pos)) {
            return BlockSnapshot.empty();
        }
        if (!this.hasChunk(x >> 4, z >> 4)) {
            return BlockSnapshot.empty();
        }
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.world((ServerLevel)this).position(new Vector3i(x, y, z));
        LevelChunk chunk = this.shadow$getChunkAt(pos);
        BlockState state = chunk.getBlockState(pos);
        builder.blockState(state);
        BlockEntity blockEntity = chunk.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos).ifPresent(builder::creator);
        ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public ResourceKey bridge$getKey() {
        return (ResourceKey)this.shadow$dimension().location();
    }

    @Override
    public long[] bridge$recentTickTimes() {
        return this.impl$recentTickTimes;
    }

    @Redirect(method={"saveLevelData"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorldData()Lnet/minecraft/world/level/storage/WorldData;"))
    private WorldData impl$usePerWorldLevelDataForDragonFight(MinecraftServer server) {
        return (WorldData)this.shadow$getLevelData();
    }

    @Redirect(method={"setDefaultSpawnPos"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerChunkCache;addRegionTicket(Lnet/minecraft/server/level/TicketType;Lnet/minecraft/world/level/ChunkPos;ILjava/lang/Object;)V"))
    private void impl$respectKeepSpawnLoaded(ServerChunkCache serverChunkProvider, TicketType<Object> p_217228_1_, ChunkPos p_217228_2_, int p_217228_3_, Object p_217228_4_) {
        if (((ServerWorldProperties)this.shadow$getLevelData()).performsSpawnLogic()) {
            serverChunkProvider.addRegionTicket(p_217228_1_, p_217228_2_, p_217228_3_, p_217228_4_);
        }
    }

    @Overwrite
    public void save(@Nullable ProgressListener progress, boolean flush, boolean skipSave) {
        boolean isManualSave = this.impl$isManualSave;
        this.impl$isManualSave = false;
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        if (Sponge.eventManager().post(SpongeEventFactory.createSaveWorldEventPre(currentCause, (ServerWorld)((Object)this)))) {
            return;
        }
        PrimaryLevelData levelData = (PrimaryLevelData)this.shadow$getLevelData();
        ServerChunkCache chunkProvider = ((ServerLevel)this).getChunkSource();
        if (!skipSave) {
            SerializationBehavior behavior = ((PrimaryLevelDataBridge)levelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            if (progress != null) {
                progress.progressStartNoAbort((Component)Component.translatable((String)"menu.savingLevel"));
            }
            if (behavior != SerializationBehavior.NONE) {
                this.shadow$saveLevelData();
                levelData.setWorldBorder(this.getWorldBorder().createSettings());
                levelData.setCustomBossEvents(this.bridge$getBossBarManager().save());
                this.bridge$getLevelSave().saveDataTag((RegistryAccess)SpongeCommon.server().registryAccess(), (WorldData)((PrimaryLevelData)this.shadow$getLevelData()), this.shadow$dimension() == Level.OVERWORLD ? SpongeCommon.server().getPlayerList().getSingleplayerData() : null);
            }
            if (progress != null) {
                progress.progressStage((Component)Component.translatable((String)"menu.savingChunks"));
            }
            if (behavior == SerializationBehavior.AUTOMATIC || isManualSave && behavior == SerializationBehavior.MANUAL) {
                chunkProvider.save(flush);
            }
            Sponge.eventManager().post(SpongeEventFactory.createSaveWorldEventPost(currentCause, (ServerWorld)((Object)this)));
        }
    }

    @Inject(method={"advanceWeatherCycle"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerLevel;oRainLevel:F", shift=At.Shift.BEFORE, ordinal=1)})
    public void impl$onSetWeatherParameters(CallbackInfo ci, boolean $$0) {
        boolean isRaining = this.shadow$isRaining();
        if (this.oRainLevel != this.rainLevel || this.oThunderLevel != this.thunderLevel || $$0 != isRaining) {
            Weather newWeather = ((ServerWorld)((Object)this)).properties().weather();
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            Transaction<Weather> weatherTransaction = new Transaction<Weather>(this.impl$prevWeather, newWeather);
            ChangeWeatherEvent event = SpongeEventFactory.createChangeWeatherEvent(currentCause, (ServerWorld)((Object)this), weatherTransaction);
            newWeather = Sponge.eventManager().post(event) ? event.weather().original() : event.weather().finalReplacement();
            this.impl$prevWeather = newWeather;
            if (newWeather.type() == WeatherTypes.CLEAR.get()) {
                this.serverLevelData.setThunderTime(0);
                this.serverLevelData.setRainTime(0);
                this.serverLevelData.setClearWeatherTime((int)newWeather.remainingDuration().ticks());
                this.serverLevelData.setThundering(false);
                this.serverLevelData.setRaining(false);
            } else {
                int newTime = (int)newWeather.remainingDuration().ticks();
                this.serverLevelData.setRaining(true);
                this.serverLevelData.setClearWeatherTime(0);
                this.serverLevelData.setRainTime(newTime);
                if (newWeather.type() == WeatherTypes.THUNDER.get()) {
                    this.serverLevelData.setThunderTime(newTime);
                    this.serverLevelData.setThundering(true);
                } else {
                    this.serverLevelData.setThunderTime(0);
                    this.serverLevelData.setThundering(false);
                }
            }
        }
    }

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRainingAt(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean impl$onBeforeThunder(ServerLevel serverLevel, BlockPos param0) {
        boolean rainingAt = serverLevel.isRainingAt(param0);
        if (rainingAt) {
            LightningEvent.Pre strike = SpongeEventFactory.createLightningEventPre(Sponge.server().causeStackManager().currentCause());
            if (Sponge.eventManager().post(strike)) {
                return false;
            }
        }
        return rainingAt;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void impl$capturePreTickTime(BooleanSupplier param0, CallbackInfo ci) {
        this.impl$preTickTime = Util.getNanos();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void impl$capturePostTickTime(BooleanSupplier param0, CallbackInfo ci) {
        long postTickTime = Util.getNanos();
        this.impl$recentTickTimes[this.shadow$getServer().getTickCount() % 100] = postTickTime - this.impl$preTickTime;
    }

    private void impl$setWorldOnBorder() {
        ((WorldBorderBridge)this.shadow$getWorldBorder()).bridge$setAssociatedWorld(this.bridge$getKey());
    }

    @Inject(method={"globalLevelEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastGlobalEvent(int effectID, BlockPos pos, int pitch, CallbackInfo ci) {
        if (!this.bridge$isFake() && ShouldFire.PLAY_SOUND_EVENT_BROADCAST) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
                PlaySoundEvent.Broadcast event = SpongeCommonEventFactory.callPlaySoundBroadcastEvent(frame, this, pos, effectID);
                if (event != null && event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"levelEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastEvent(Player player, int eventID, BlockPos pos, int dataID, CallbackInfo ci) {
        if (eventID == 1010 && ShouldFire.PLAY_SOUND_EVENT_FROM_JUKEBOX) {
            try (CauseStackManager.StackFrame frame = Sponge.server().causeStackManager().pushCauseFrame();){
                BlockEntity tileEntity = this.shadow$getBlockEntity(pos);
                if (tileEntity instanceof JukeboxBlockEntity) {
                    JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
                    ItemStack record = jukebox.getItem(0);
                    frame.pushCause(jukebox);
                    frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(record));
                    if (!record.isEmpty()) {
                        Optional<MusicDisc> recordProperty = ((org.spongepowered.api.item.inventory.ItemStack)record).get(Keys.MUSIC_DISC);
                        if (!recordProperty.isPresent()) {
                            return;
                        }
                        MusicDisc recordType = recordProperty.get();
                        PlaySoundEvent.FromJukebox event = SpongeCommonEventFactory.callPlaySoundFromJukeboxEvent(frame.currentCause(), jukebox, recordType, dataID);
                        if (event.isCancelled()) {
                            ci.cancel();
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"gameEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ignoreGameEventsForVanishedEntities(GameEvent $$0, Vec3 $$1, GameEvent.Context $$2, CallbackInfo ci) {
        VanishableBridge bridge;
        Entity entity = $$2.sourceEntity();
        if (entity instanceof VanishableBridge && !(bridge = (VanishableBridge)entity).bridge$vanishState().triggerVibrations()) {
            ci.cancel();
        }
    }

    @Redirect(method={"lambda$onBlockStateChange$14"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/village/poi/PoiManager;add(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Holder;)V"))
    private void impl$avoidAddingPoiUpdatesOnUnloadedWorld(PoiManager manager, BlockPos pos, Holder<PoiType> type) {
        if (!SpongeCommon.server().levelKeys().contains(this.shadow$dimension())) {
            return;
        }
        manager.add(pos, type);
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerLevel;emptyTime:I", opcode=181, shift=At.Shift.AFTER)})
    private void impl$unloadBlockEntities(BooleanSupplier param0, CallbackInfo ci) {
        if (this.emptyTime >= 300 && !this.blockEntityTickers.isEmpty()) {
            this.blockEntityTickers.removeIf(TickingBlockEntity::isRemoved);
        }
    }

    public String toString() {
        Optional<ResourceKey> worldTypeKey = Optional.ofNullable(this.server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getKey((Object)this.shadow$dimensionType())).map(ResourceKey.class::cast);
        return new StringJoiner(",", ServerLevel.class.getSimpleName() + "[", "]").add("key=" + this.shadow$dimension()).add("worldType=" + worldTypeKey.map(Object::toString).orElse("inline")).toString();
    }
}

