/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.RandomSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.server.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ServerLoginPacketListenerImplBridge,
ConnectionHolderBridge {
    @Shadow
    @Final
    @Mutable
    private static RandomSource RANDOM = RandomSource.createThreadSafe();
    @Shadow
    @Final
    public Connection connection;
    @Shadow
    GameProfile gameProfile;
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    ServerLoginPacketListenerImpl.State state;
    @Shadow
    private ServerPlayer delayedAcceptPlayer;
    private boolean impl$accepted = false;

    @Shadow
    protected abstract GameProfile shadow$createFakeProfile(GameProfile var1);

    @Shadow
    public abstract void shadow$disconnect(Component var1);

    @Shadow
    protected abstract void shadow$placeNewPlayer(ServerPlayer var1);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Inject(method={"handleAcceptedLogin"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;", ordinal=0)})
    public void impl$onHandleAcceptedLogin(CallbackInfo ci) {
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;placeNewPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void impl$catchErrorWhenTickingNewPlayer(ServerLoginPacketListenerImpl playerList, ServerPlayer param0) {
        try {
            this.shadow$placeNewPlayer(param0);
        }
        catch (Exception e) {
            this.impl$disconnectError(e, true);
        }
    }

    private void impl$disconnectError(Throwable throwable, boolean gameDisconnect) {
        SpongeCommon.logger().error("Forcibly disconnecting user {} due to an error during login.", (Object)this.gameProfile, (Object)throwable);
        MutableComponent message = Component.literal((String)"Internal Server Error: unable to complete login.");
        if (gameDisconnect) {
            this.connection.send((Packet)new ClientboundDisconnectPacket((Component)message), PacketSendListener.thenRun(() -> this.lambda$impl$disconnectError$4((Component)message)));
        } else {
            this.shadow$disconnect((Component)message);
        }
    }

    private void impl$disconnectClient(net.kyori.adventure.text.Component disconnectMessage) {
        Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$disconnect(reason);
    }

    @Override
    public boolean bridge$fireAuthEvent() {
        TextComponent disconnectMessage = net.kyori.adventure.text.Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (net.kyori.adventure.text.Component)disconnectMessage, (net.kyori.adventure.text.Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.message());
        }
        return event.isCancelled();
    }

    private /* synthetic */ void lambda$impl$disconnectError$4(Component message) {
        this.connection.disconnect(message);
    }

    private /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$3(Throwable throwable) {
        if (throwable != null) {
            this.impl$disconnectError(throwable, this.state == ServerLoginPacketListenerImpl.State.ACCEPTED || this.state == ServerLoginPacketListenerImpl.State.READY_TO_ACCEPT);
        }
        return null;
    }

    private /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$2(Object ignored, Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException(throwable);
        }
        this.state = ServerLoginPacketListenerImpl.State.ACCEPTED;
        if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
            this.connection.send((Packet)new ClientboundLoginCompressionPacket(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
        }
        this.connection.send((Packet)new ClientboundGameProfilePacket(this.gameProfile));
        ServerPlayer var1 = this.server.getPlayerList().getPlayer(this.gameProfile.getId());
        if (var1 != null) {
            this.state = ServerLoginPacketListenerImpl.State.DELAY_ACCEPT;
        } else {
            ServerSideConnection connection = (ServerSideConnection)((Object)this);
            ((SpongeChannelManager)Sponge.channelManager()).sendChannelRegistrations(connection);
            try {
                Sponge.server().userManager().removeFromCache(this.gameProfile.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private /* synthetic */ Object lambda$impl$onHandleAcceptedLogin$0(Component componentOpt, Throwable throwable) {
        if (throwable != null) {
            ((ConnectionBridge)this.connection).bridge$setKickReason((Component)Component.literal((String)"An error occurred checking ban/whitelist status."));
            SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.gameProfile.getId().toString());
            SpongeCommon.logger().error((Object)throwable);
        } else if (componentOpt != null) {
            ((ConnectionBridge)this.connection).bridge$setKickReason(componentOpt);
        }
        try {
            ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.gameProfile);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
        return null;
    }
}

