/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.block.entity.AbstractFurnaceBlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.block.entity.BaseContainerBlockEntityMixin;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends BaseContainerBlockEntityMixin
implements AbstractFurnaceBlockEntityBridge {
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    int cookingProgress;
    @Shadow
    int cookingTotalTime;
    @Shadow
    @Final
    private RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    private static void impl$throwFuelEventIfOrShrink(ItemStack itemStack, int quantity, Level var0, BlockPos var1, BlockState var2, AbstractFurnaceBlockEntity entity) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf(itemStack);
        ItemStackSnapshot shrinkedFuel = ItemStackUtil.snapshotOf(ItemStackUtil.cloneDefensive(itemStack, itemStack.getCount() - 1));
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(fuel, shrinkedFuel);
        AbstractCookingRecipe recipe = ((AbstractFurnaceBlockEntityMixin)entity).impl$getCurrentRecipe();
        CookingEvent.ConsumeFuel event = SpongeEventFactory.createCookingEventConsumeFuel(cause, (FurnaceBlockEntity)entity, Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.singletonList(transaction));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            ((AbstractFurnaceBlockEntityMixin)entity).cookingTotalTime = 0;
            return;
        }
        if (!transaction.isValid()) {
            return;
        }
        if (transaction.custom().isPresent()) {
            ((AbstractFurnaceBlockEntityMixin)entity).items.set(1, (Object)ItemStackUtil.fromSnapshotToNative(transaction.finalReplacement()));
        } else {
            itemStack.shrink(quantity);
        }
    }

    @Override
    public AbstractCookingRecipe impl$getCurrentRecipe() {
        return this.quickCheck.getRecipeFor((Container)((AbstractFurnaceBlockEntity)this), this.level).orElse(null);
    }

    @Inject(method={"setItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)I")})
    private void impl$interruptSmelt(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    @Inject(method={"serverTick"}, at={@At(shift=At.Shift.BEFORE, value="FIELD", opcode=181, target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;burn(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/item/crafting/Recipe;Lnet/minecraft/core/NonNullList;I)Z"), to=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"))})
    private static void impl$onResetCookTimePassive(Level level, BlockPos pos, BlockState state, @Coerce AbstractFurnaceBlockEntityMixin entity, CallbackInfo ci) {
        entity.impl$callInteruptSmeltEvent();
    }

    private void impl$callInteruptSmeltEvent() {
        if (this.cookingProgress > 0) {
            ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
            Cause cause = PhaseTracker.getCauseStackManager().currentCause();
            AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
            CookingEvent.Interrupt event = SpongeEventFactory.createCookingEventInterrupt(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe));
            SpongeCommon.post(event);
        }
    }
}

