/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.ipforward.server.network;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.applaunch.config.common.IpForwardingCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.network.ConnectionBridge_IpForward;
import org.spongepowered.common.ipforward.velocity.VelocityForwardingInfo;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin_IpForward {
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    public Connection connection;
    @Shadow
    private GameProfile gameProfile;
    private boolean ipForward$sentVelocityForwardingRequest;

    @Inject(method={"handleHello"}, at={@At(value="HEAD")}, cancellable=true)
    private void ipForward$sendVelocityIndicator(CallbackInfo info) {
        if (!this.server.usesAuthentication() && SpongeConfigs.getCommon().get().ipForwarding.mode == IpForwardingCategory.Mode.MODERN) {
            Preconditions.checkState((!this.ipForward$sentVelocityForwardingRequest ? 1 : 0) != 0, (Object)"Sent additional login start message!");
            this.ipForward$sentVelocityForwardingRequest = true;
            VelocityForwardingInfo.sendQuery((ServerLoginPacketListenerImpl)this);
            info.cancel();
        }
    }

    @Inject(method={"handleHello"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;gameProfile:Lcom/mojang/authlib/GameProfile;", opcode=181, ordinal=1, shift=At.Shift.AFTER)})
    private void bungee$initUuid(CallbackInfo ci) {
        if (!this.server.usesAuthentication() && SpongeConfigs.getCommon().get().ipForwarding.mode == IpForwardingCategory.Mode.LEGACY) {
            UUID uuid = ((ConnectionBridge_IpForward)this.connection).bungeeBridge$getSpoofedUUID() != null ? ((ConnectionBridge_IpForward)this.connection).bungeeBridge$getSpoofedUUID() : UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.gameProfile.getName()).getBytes(Charsets.UTF_8));
            this.gameProfile = new GameProfile(uuid, this.gameProfile.getName());
            if (((ConnectionBridge_IpForward)this.connection).bungeeBridge$getSpoofedProfile() != null) {
                for (Property property : ((ConnectionBridge_IpForward)this.connection).bungeeBridge$getSpoofedProfile()) {
                    this.gameProfile.getProperties().put((Object)property.getName(), (Object)property);
                }
            }
        }
    }
}

