/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.entityactivation;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.AABB;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.explosive.fused.FusedExplosive;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.level.entity.PersistentEntitySectionManagerAccessor;
import org.spongepowered.common.accessor.world.phys.AABBAccessor;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.activation.ActivationCapabilityBridge;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.EntityActivationRangeCategory;
import org.spongepowered.common.config.inheritable.GlobalConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

public final class EntityActivationRange {
    private static final ImmutableMap<Byte, String> activationTypeMappings = new ImmutableMap.Builder().put((Object)1, (Object)"monster").put((Object)2, (Object)"creature").put((Object)3, (Object)"aquatic").put((Object)4, (Object)"ambient").put((Object)5, (Object)"misc").build();
    static AABB maxBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB miscBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB creatureBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB monsterBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB aquaticBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB ambientBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AABB tileEntityBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static Map<Byte, Integer> maxActivationRanges = new HashMap<Byte, Integer>();

    public static byte initializeEntityActivationType(Entity entity) {
        if (entity instanceof Enemy) {
            return 1;
        }
        if (entity instanceof Animal) {
            return 2;
        }
        if (entity instanceof WaterAnimal) {
            return 3;
        }
        if (entity instanceof AmbientCreature) {
            return 4;
        }
        return 5;
    }

    public static void initializeEntityActivationState(Entity entity) {
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        if (entity.level.isClientSide()) {
            return;
        }
        if (entity instanceof Player && !((PlatformEntityBridge)entity).bridge$isFakePlayer() || entity instanceof ThrowableProjectile || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof AbstractHurtingProjectile || entity instanceof LightningBolt || entity instanceof PrimedTnt || entity instanceof Painting || entity instanceof EndCrystal || entity instanceof FireworkRocketEntity || entity instanceof FallingBlockEntity) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.getForWorld(entity.level);
        EntityActivationRangeCategory config = ((WorldConfig)configAdapter.get()).entityActivationRange;
        EntityTypeBridge type = (EntityTypeBridge)entity.getType();
        ResourceLocation key = EntityType.getKey((EntityType)entity.getType());
        byte activationType = spongeEntity.activation$getActivationType();
        String activationTypeName = (String)activationTypeMappings.getOrDefault((Object)activationType, (Object)"misc");
        if (!type.bridge$isActivationRangeInitialized()) {
            EntityActivationRange.addEntityToConfig(config.autoPopulate, key, activationType, activationTypeName);
            type.bridge$setActivationRangeInitialized(true);
        }
        EntityActivationRangeCategory.ModSubCategory entityMod = config.mods.get(key.getNamespace());
        int defaultActivationRange = config.globalRanges.get(activationTypeName);
        if (entityMod == null) {
            spongeEntity.activation$setActivationRange(defaultActivationRange);
            if (defaultActivationRange > 0) {
                spongeEntity.activation$setDefaultActivationState(false);
            }
        } else {
            if (!entityMod.enabled) {
                spongeEntity.activation$setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = entityMod.defaultRanges.get(activationTypeName);
            Integer entityActivationRange = entityMod.entities.get(key.getPath());
            if (defaultModActivationRange != null && entityActivationRange == null) {
                spongeEntity.activation$setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            } else if (entityActivationRange != null) {
                spongeEntity.activation$setActivationRange(entityActivationRange);
                if (entityActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            }
        }
    }

    public static AABB growBb(AABB target, AABB source, int x, int y, int z) {
        ((AABBAccessor)target).accessor$setMinX(source.minX - (double)x);
        ((AABBAccessor)target).accessor$setMinY(source.minY - (double)y);
        ((AABBAccessor)target).accessor$setMinZ(source.minZ - (double)z);
        ((AABBAccessor)target).accessor$setMaxX(source.maxX + (double)x);
        ((AABBAccessor)target).accessor$setMaxY(source.maxY + (double)y);
        ((AABBAccessor)target).accessor$setMaxZ(source.maxZ + (double)z);
        return target;
    }

    public static void activateEntities(ServerLevel world) {
        if (((LevelBridge)world).bridge$isFake()) {
            return;
        }
        for (ServerPlayer player : world.players()) {
            int maxRange = 0;
            for (Integer range : maxActivationRanges.values()) {
                if (range <= maxRange) continue;
                maxRange = range;
            }
            maxRange = Math.min((((ServerWorld)world).properties().viewDistance() << 4) - 8, maxRange);
            ((ActivationCapabilityBridge)player).activation$setActivatedTick(SpongeCommon.server().getTickCount());
            AABB aabb = maxBB;
            EntityActivationRange.growBb(aabb, player.getBoundingBox(), maxRange, 256, maxRange);
            int i = Mth.floor((double)(aabb.minX / 16.0));
            int j = Mth.floor((double)(aabb.maxX / 16.0));
            int k = Mth.floor((double)(aabb.minZ / 16.0));
            int l = Mth.floor((double)(aabb.maxZ / 16.0));
            for (int i1 = i; i1 <= j; ++i1) {
                for (int j1 = k; j1 <= l; ++j1) {
                    LevelChunk chunk = world.getChunkSource().getChunkNow(i1, j1);
                    if (chunk == null) continue;
                    EntityActivationRange.activateChunkEntities(player, chunk);
                }
            }
        }
    }

    private static void activateChunkEntities(ServerPlayer player, LevelChunk chunk) {
        PersistentEntitySectionManager<Entity> entityManager = ((ServerLevelAccessor)chunk.getLevel()).accessor$getEntityManager();
        EntitySectionStorage entitySectionStorage = ((PersistentEntitySectionManagerAccessor)entityManager).accessor$sectionStorage();
        entitySectionStorage.getExistingSectionsInChunk(SectionPos.of((ChunkPos)chunk.getPos(), (int)0).asLong()).flatMap(EntitySection::getEntities).forEach(entity -> {
            if (!entity.chunkPosition().equals((Object)chunk.getPos())) {
                return;
            }
            ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
            long currentTick = SpongeCommon.server().getTickCount();
            if (!((TrackableBridge)entity).bridge$shouldTick()) {
                return;
            }
            if (currentTick <= spongeEntity.activation$getActivatedTick()) {
                return;
            }
            if (spongeEntity.activation$getDefaultActivationState()) {
                EntityActivationRange.initializeEntityActivationState(entity);
                spongeEntity.activation$setActivatedTick(currentTick);
                return;
            }
            AABB aabb = switch (spongeEntity.activation$getActivationType()) {
                case 5 -> miscBB;
                case 4 -> ambientBB;
                case 3 -> aquaticBB;
                case 2 -> creatureBB;
                default -> monsterBB;
            };
            int bbActivationRange = spongeEntity.activation$getActivationRange();
            EntityActivationRange.growBb(aabb, player.getBoundingBox(), bbActivationRange, 256, bbActivationRange);
            if (aabb.intersects(entity.getBoundingBox())) {
                spongeEntity.activation$setActivatedTick(currentTick);
            }
        });
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.isInWater() || ((EntityAccessor)entity).accessor$remainingFireTicks() > 0) {
            return true;
        }
        if (!(entity instanceof Projectile) ? !entity.getPassengers().isEmpty() || entity.getVehicle() != null : !entity.isOnGround()) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.hurtTime > 0 || living.getActiveEffects().size() > 0) {
                return true;
            }
            if (entity instanceof Mob && ((LivingEntity)entity).getLastHurtByMob() != null || ((LivingEntity)entity).getLastHurtMob() != null) {
                return true;
            }
            if (entity instanceof Villager && ((Villager)entity).canBreed()) {
                return true;
            }
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                if (animal.isBaby() || animal.isInLove()) {
                    return true;
                }
                if (entity instanceof Sheep && ((Sheep)entity).isSheared()) {
                    return true;
                }
            }
            return entity instanceof FusedExplosive && ((FusedExplosive)entity).get(Keys.IS_PRIMED).orElse(false) != false;
        }
        return false;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        if (entity instanceof Player || entity.level.isClientSide() || !entity.touchingUnloadedChunk() || entity instanceof FireworkRocketEntity) {
            return true;
        }
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.bridge$isActive()) {
            return false;
        }
        if (activeChunk.bridge$isPersistedChunk() || ((PlatformEntityBridge)entity).bridge$isFakePlayer() && entity instanceof ServerPlayer) {
            return true;
        }
        long currentTick = SpongeCommon.server().getTickCount();
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        boolean bl = isActive = spongeEntity.activation$getActivatedTick() >= currentTick || spongeEntity.activation$getDefaultActivationState();
        if (!isActive) {
            if ((currentTick - spongeEntity.activation$getActivatedTick() - 1L) % 20L == 0L) {
                if (EntityActivationRange.checkEntityImmunities(entity)) {
                    spongeEntity.activation$setActivatedTick(currentTick + 20L);
                }
                isActive = true;
            }
        } else if (!spongeEntity.activation$getDefaultActivationState() && entity.tickCount % 4 == 0 && !EntityActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        if (isActive && !activeChunk.bridge$areNeighborsLoaded()) {
            isActive = false;
        }
        return isActive;
    }

    public static void addEntityToConfig(boolean autoPopulate, ResourceLocation key, byte activationType, String activationTypeName) {
        Integer defaultRange;
        InheritableConfigHandle<GlobalConfig> globalConfig = SpongeGameConfigs.getGlobalInheritable();
        EntityActivationRangeCategory activationConfig = ((GlobalConfig)globalConfig.get()).entityActivationRange;
        boolean requiresSave = false;
        Integer range = defaultRange = activationConfig.globalRanges.getOrDefault(activationTypeName, 32);
        EntityActivationRangeCategory.ModSubCategory modSubCategory = activationConfig.mods.get(key.getNamespace());
        if (autoPopulate && modSubCategory == null) {
            modSubCategory = new EntityActivationRangeCategory.ModSubCategory();
            activationConfig.mods.put(key.getNamespace(), modSubCategory);
            requiresSave = true;
        }
        if (modSubCategory != null) {
            Integer modActivationRange = modSubCategory.defaultRanges.get(activationTypeName);
            if (autoPopulate && modActivationRange == null) {
                modSubCategory.defaultRanges.put(activationTypeName, defaultRange);
                requiresSave = true;
            } else if (modActivationRange != null && modActivationRange > range) {
                range = modActivationRange;
            }
            Integer entityActivationRange = modSubCategory.entities.get(key.getPath());
            if (autoPopulate && entityActivationRange == null) {
                modSubCategory.entities.put(key.getPath(), modSubCategory.defaultRanges.get(activationTypeName));
                requiresSave = true;
            }
            if (entityActivationRange != null && entityActivationRange > range) {
                range = entityActivationRange;
            }
        }
        int newRange = range;
        maxActivationRanges.compute(activationType, (k, maxRange) -> maxRange == null || newRange > maxRange ? newRange : maxRange);
        if (autoPopulate && requiresSave) {
            globalConfig.save();
        }
    }
}

