/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.level.storage.LevelResource;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.type.ArtType;
import org.spongepowered.api.data.type.ArtTypes;
import org.spongepowered.api.data.type.CatType;
import org.spongepowered.api.data.type.CatTypes;
import org.spongepowered.api.data.type.ComparatorMode;
import org.spongepowered.api.data.type.ComparatorModes;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.type.HandPreference;
import org.spongepowered.api.data.type.HandPreferences;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.type.LlamaType;
import org.spongepowered.api.data.type.LlamaTypes;
import org.spongepowered.api.data.type.ParrotType;
import org.spongepowered.api.data.type.ParrotTypes;
import org.spongepowered.api.data.type.RabbitType;
import org.spongepowered.api.data.type.RabbitTypes;
import org.spongepowered.api.data.type.StructureMode;
import org.spongepowered.api.data.type.StructureModes;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;
import org.spongepowered.math.vector.Vector3i;

public final class Constants {
    public static final String UUID = "UUID";
    public static final String UUID_MOST = "UUIDMost";
    public static final DataQuery UUID_MOST_QUERY = DataQuery.of("UUIDMost");
    public static final String UUID_LEAST = "UUIDLeast";
    public static final DataQuery UUID_LEAST_QUERY = DataQuery.of("UUIDLeast");
    public static final String MINECRAFT = "minecraft";
    public static final String MINECRAFT_CLIENT = "net.minecraft.client.Minecraft";
    public static final String DEDICATED_SERVER = "net.minecraft.server.dedicated.DedicatedServer";
    public static final String MINECRAFT_SERVER = "net.minecraft.server.MinecraftServer";
    public static final String INTEGRATED_SERVER = "net.minecraft.client.server.IntegratedServer";

    private Constants() {
    }

    public static final class Universe {

        public static final class Weather {
            public static final DataQuery TYPE = DataQuery.of("Type");
            public static final DataQuery REMAINING_DURATION = DataQuery.of("RemainingDuration");
            public static final DataQuery RUNNING_DURATION = DataQuery.of("RunningDuration");
        }
    }

    public static final class TickConversions {
        public static final int TICK_DURATION_MS = 50;
        public static final Duration EFFECTIVE_MINIMUM_DURATION = Duration.ofMillis(50L);
        public static final int MINECRAFT_DAY_TICKS = 24000;
        public static final int MINECRAFT_HOUR_TICKS = 1000;
        public static final double MINECRAFT_MINUTE_TICKS = 16.666666666666668;
        public static final double MINECRAFT_SECOND_TICKS = 0.2777777777777778;
        public static final int MINECRAFT_EPOCH_OFFSET = 6000;
    }

    public static final class KeyValueMatcher {
        public static final DataQuery VALUE = DataQuery.of("Value");
        public static final DataQuery OPERATOR = DataQuery.of("Operator");
        public static final DataQuery KEY = DataQuery.of("Key");
    }

    public static final class Channels {
        public static final int LOGIN_PAYLOAD_TRANSACTION_ID = Integer.MAX_VALUE;
        public static final int LOGIN_PAYLOAD_IGNORED_TRANSACTION_ID = 0x7FFFFFFE;
        public static final ResourceKey FML_LOGIN_WRAPPER_CHANNEL = ResourceKey.of("fml", "loginwrapper");
        public static final ResourceKey SPONGE_CHANNEL_REGISTRY = ResourceKey.sponge("channel_registry");
        public static final ResourceKey SPONGE_CLIENT_TYPE = ResourceKey.sponge("client_type");
        public static final ResourceKey REGISTER_KEY = ResourceKey.minecraft("register");
        public static final ResourceKey UNREGISTER_KEY = ResourceKey.minecraft("unregister");
    }

    public static final class DirectionFunctions {
        public static net.minecraft.core.Direction getFor(Direction direction) {
            switch ((Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)))) {
                case UP: {
                    return net.minecraft.core.Direction.UP;
                }
                case DOWN: {
                    return net.minecraft.core.Direction.DOWN;
                }
                case WEST: {
                    return net.minecraft.core.Direction.WEST;
                }
                case SOUTH: {
                    return net.minecraft.core.Direction.SOUTH;
                }
                case EAST: {
                    return net.minecraft.core.Direction.EAST;
                }
                case NORTH: {
                    return net.minecraft.core.Direction.NORTH;
                }
            }
            throw new IllegalArgumentException("No matching direction found for direction: " + direction);
        }

        public static Direction getFor(net.minecraft.core.Direction facing) {
            switch ((net.minecraft.core.Direction)Preconditions.checkNotNull((Object)facing)) {
                case UP: {
                    return Direction.UP;
                }
                case DOWN: {
                    return Direction.DOWN;
                }
                case WEST: {
                    return Direction.WEST;
                }
                case SOUTH: {
                    return Direction.SOUTH;
                }
                case EAST: {
                    return Direction.EAST;
                }
                case NORTH: {
                    return Direction.NORTH;
                }
            }
            throw new IllegalArgumentException("No matching enum facing direction found for direction: " + facing);
        }

        public static Direction checkDirectionToHorizontal(Direction dir) {
            switch (dir) {
                case EAST: {
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    break;
                }
                default: {
                    return Direction.NORTH;
                }
            }
            return dir;
        }

        public static Direction checkDirectionNotUp(Direction dir) {
            switch (dir) {
                case EAST: {
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    break;
                }
                case DOWN: {
                    break;
                }
                default: {
                    return Direction.NORTH;
                }
            }
            return dir;
        }

        public static Direction checkDirectionNotDown(Direction dir) {
            switch (dir) {
                case EAST: {
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    break;
                }
                case UP: {
                    break;
                }
                default: {
                    return Direction.NORTH;
                }
            }
            return dir;
        }

        public static Direction.Axis convertAxisToMinecraft(Axis axis) {
            switch (axis) {
                case X: {
                    return Direction.Axis.X;
                }
                case Y: {
                    return Direction.Axis.Y;
                }
                case Z: {
                    return Direction.Axis.Z;
                }
            }
            return Direction.Axis.X;
        }

        public static Axis convertAxisToSponge(Direction.Axis axis) {
            switch (axis) {
                case X: {
                    return Axis.X;
                }
                case Y: {
                    return Axis.Y;
                }
                case Z: {
                    return Axis.Z;
                }
            }
            return Axis.X;
        }
    }

    public static final class Command {
        public static final String TYPE = "type";
        public static final String ROOT = "root";
        public static final String LITERAL = "literal";
        public static final String ARGUMENT = "argument";
        public static final String CHILDREN = "children";
        public static final String PARSER = "parser";
        public static final String PROPERTIES = "properties";
        public static final String EXECUTABLE = "executable";
        public static final String REDIRECT = "redirect";
        public static final byte ROOT_NODE_BIT = 0;
        public static final byte LITERAL_NODE_BIT = 1;
        public static final byte ARGUMENT_NODE_BIT = 2;
        public static final byte EXECUTABLE_BIT = 4;
        public static final byte REDIRECT_BIT = 8;
        public static final byte CUSTOM_SUGGESTIONS_BIT = 16;
        public static final ArgumentType<?> STANDARD_STRING_ARGUMENT_TYPE = StringArgumentType.string();
        public static final ArgumentType<?> GREEDY_STRING_ARGUMENT_TYPE = StringArgumentType.greedyString();
        public static final ArgumentType<?> NBT_ARGUMENT_TYPE = CompoundTagArgument.compoundTag();
        public static final ResourceLocationArgument RESOURCE_LOCATION_TYPE = ResourceLocationArgument.id();
        public static final String COMMAND_BLOCK_COMMAND = "";
        public static final String SELECTOR_COMMAND = "@";
        public static final String SPONGE_HELP_COMMAND = "sponge:help";
    }

    public static final class Functional {
        public static final Comparator<DataContentUpdater> DATA_CONTENT_UPDATER_COMPARATOR = (o1, o2) -> ComparisonChain.start().compare(o2.inputVersion(), o1.inputVersion()).compare(o2.outputVersion(), o1.outputVersion()).result();

        public static Comparator<Integer> intComparator() {
            return Integer::compareTo;
        }

        public static Comparator<Long> longComparator() {
            return Long::compareTo;
        }

        public static Comparator<Short> shortComparator() {
            return Short::compareTo;
        }

        public static Comparator<Byte> byteComparator() {
            return Byte::compareTo;
        }

        public static Comparator<Double> doubleComparator() {
            return Double::compareTo;
        }

        public static Comparator<Float> floatComparator() {
            return Float::compareTo;
        }
    }

    public static final class Scoreboards {
        public static final int OBJECTIVE_PACKET_ADD = 0;
        public static final int OBJECTIVE_PACKET_REMOVE = 1;
    }

    public static final class Particles {
        public static final DataQuery PARTICLE_TYPE = DataQuery.of("Type");
        public static final DataQuery PARTICLE_OPTIONS = DataQuery.of("Options");
        public static final DataQuery PARTICLE_OPTION_KEY = DataQuery.of("Option");
        public static final DataQuery PARTICLE_OPTION_VALUE = DataQuery.of("Value");
    }

    public static final class Map {
        public static final String MAP_INFO_DATA_PROVIDER_NAME = "map_info";
        public static final String MAP_INDEX_DATA_NAME = "idcounts";
        public static final String MAP_ID = "map";
        public static final String MAP_UUID_INDEX = "MapUUIDs";
        public static final DataQuery MAP_UNSAFE_ID = DataQuery.of("UnsafeMapId");
        public static final DataQuery MAP_DATA = DataQuery.of("MapData");
        public static final DataQuery SHADE_NUM = DataQuery.of("shade");
        public static final DataQuery COLOR_INDEX = DataQuery.of("colorIndex");
        public static final DataQuery MAP_LOCATION = DataQuery.of("MapLocation");
        public static final DataQuery MAP_WORLD = DataQuery.of("MapWorld");
        public static final DataQuery MAP_TRACKS_PLAYERS = DataQuery.of("TracksPlayers");
        public static final DataQuery MAP_UNLIMITED_TRACKING = DataQuery.of("MapUnlimitedTracking");
        public static final DataQuery MAP_SCALE = DataQuery.of("MapScale");
        public static final DataQuery MAP_CANVAS = DataQuery.of("MapCanvas");
        public static final DataQuery MAP_LOCKED = DataQuery.of("MapLocked");
        public static final DataQuery MAP_DECORATIONS = DataQuery.of("MapDecorations");
        public static final DataQuery DECORATION_TYPE = DataQuery.of("type");
        public static final DataQuery DECORATION_ID = DataQuery.of("id");
        public static final DataQuery DECORATION_X = DataQuery.of("x");
        public static final DataQuery DECORATION_Y = DataQuery.of("z");
        public static final DataQuery DECORATION_ROTATION = DataQuery.of("rot");
        public static final DataQuery NAME = DataQuery.of("Name");
        public static final String DECORATIONS_KEY = "Decorations";
        public static final String ID_COUNTS_KEY = "map";
        public static final String SPONGE_UUID_KEY = "sponge-uuid";
        public static final String DECORATION_KEY_PREFIX = "sponge-";
        public static final int DEFAULT_MAP_SCALE = 0;
        public static final int MIN_MAP_SCALE = 0;
        public static final int MAX_MAP_SCALE = 127;
        public static final boolean DEFAULT_TRACKS_PLAYERS = true;
        public static final boolean DEFAULT_UNLIMITED_TRACKING = false;
        public static final boolean DEFAULT_MAP_LOCKED = false;
        public static final String MAP_PREFIX = "map_";
        public static final int MAP_SIZE = 16384;
        public static final int MAP_MAX_INDEX = 127;
        public static final int MAP_PIXELS = 128;
        public static final int MAP_SHADES = 4;
        public static final int SHADE_DIVIDER = 255;
        public static final BiMap<Direction, Byte> DIRECTION_CONVERSION_MAP = HashBiMap.create((int)16);

        static {
            DIRECTION_CONVERSION_MAP.put((Object)Direction.SOUTH, (Object)0);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.SOUTH_SOUTHWEST, (Object)1);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.SOUTHWEST, (Object)2);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.WEST_SOUTHWEST, (Object)3);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.WEST, (Object)4);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.WEST_NORTHWEST, (Object)5);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.NORTHWEST, (Object)6);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.NORTH_NORTHWEST, (Object)7);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.NORTH, (Object)8);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.NORTH_NORTHEAST, (Object)9);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.NORTHEAST, (Object)10);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.EAST_NORTHEAST, (Object)11);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.EAST, (Object)12);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.EAST_SOUTHEAST, (Object)13);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.SOUTHEAST, (Object)14);
            DIRECTION_CONVERSION_MAP.put((Object)Direction.SOUTH_SOUTHEAST, (Object)15);
        }
    }

    public static final class ItemStack {
        public static final DataQuery COUNT = DataQuery.of("Count");
        public static final DataQuery TYPE = DataQuery.of("ItemType");
        public static final DataQuery DAMAGE_VALUE = DataQuery.of("UnsafeDamage");
        public static final String ATTRIBUTE_MODIFIERS = "AttributeModifiers";
        public static final String ATTRIBUTE_NAME = "AttributeName";
        public static final String ATTRIBUTE_SLOT = "Slot";
    }

    public static final class Fluids {
        public static final DataQuery FLUID_TYPE = DataQuery.of("FluidType");
        public static final DataQuery FLUID_VOLUME = DataQuery.of("FluidVolume");
        public static final DataQuery FLUID_STATE = DataQuery.of("FluidState");
    }

    public static final class DataSerializers {
        public static final DataQuery LOCAL_TIME_HOUR = DataQuery.of("LocalTimeHour");
        public static final DataQuery LOCAL_TIME_MINUTE = DataQuery.of("LocalTimeMinute");
        public static final DataQuery LOCAL_TIME_SECOND = DataQuery.of("LocalTimeSecond");
        public static final DataQuery LOCAL_TIME_NANO = DataQuery.of("LocalTimeNano");
        public static final DataQuery LOCAL_DATE_YEAR = DataQuery.of("LocalDateYear");
        public static final DataQuery LOCAL_DATE_MONTH = DataQuery.of("LocalDateMonth");
        public static final DataQuery LOCAL_DATE_DAY = DataQuery.of("LocalDateDay");
        public static final DataQuery ZONE_TIME_ID = DataQuery.of("ZoneDateTimeId");
        public static final DataQuery X_POS = DataQuery.of("x");
        public static final DataQuery Y_POS = DataQuery.of("y");
        public static final DataQuery Z_POS = DataQuery.of("z");
        public static final DataQuery W_POS = DataQuery.of("w");
        public static final DataQuery DIRECTION = DataQuery.of("Direction");
    }

    public static final class Block {
        public static final DataQuery BLOCK_STATE = DataQuery.of("BlockState");
        public static final DataQuery BLOCK_EXTENDED_STATE = DataQuery.of("BlockExtendedState");
        public static final DataQuery BLOCK_TYPE = DataQuery.of("BlockType");
        public static final DataQuery BLOCK_STATE_UNSAFE_META = DataQuery.of("UnsafeMeta");
        public static final DataQuery BLOCK_STATE_MATCHER = DataQuery.of("BlockStateMatcher");
        public static final int PIXELS_PER_BLOCK = 16;
    }

    public static final class GameProfile {
        public static final DataQuery SKIN_UUID = DataQuery.of("SkinUUID");
        public static final DataQuery GAME_PROFILE_ID = DataQuery.of("Id");
        public static final DataQuery GAME_PROFILE_NAME = DataQuery.of("Name");
        public static final String DUMMY_NAME = "[sponge]";
    }

    public static final class Legacy {
        public static final String LEGACY_DIMENSION_ARRAY = "DimensionArray";

        private Legacy() {
        }

        public static final class World {
            public static final String WORLD_UUID_LEAST_1_8 = "uuid_least";
            public static final String WORLD_UUID_MOST_1_8 = "uuid_most";
            public static final int WORLD_UUID_1_9_VERSION = 0;

            private World() {
            }
        }

        public static final class Entity {
            public static final String UUID_LEAST_1_8 = "uuid_least";
            public static final String UUID_MOST_1_8 = "uuid_most";
            public static final int TRACKER_ID_VERSION = 0;

            private Entity() {
            }
        }
    }

    public static final class Canary {
        public static final String ROOT = "Canary";
        public static final String FIRST_JOINED = "FirstJoin";
        public static final String LAST_JOINED = "LastJoin";
    }

    public static final class Bukkit {
        public static final String BUKKIT = "bukkit";
        public static final String BUKKIT_FIRST_PLAYED = "firstPlayed";
        public static final String BUKKIT_LAST_PLAYED = "lastPlayed";
    }

    public static class Forge {
        public static final String PERSISTED_NBT_TAG = "PlayerPersisted";
        public static final String FORGE_DATA = "ForgeData";
        public static final DataQuery FORGE_DATA_ROOT = DataQuery.of("ForgeData");
        public static final String FORGE_CAPS = "ForgeCaps";
        public static final String USED_DIMENSION_IDS = "UsedIDs";
    }

    public static final class NBT {
        public static final byte TAG_END = 0;
        public static final byte TAG_BYTE = 1;
        public static final byte TAG_SHORT = 2;
        public static final byte TAG_INT = 3;
        public static final byte TAG_LONG = 4;
        public static final byte TAG_FLOAT = 5;
        public static final byte TAG_DOUBLE = 6;
        public static final byte TAG_BYTE_ARRAY = 7;
        public static final byte TAG_STRING = 8;
        public static final byte TAG_LIST = 9;
        public static final byte TAG_COMPOUND = 10;
        public static final byte TAG_INT_ARRAY = 11;
        public static final byte TAG_LONG_ARRAY = 12;
        public static final byte TAG_ANY_NUMERIC = 99;

        public static CompoundTag filterSpongeCustomData(CompoundTag rootCompound) {
            if (rootCompound.contains("ForgeData", 10)) {
                CompoundTag forgeCompound = rootCompound.getCompound("ForgeData");
                if (forgeCompound.contains("SpongeData", 10)) {
                    NBT.cleanseInnerCompound(forgeCompound);
                }
                if (forgeCompound.isEmpty()) {
                    rootCompound.remove("ForgeData");
                }
            } else if (rootCompound.contains("SpongeData", 10)) {
                NBT.cleanseInnerCompound(rootCompound);
            }
            return rootCompound;
        }

        private static void cleanseInnerCompound(CompoundTag compound) {
            CompoundTag inner = compound.getCompound("SpongeData");
            if (inner.isEmpty()) {
                compound.remove("SpongeData");
            }
        }

        public static List<Enchantment> getItemEnchantments(net.minecraft.world.item.ItemStack itemStack) {
            if (!itemStack.isEnchanted()) {
                return Collections.emptyList();
            }
            ArrayList enchantments = Lists.newArrayList();
            ListTag list = itemStack.getEnchantmentTags();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.getCompound(i);
                short enchantmentId = compound.getShort("id");
                short level = compound.getShort("lvl");
                Registry enchantmentRegistry = SpongeCommon.vanillaRegistry(Registries.ENCHANTMENT);
                EnchantmentType enchantmentType = (EnchantmentType)enchantmentRegistry.byId((int)enchantmentId);
                if (enchantmentType == null) continue;
                enchantments.add(new SpongeEnchantment(enchantmentType, level));
            }
            return enchantments;
        }

        public static ListTag newDoubleNBTList(double ... numbers) {
            ListTag nbttaglist = new ListTag();
            for (double d1 : numbers) {
                nbttaglist.add((Object)DoubleTag.valueOf((double)d1));
            }
            return nbttaglist;
        }

        public static ListTag newFloatNBTList(float ... numbers) {
            ListTag nbttaglist = new ListTag();
            for (float f : numbers) {
                nbttaglist.add((Object)FloatTag.valueOf((float)f));
            }
            return nbttaglist;
        }
    }

    public static final class BlockChangeFlags {
        public static final int BLOCK_UPDATED = 1;
        public static final int NOTIFY_CLIENTS = 2;
        public static final int IGNORE_RENDER = 4;
        public static final int FORCE_RE_RENDER = 8;
        public static final int DENY_NEIGHBOR_SHAPE_UPDATE = 16;
        public static final int NEIGHBOR_DROPS = 32;
        public static final int BLOCK_MOVING = 64;
        public static final int LIGHTING_UPDATES = 128;
        public static final int PHYSICS_MASK = 256;
        public static final int PATHFINDING_UPDATES = 512;
        public static final int FORCED_RESTORE = 314;
        public static final int DEFAULT = 3;
        public static final int NONE = 944;
    }

    public static final class Entity {
        public static final String LIGHTNING_EFFECT = "effect";
        public static final int ELYTRA_FLYING_FLAG = 7;
        public static final int MINIMUM_FIRE_TICKS = 1;
        public static final boolean DEFAULT_GLOWING = false;
        public static final BlockPos HANGING_OFFSET_EAST = new BlockPos(1, 1, 0);
        public static final BlockPos HANGING_OFFSET_WEST = new BlockPos(-1, 1, 0);
        public static final BlockPos HANGING_OFFSET_NORTH = new BlockPos(0, 1, -1);
        public static final BlockPos HANGING_OFFSET_SOUTH = new BlockPos(0, 1, 1);
        public static final String ENTITY_TYPE_ID = "id";
        public static final String ENTITY_POSITION = "Pos";
        public static final String ENTITY_DIMENSION = "Dimension";
        public static final String ENTITY_ROTATION = "Rotation";
        public static final String ENTITY_UUID = "UUID";
        public static final DataQuery CLASS = DataQuery.of("EntityClass");
        public static final DataQuery UUID = DataQuery.of("EntityUniqueId");
        public static final DataQuery TYPE = DataQuery.of("EntityType");
        public static final DataQuery ROTATION = DataQuery.of("Rotation");
        public static final DataQuery SCALE = DataQuery.of("Scale");
        public static final DataQuery CUSTOM_NAME = DataQuery.of("CustomName");

        public static final class WitherSkull {
            public static final int DEFAULT_EXPLOSION_RADIUS = 1;
            public static final float DEFAULT_WITHER_CREATED_SKULL_DAMAGE = 8.0f;
            public static final float DEFAULT_NO_SOURCE_SKULL_DAMAGE = 5.0f;
        }

        public static final class Wither {
            public static final int DEFAULT_FUSE_DURATION = 220;
        }

        public static final class Ravager {
            public static final int ROAR_TIME = 10;
        }

        public static final class Rabbit {
            public static final Supplier<RabbitType> DEFAULT_TYPE = RabbitTypes.WHITE;
        }

        public static final class PrimedTNT {
            public static final int DEFAULT_EXPLOSION_RADIUS = 4;
            public static final int DEFAULT_FUSE_DURATION = 80;
        }

        public static final class Player {
            public static final double DEFAULT_FLYING_SPEED = 0.05;
            public static final double DEFAULT_HEALTH_SCALE = 20.0;
            public static final String INVENTORY = "Inventory";
            public static final String INVULNERABLE = "Invulnerable";
            public static final String SELECTED_ITEM_SLOT = "SelectedItemSlot";
            public static final String ENDERCHEST_INVENTORY = "EnderItems";
            public static final DataQuery UUID = DataQuery.of("UUID");
            public static final DataQuery NAME = DataQuery.of("Name");
            public static final DataQuery SPAWNS = DataQuery.of("Spawns");
            public static final float PLAYER_WIDTH = 0.6f;
            public static final float PLAYER_HEIGHT = 1.8f;
            public static final int TRACKING_RANGE = 32;
            public static final double PLAYER_Y_OFFSET = -0.35;

            public static final class Abilities {
                public static final DataQuery IS_FLYING = DataQuery.of("abilities", "flying");
                public static final DataQuery CAN_FLY = DataQuery.of("abilities", "mayfly");
            }
        }

        public static final class Parrot {
            public static final Supplier<ParrotType> DEFAULT_TYPE = ParrotTypes.RED_BLUE;
        }

        public static final class Panda {
            public static final int UNHAPPY_TIME = 32;
        }

        public static final class Cat {
            public static final Supplier<CatType> DEFAULT_TYPE = CatTypes.WHITE;
        }

        public static final class Minecart {
            public static final double DEFAULT_AIRBORNE_MOD = (double)0.95f;
            public static final double DEFAULT_DERAILED_MOD = 0.5;
            public static final String MINECART_TYPE = "Type";
            public static final double DEFAULT_MAX_SPEED = 0.4;
            public static final double DEFAULT_FURNACE_MAX_SPEED = 0.2;
            public static final String MAX_SPEED = "maxSpeed";
            public static final String SLOW_WHEN_EMPTY = "slowWhenEmpty";
            public static final String AIRBORNE_MODIFIER = "airborneModifier";
            public static final String DERAILED_MODIFIER = "derailedModifier";
            public static final int DEFAULT_FUSE_DURATION = 80;
        }

        public static final class Llama {
            public static final Supplier<LlamaType> DEFAULT_TYPE = LlamaTypes.WHITE;
        }

        public static final class Item {
            public static final int MAX_PICKUP_DELAY = Short.MAX_VALUE;
            public static final int DEFAULT_PICKUP_DELAY = 0;
            public static final double DEFAULT_ITEM_MERGE_RADIUS = 0.5;
            public static final int MIN_DESPAWN_DELAY = Short.MIN_VALUE;
            public static final int MAGIC_NO_PICKUP = Short.MAX_VALUE;
            public static final int MAGIC_NO_DESPAWN = Short.MIN_VALUE;
            public static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;

            private Item() {
            }
        }

        public static final class Horse {
            public static final Supplier<HorseStyle> DEFAULT_STYLE = HorseStyles.NONE;
            public static final Supplier<HorseColor> DERAULT_TYPE = HorseColors.WHITE;

            private Horse() {
            }
        }

        public static final class Firework {
            public static final int DEFAULT_EXPLOSION_RADIUS = 0;
            public static final String EXPLOSION = "Explosion";
        }

        public static final class Fireball {
            public static final int DEFAULT_EXPLOSION_RADIUS = 1;
        }

        public static final class FallingBlock {
            public static final double DEFAULT_MAX_FALL_DAMAGE = 40.0;
            public static final int DEFAULT_FALL_TIME = 1;
            public static final boolean DEFAULT_CAN_HURT_ENTITIES = false;
        }

        public static final class EnderCrystal {
            public static final int DEFAULT_EXPLOSION_STRENGTH = 6;
        }

        public static final class Creeper {
            public static final int DEFAULT_EXPLOSION_RADIUS = 3;
            public static final int STATE_IDLE = -1;
            public static final int STATE_PRIMED = 1;
            public static final int FUSE_DURATION = 30;
        }

        public static final class Boat {
            public static final String BOAT_MAX_SPEED = "maxSpeed";
            public static final String BOAT_MOVE_ON_LAND = "moveOnLand";
            public static final String BOAT_OCCUPIED_DECELERATION_SPEED = "occupiedDecelerationSpeed";
            public static final String BOAT_UNOCCUPIED_DECELERATION_SPEED = "unoccupiedDecelerationSpeed";
            public static final float DEFAULT_MAX_SPEED = 0.9f;
            public static final double OCCUPIED_DECELERATION_SPEED = 0.0;
            public static final double UNOCCUPIED_DECELERATION_SPEED = 0.8;
            public static final boolean MOVE_ON_LAND = false;
        }

        public static final class Ageable {
            public static final int ADULT = 6000;
            public static final int CHILD = -24000;
        }
    }

    public static final class Profile {
        public static final DataQuery UUID = DataQuery.of("UUID");
        public static final DataQuery NAME = DataQuery.of("Name");
        public static final DataQuery PROPERTIES = DataQuery.of("Properties");
        public static final DataQuery VALUE = DataQuery.of("Value");
        public static final DataQuery SIGNATURE = DataQuery.of("Signature");
    }

    public static final class Catalog {
        public static final Supplier<DyeColor> DEFAULT_SHULKER_COLOR = DyeColors.PURPLE;
        public static final Supplier<ComparatorMode> DEFAULT_COMPARATOR_MODE = ComparatorModes.COMPARE;
        public static final Supplier<GameMode> DEFAULT_GAMEMODE = GameModes.SURVIVAL;
        public static final Supplier<ArtType> DEFAULT_ART = ArtTypes.KEBAB;
        public static final Supplier<HandPreference> DEFAULT_HAND = HandPreferences.RIGHT;

        private Catalog() {
        }
    }

    public static final class TileEntity {
        public static final String SIGN = "Sign";
        public static final String X_POS = "x";
        public static final String Y_POS = "y";
        public static final String Z_POS = "z";
        public static final DataQuery TILE_TYPE = DataQuery.of("TileType");
        public static final DataQuery LOCK_CODE = DataQuery.of("Lock");
        public static final DataQuery ITEM_CONTENTS = DataQuery.of("Contents");
        public static final DataQuery SLOT = DataQuery.of("SlotId");
        public static final DataQuery SLOT_ITEM = DataQuery.of("Item");
        public static final DataQuery LOCKABLE_CONTAINER_CUSTOM_NAME = DataQuery.of("CustomName");
        public static final DataQuery CUSTOM_NAME = DataQuery.of("CustomName");

        public static final class Sign {
            public static final DataQuery LINES = DataQuery.of("SignLines");
            public static final DataQuery GLOWING_TEXT = DataQuery.of("GlowingText");
        }

        public static final class Anvils {
            public static final DataQuery MATERIALCOST = DataQuery.of("materialcost");
            public static final DataQuery LEVELCOST = DataQuery.of("levelcost");
        }

        public static final class Beacon {
            public static final DataQuery PRIMARY = DataQuery.of("primary");
            public static final DataQuery SECONDARY = DataQuery.of("secondary");
        }

        public static final class Hopper {
            public static final DataQuery TRANSFER_COOLDOWN = DataQuery.of("TransferCooldown");
        }

        public static final class CommandBlock {
            public static final DataQuery SUCCESS_COUNT = DataQuery.of("SuccessCount");
            public static final DataQuery DOES_TRACK_OUTPUT = DataQuery.of("DoesTrackOutput");
            public static final DataQuery STORED_COMMAND = DataQuery.of("StoredCommand");
            public static final DataQuery TRACKED_OUTPUT = DataQuery.of("TrackedOutput");
        }

        public static final class Banner {
            public static final String BANNER_PATTERN_ID = "Pattern";
            public static final String BANNER_PATTERN_COLOR = "Color";
            public static final String BANNER_BASE = "Base";
            public static final String BANNER_PATTERNS = "Patterns";
            public static final DataQuery BASE = DataQuery.of("Base");
            public static final DataQuery SHAPE = DataQuery.of("BannerShapeId");
            public static final DataQuery COLOR = DataQuery.of("DyeColor");
        }

        public static final class Furnace {
            public static final int MAX_BURN_TIME = 1600;
            public static final int DEFAULT_COOK_TIME = 200;
            public static final DataQuery BURN_TIME = DataQuery.of("BurnTime");
            public static final DataQuery BURN_TIME_TOTAL = DataQuery.of("BurnTimeTotal");
            public static final DataQuery COOK_TIME = DataQuery.of("CookTime");
            public static final DataQuery COOK_TIME_TOTAL = DataQuery.of("CookTimeTotal");
        }

        public static final class Spawner {
            public static final short DEFAULT_SPAWN_COUNT = 4;
            public static final short DEFAULT_MAXMIMUM_NEARBY_ENTITIES = 6;
        }

        public static final class Structure {
            public static final String DEFAULT_STRUCTURE_AUTHOR = "";
            public static final boolean DEFAULT_STRUCTURE_IGNORE_ENTITIES = true;
            public static final Supplier<StructureMode> DEFAULT_STRUCTURE_MODE = StructureModes.DATA;
            public static final Vector3i DEFAULT_STRUCTURE_POSITION = Vector3i.ONE;
            public static final boolean DEFAULT_STRUCTURE_POWERED = false;
            public static final boolean DEFAULT_STRUCTURE_SHOW_AIR = false;
            public static final long DEFAULT_STRUCTURE_SEED = 0L;
            public static final Vector3i DEFAULT_STRUCTURE_SIZE = Vector3i.ONE;
        }
    }

    public static final class Recipe {
        public static final String GROUP = "group";
        public static final String RESULT = "result";
        public static final String ITEM = "item";
        public static final String CATEGORY = "category";
        public static final String COUNT = "count";
        public static final String SPONGE_RESULT = "sponge:result";
        public static final String SPONGE_RESULTFUNCTION = "sponge:result_function";
        public static final String SPONGE_REMAINING_ITEMS = "sponge:remaining_items";
        public static final String COOKING_EXP = "experience";
        public static final String COOKING_TIME = "cookingtime";
        public static final String COOKING_INGREDIENT = "ingredient";
        public static final String STONECUTTING_INGREDIENT = "ingredient";
        public static final String SMITHING_BASE_INGREDIENT = "base";
        public static final String SMITHING_ADDITION_INGREDIENT = "addition";
        public static final String SHAPED_PATTERN = "pattern";
        public static final String SHAPED_INGREDIENTS = "key";
        public static final String SHAPELESS_INGREDIENTS = "ingredients";
    }

    public static final class Item {
        public static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
        public static final String BLOCK_ENTITY_ID = "id";
        public static final String ENTITY_TAG = "EntityTag";
        public static final String ITEM_ENCHANTMENT_LIST = "Enchantments";
        public static final String ITEM_STORED_ENCHANTMENTS_LIST = "StoredEnchantments";
        public static final String ITEM_DISPLAY = "display";
        public static final String ITEM_LORE = "Lore";
        public static final String ITEM_NAME = "Name";
        public static final String ITEM_ORIGINAL_LORE = "SpongeOriginalLore";
        public static final String ITEM_ORIGINAL_NAME = "SpongeOriginalName";
        public static final String ITEM_ENCHANTMENT_ID = "id";
        public static final String ITEM_ENCHANTMENT_LEVEL = "lvl";
        public static final String ITEM_BREAKABLE_BLOCKS = "CanDestroy";
        public static final String ITEM_PLACEABLE_BLOCKS = "CanPlaceOn";
        public static final String ITEM_HIDE_FLAGS = "HideFlags";
        public static final String ITEM_UNBREAKABLE = "Unbreakable";
        public static final String CUSTOM_MODEL_DATA = "CustomModelData";
        public static final String CUSTOM_POTION_COLOR = "CustomPotionColor";
        public static final String CUSTOM_POTION_EFFECTS = "CustomPotionEffects";
        public static final String LOCK = "Lock";

        public static final class Fireworks {
            public static final DataQuery FIREWORK_SHAPE = DataQuery.of("Type");
            public static final DataQuery FIREWORK_COLORS = DataQuery.of("Colors");
            public static final DataQuery FIREWORK_FADE_COLORS = DataQuery.of("Fades");
            public static final DataQuery FIREWORK_TRAILS = DataQuery.of("Trails");
            public static final DataQuery FIREWORK_FLICKERS = DataQuery.of("Flickers");
            public static final String FIREWORKS = "Fireworks";
            public static final String EXPLOSIONS = "Explosions";
            public static final String FADE_COLORS = "FadeColors";
            public static final String COLORS = "Colors";
            public static final String FLICKER = "Flicker";
            public static final String TRAIL = "Trail";
            public static final String SHAPE_TYPE = "Type";
            public static final String FLIGHT = "Flight";
        }

        public static final class TradeOffer {
            public static final DataQuery FIRST_QUERY = DataQuery.of("FirstItem");
            public static final DataQuery SECOND_QUERY = DataQuery.of("SecondItem");
            public static final DataQuery BUYING_QUERY = DataQuery.of("BuyingItem");
            public static final DataQuery EXPERIENCE_QUERY = DataQuery.of("GrantsExperience");
            public static final DataQuery MAX_QUERY = DataQuery.of("MaxUses");
            public static final DataQuery USES_QUERY = DataQuery.of("Uses");
            public static final DataQuery EXPERIENCE_GRANTED_TO_MERCHANT_QUERY = DataQuery.of("ExperienceGrantedToMerchant");
            public static final DataQuery PRICE_GROWTH_MULTIPLIER_QUERY = DataQuery.of("PriceGrowthMultiplier");
            public static final DataQuery DEMAND_BONUS_QUERY = DataQuery.of("DemandBonus");
            public static final int DEFAULT_USE_COUNT = 0;
            public static final int DEFAULT_MAX_USES = 7;
        }

        public static final class Potions {
            public static final DataQuery POTION_TYPE = DataQuery.of("PotionType");
            public static final DataQuery POTION_AMPLIFIER = DataQuery.of("Amplifier");
            public static final DataQuery POTION_SHOWS_PARTICLES = DataQuery.of("ShowsParticles");
            public static final DataQuery POTION_SHOWS_ICON = DataQuery.of("ShowsIcon");
            public static final DataQuery POTION_AMBIANCE = DataQuery.of("Ambiance");
            public static final DataQuery POTION_DURATION = DataQuery.of("Duration");
        }

        public static final class Skull {
            public static final String ITEM_SKULL_OWNER = "SkullOwner";
        }

        public static final class Book {
            public static final String ITEM_BOOK_PAGES = "pages";
            public static final String ITEM_BOOK_TITLE = "title";
            public static final String ITEM_BOOK_AUTHOR = "author";
            public static final String ITEM_BOOK_RESOLVED = "resolved";
            public static final String ITEM_BOOK_GENERATION = "generation";
            public static final String INVALID_TITLE = "invalid";
        }
    }

    public static final class Networking {
        public static final int MAX_STRING_LENGTH_BYTES = Short.MAX_VALUE;
        public static final int MAX_STRING_LENGTH = 8191;
        public static final int MAGIC_CLICK_OUTSIDE_SURVIVAL = -999;
        public static final int MAGIC_CLICK_OUTSIDE_CREATIVE = -1;
        public static final int MASK_NONE = 0;
        public static final int MASK_OUTSIDE = 196608;
        public static final int MASK_MODE = 65024;
        public static final int MASK_DRAGDATA = 504;
        public static final int MASK_BUTTON = 7;
        public static final int MASK_ALL = 262143;
        public static final int MASK_NORMAL = 65535;
        public static final int MASK_DRAG = 262143;
        public static final int CLICK_INSIDE_WINDOW = 65536;
        public static final int CLICK_OUTSIDE_WINDOW = 131072;
        public static final int CLICK_ANYWHERE = 196608;
        public static final int MODE_CLICK = 512 << ClickType.PICKUP.ordinal();
        public static final int MODE_SHIFT_CLICK = 512 << ClickType.QUICK_MOVE.ordinal();
        public static final int MODE_HOTBAR = 512 << ClickType.SWAP.ordinal();
        public static final int MODE_PICKBLOCK = 512 << ClickType.CLONE.ordinal();
        public static final int MODE_DROP = 512 << ClickType.THROW.ordinal();
        public static final int MODE_DRAG = 512 << ClickType.QUICK_CRAFT.ordinal();
        public static final int MODE_DOUBLE_CLICK = 512 << ClickType.PICKUP_ALL.ordinal();
        public static final int DRAG_MODE_PRIMARY_BUTTON = 64;
        public static final int DRAG_MODE_SECONDARY_BUTTON = 128;
        public static final int DRAG_MODE_MIDDLE_BUTTON = 256;
        public static final int DRAG_MODE_ANY = 448;
        public static final int DRAG_STATUS_STARTED = 8;
        public static final int DRAG_STATUS_ADD_SLOT = 16;
        public static final int DRAG_STATUS_STOPPED = 32;
        public static final int BUTTON_PRIMARY = 1;
        public static final int BUTTON_SECONDARY = 2;
        public static final int BUTTON_MIDDLE = 4;
        public static final int PACKET_BUTTON_PRIMARY_ID = 0;
        public static final int PACKET_BUTTON_SECONDARY_ID = 0;
        public static final int PACKET_BUTTON_MIDDLE_ID = 0;
        public static final InetSocketAddress LOCALHOST = InetSocketAddress.createUnresolved("127.0.0.1", 0);
    }

    public static final class ChunkTicket {
        public static final int MAX_FULL_CHUNK_TICKET_LEVEL = 33;
        public static final int MAX_FULL_CHUNK_DISTANCE = 34;
    }

    public static final class Chunk {
        public static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        public static final int NUM_XZ_BITS = 4;
        public static final int NUM_SHORT_Y_BITS = 8;
        public static final int NUM_INT_Y_BITS = 24;
        public static final short XZ_MASK = 15;
        public static final short Y_SHORT_MASK = 255;
        public static final int Y_INT_MASK = 0xFFFFFF;
        public static final String CHUNK_DATA_SECTIONS = "Sections";
    }

    public static final class World {
        public static final Vector3i BLOCK_MIN = new Vector3i(-30000000, 0, -30000000);
        public static final Vector3i BLOCK_MAX = new Vector3i(30000000, 256, 30000000).sub(Vector3i.ONE);
        public static final Vector3i BLOCK_SIZE = BLOCK_MAX.sub(BLOCK_MIN).add(Vector3i.ONE);
        public static final EnumSet<net.minecraft.core.Direction> NOTIFY_DIRECTION_SET = EnumSet.of(net.minecraft.core.Direction.WEST, new net.minecraft.core.Direction[]{net.minecraft.core.Direction.EAST, net.minecraft.core.Direction.DOWN, net.minecraft.core.Direction.UP, net.minecraft.core.Direction.NORTH, net.minecraft.core.Direction.SOUTH});
        public static final ResourceKey INVALID_WORLD_KEY = ResourceKey.sponge("invalid_world");
        public static final String LEVEL_DAT_OLD = LevelResource.LEVEL_DATA_FILE.getId() + "_old";
        public static final int DEFAULT_BLOCK_CHANGE_LIMIT = 512;
    }

    public static final class WorldEvents {
        public static final int PLAY_RECORD_EVENT = 1010;
        public static final int PLAY_WITHER_SPAWN_EVENT = 1023;
        public static final int PLAY_ENDERDRAGON_DEATH_EVENT = 1028;
        public static final int PLAY_BLOCK_END_PORTAL_SPAWN_EVENT = 1038;
    }

    public static final class Permissions {
        public static final String SELECTOR_PERMISSION = "minecraft.selector";
        public static final String COMMAND_BLOCK_PERMISSION = "minecraft.commandblock";
        public static final int COMMAND_BLOCK_LEVEL = 2;
        public static final int SELECTOR_LEVEL = 2;
        public static final String SPONGE_HELP_PERMISSION = "sponge.command.help";
        public static final String DEBUG_HOVER_STACKTRACE = "sponge.debug.hover-stacktrace";
        public static final int SPONGE_HELP_LEVEL = 0;
    }

    public static final class Sponge {
        public static final int MAX_DEATH_EVENTS_BEFORE_GIVING_UP = 3;
        public static final String SPONGE_ENTITY_CREATOR = "Creator";
        public static final String SPONGE_ENTITY_NOTIFIER = "Notifier";
        public static final String SPONGE_BLOCK_POS_TABLE = "BlockPosTable";
        @Deprecated
        public static final String LEGACY_SPONGE_PLAYER_UUID_TABLE = "PlayerIdTable";
        public static final String SPONGE_PLAYER_UUID_TABLE = "player-uuid-table";
        public static final DataQuery UNSAFE_NBT = DataQuery.of("UnsafeData");
        public static final DataQuery DATA_MANIPULATORS = DataQuery.of("Data");
        public static final DataQuery SNAPSHOT_WORLD_POSITION = DataQuery.of("Position");

        public static int setNibble(int num, int data, int which, int bitsToReplace) {
            return num & ~(bitsToReplace << which * 4) | data << which * 4;
        }

        public static short blockPosToShort(BlockPos pos) {
            short serialized = (short)Sponge.setNibble(0, pos.getX() & 0xF, 0, 4);
            serialized = (short)Sponge.setNibble(serialized, pos.getY() & 0xFF, 1, 8);
            serialized = (short)Sponge.setNibble(serialized, pos.getZ() & 0xF, 3, 4);
            return serialized;
        }

        public static int blockPosToInt(BlockPos pos) {
            int serialized = Sponge.setNibble(0, pos.getX() & 0xF, 0, 4);
            serialized = Sponge.setNibble(serialized, pos.getY() & 0xFFFFFF, 1, 24);
            serialized = Sponge.setNibble(serialized, pos.getZ() & 0xF, 7, 4);
            return serialized;
        }

        public static final class BlockState {
            public static final int BLOCK_TYPE_WITH_DAMAGE_VALUE = 1;
            public static final int STATE_AS_CATALOG_ID = 2;
        }

        public static final class ItemStackSnapshot {
            public static final int DUPLICATE_MANIPULATOR_DATA_VERSION = 1;
            public static final int REMOVED_DUPLICATE_DATA = 2;
            public static final int CURRENT_VERSION = 2;
        }

        public static final class Potion {
            public static final int POTION_V2 = 2;
            public static final int CURRENT_VERSION = 2;
        }

        public static final class BlockSnapshot {
            public static final String TILE_ENTITY_POSITION_X = "x";
            public static final String TILE_ENTITY_POSITION_Y = "y";
            public static final String TILE_ENTITY_POSITION_Z = "z";
            public static final DataQuery WORLD_UUID = DataQuery.of("WorldUuid");
        }

        public static final class BlockEntityArchetype {
            public static final int BASE_VERSION = 1;
            public static final String TILE_ENTITY_ID = "Id";
            public static final String TILE_ENTITY_POS = "Pos";
            public static final DataQuery BLOCK_ENTITY_TYPE = DataQuery.of("TileEntityType");
            public static final DataQuery BLOCK_STATE = DataQuery.of("BlockState");
            public static final DataQuery BLOCK_ENTITY_DATA = DataQuery.of("TileEntityData");
        }

        public static final class Schematic {
            public static final DataQuery NAME = DataQuery.of("Name");
            public static final int CURRENT_VERSION = 3;
            public static final int MAX_SIZE = 65535;
            public static final DataQuery VERSION = DataQuery.of("Version");
            public static final DataQuery DATA_VERSION = DataQuery.of("DataVersion");
            public static final DataQuery METADATA = DataQuery.of("Metadata");
            public static final DataQuery REQUIRED_MODS = DataQuery.of("RequiredMods");
            public static final DataQuery WIDTH = DataQuery.of("Width");
            public static final DataQuery HEIGHT = DataQuery.of("Height");
            public static final DataQuery LENGTH = DataQuery.of("Length");
            public static final DataQuery OFFSET = DataQuery.of("Offset");
            public static final DataQuery BLOCK_PALETTE = DataQuery.of("Palette");
            public static final DataQuery BLOCK_CONTAINER = DataQuery.of("Blocks");
            public static final DataQuery BIOME_CONTAINER = DataQuery.of("Biomes");
            public static final DataQuery PALETTE = DataQuery.of("Palette");
            public static final DataQuery BLOCK_DATA = DataQuery.of("Data");
            public static final DataQuery BIOME_DATA = DataQuery.of("Data");
            public static final DataQuery BLOCKENTITY_CONTAINER = DataQuery.of("BlockEntities");
            public static final DataQuery BLOCKENTITY_DATA = DataQuery.of("Data");
            public static final DataQuery BLOCKENTITY_ID = DataQuery.of("Id");
            public static final DataQuery BLOCKENTITY_POS = DataQuery.of("Pos");
            public static final DataQuery ENTITIES = DataQuery.of("Entities");
            public static final DataQuery ENTITIES_ID = DataQuery.of("Id");
            public static final DataQuery ENTITIES_POS = DataQuery.of("Pos");
            public static final DataQuery BIOME_PALETTE = DataQuery.of("Palette");
            public static final DataQuery SCHEMATIC = DataQuery.of("Schematic");

            public static final class Legacy {
                public static final DataQuery X_POS = DataQuery.of("x");
                public static final DataQuery Y_POS = DataQuery.of("y");
                public static final DataQuery Z_POS = DataQuery.of("z");
                public static final DataQuery MATERIALS = DataQuery.of("Materials");
                public static final DataQuery WE_OFFSET_X = DataQuery.of("WEOffsetX");
                public static final DataQuery WE_OFFSET_Y = DataQuery.of("WEOffsetY");
                public static final DataQuery WE_OFFSET_Z = DataQuery.of("WEOffsetZ");
                public static final DataQuery BLOCKS = DataQuery.of("Blocks");
                public static final DataQuery BLOCK_DATA = DataQuery.of("Data");
                public static final DataQuery ADD_BLOCKS = DataQuery.of("AddBlocks");
                public static final DataQuery TILE_ENTITIES = DataQuery.of("TileEntities");
                public static final DataQuery ENTITIES = DataQuery.of("Entities");
                public static final DataQuery ENTITY_ID = DataQuery.of("id");
            }

            public static final class Versions {
                public static final DataQuery V1_TILE_ENTITY_DATA = DataQuery.of("TileEntities");
                public static final DataQuery V1_TILE_ENTITY_ID = DataQuery.of("id");
                public static final DataQuery V1_BLOCK_PALETTE = DataQuery.of("Palette");
                public static final DataQuery V1_BLOCK_PALETTE_MAX = DataQuery.of("Palette");
                public static final DataQuery V2_BLOCK_PALETTE = DataQuery.of("Palette");
                public static final DataQuery V2_BIOME_PALETTE = DataQuery.of("BiomePalette");
                public static final DataQuery V2_BLOCK_DATA = DataQuery.of("BlockData");
                public static final DataQuery V2_BIOME_DATA = DataQuery.of("BiomeData");
                public static final DataQuery V2_BLOCK_ENTITIES = DataQuery.of("BlockEntities");
            }
        }

        public static final class World {
            public static final String DIMENSION_TYPE = "dimensionType";
            public static final String HAS_CUSTOM_DIFFICULTY = "HasCustomDifficulty";
            public static final String LEVEL_SPONGE_DAT = "level_sponge.dat";
            public static final String LEVEL_SPONGE_DAT_OLD = "level_sponge.dat_old";
            public static final String LEVEL_SPONGE_DAT_NEW = "level_sponge.dat_new";
            public static final String UNIQUE_ID = "UUID";
            public static final String DIMENSIONS_DIRECTORY = "dimensions";
            public static final String WORLD_KEY = "WorldKey";
        }

        public static final class User {
            public static final String USER_SPAWN_X = "SpawnX";
            public static final String USER_SPAWN_Y = "SpawnY";
            public static final String USER_SPAWN_Z = "SpawnZ";
            public static final String USER_SPAWN_FORCED = "SpawnForced";
            public static final String USER_SPAWN_LIST = "Spawns";
        }

        public static final class Entity {
            public static final String IS_VANISHED = "IsVanished";
            public static final String IS_INVISIBLE = "IsInvisible";
            public static final String VANISH_UNCOLLIDEABLE = "VanishUnCollideable";
            public static final String VANISH_UNTARGETABLE = "VanishUnTargetable";
            public static final String CAN_GRIEF = "CanGrief";

            public static final class DataRegistration {
                public static final String INVENTORY = "inventory";
                public static final String BLOCKENTITY = "blockentity";
                public static final String LOCATION = "location";
                public static final String BLOCKSTATE = "blockstate";
                public static final String ENTITY = "entity";
                public static final String GENERIC = "generic";
                public static final String ITEMSTACK = "itemstack";
                public static final String ITEM = "item";
                public static final String NBT = "nbt";
            }

            public static final class Human {
                public static final byte PLAYER_MODEL_FLAG_ALL = 127;
            }

            public static final class Player {
                public static final String HEALTH_SCALE = "HealthScale";
            }

            public static final class EyeOfEnder {
                public static final int DESPAWN_TIMER_MAX = 80;
            }

            public static final class Projectile {
                public static final String PROJECTILE_DAMAGE_AMOUNT = "damageAmount";
            }

            public static final class Item {
                public static final String INFINITE_PICKUP_DELAY = "InfinitePickupDelay";
                public static final String INFINITE_DESPAWN_DELAY = "InfiniteDespawnDelay";
                public static final String PREVIOUS_PICKUP_DELAY = "PreviousPickupDelay";
                public static final String PREVIOUS_DESPAWN_DELAY = "PreviousDespawnDelay";
            }
        }

        public static final class EntityArchetype {
            public static final int BASE_VERSION = 1;
            public static final String REQUIRES_EXTRA_INITIAL_SPAWN = "RequireInitialSpawn";
            public static final String ENTITY_ID = "Id";
            public static final DataQuery ENTITY_TYPE = DataQuery.of("EntityType");
            public static final DataQuery ENTITY_DATA = DataQuery.of("EntityData");
        }

        public static final class PlayerData {
            public static final DataQuery PLAYER_DATA_JOIN = DataQuery.of("FirstJoin");
            public static final DataQuery PLAYER_DATA_LAST = DataQuery.of("LastPlayed");
        }

        public static final class Data {

            public static final class V3 {
                public static final DataQuery SPONGE_DATA_ROOT = DataQuery.of("sponge-data");
                public static final DataQuery CONTENT_VERSION = DataQuery.of("version");
                public static final DataQuery CONTENT = DataQuery.of("content");
            }

            @Deprecated
            public static final class V2 {
                public static final DataQuery MANIPULATOR_DATA = DataQuery.of("ManipulatorData");
                public static final DataQuery MANIPULATOR_ID = DataQuery.of("ManipulatorId");
                public static final String FAILED_CUSTOM_DATA = "FailedData";
                public static final String CUSTOM_MANIPULATOR_TAG_LIST = "CustomManipulators";
                public static final DataQuery CUSTOM_MANIPULATOR_LIST = DataQuery.of("CustomManipulators");
                public static final String SPONGE_DATA = "SpongeData";
                public static final DataQuery SPONGE_DATA_ROOT = DataQuery.of("SpongeData");
            }

            @Deprecated
            public static final class V1 {
                public static final String CUSTOM_DATA_CLASS = "DataClass";
                public static final DataQuery DATA_CLASS = DataQuery.of("DataClass");
                public static final String DATA_VERSION = "DataVersion";
            }
        }
    }
}

