/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.ContextValue;
import org.spongepowered.api.event.filter.data.GetValue;
import org.spongepowered.api.event.filter.data.Has;
import org.spongepowered.api.event.filter.data.Supports;
import org.spongepowered.plugin.processor.ParameterContext;
import org.spongepowered.plugin.processor.ProcessorUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ListenerParameterAnnotation {
    CONTEXT_VALUE(ContextValue.class){

        @Override
        void validate(ParameterContext ctx) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ctx.anno().getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                TypeElement key = ctx.elements().getTypeElement("org.spongepowered.api.event.EventContextKey");
                TypeElement keys = ctx.elements().getTypeElement("org.spongepowered.api.event.EventContextKeys");
                Element contained = ProcessorUtils.containingWithNameAndType(keys.getEnclosedElements(), entry.getValue().getValue().toString(), ElementKind.FIELD);
                if (contained == null) {
                    ctx.logError("Could not find a context key matching the provided name", entry.getValue());
                    return;
                }
                if (!contained.getModifiers().contains((Object)Modifier.STATIC)) {
                    ctx.logError("The @ContextValue annotation must refer to a static field", entry.getValue());
                }
                if (ctx.types().isSubtype(contained.asType(), ctx.types().erasure(key.asType()))) break;
                ctx.logError("The @ContextValue annotation must refer to a field with type EventContextKey, but got '" + contained.asType() + "' instead", entry.getValue());
                break;
            }
        }
    }
    ,
    HAS(Has.class){

        @Override
        void validate(ParameterContext ctx) {
            ListenerParameterAnnotation.validateValueContainerChild("@Has", ctx);
            ListenerParameterAnnotation.validateKeyReference("@Has", ctx);
        }
    }
    ,
    SUPPORTS(Supports.class){

        @Override
        void validate(ParameterContext ctx) {
            ListenerParameterAnnotation.validateValueContainerChild("@Supports", ctx);
            ListenerParameterAnnotation.validateKeyReference("@Supports", ctx);
        }
    }
    ,
    GET_VALUE(GetValue.class){

        @Override
        void validate(ParameterContext ctx) {
            ListenerParameterAnnotation.validateKeyReference("@GetValue", ctx);
        }
    }
    ,
    GETTER(Getter.class){

        private boolean isOptional(TypeMirror mirror) {
            return mirror.getKind() == TypeKind.DECLARED && ((DeclaredType)mirror).asElement().getSimpleName().contentEquals("Optional");
        }

        @Override
        void validate(ParameterContext ctx) {
            if (!ctx.event().isPresent()) {
                return;
            }
            TypeElement event = ctx.event().get();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ctx.anno().getElementValues().entrySet()) {
                DeclaredType declared;
                if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                CharSequence getterName = (CharSequence)entry.getValue().getValue();
                Element possible = ctx.elements().getAllMembers(event).stream().filter(el -> el.getKind() == ElementKind.METHOD && el.getSimpleName().contentEquals(getterName)).filter(el -> ((ExecutableElement)el).getParameters().isEmpty()).findFirst().orElse(null);
                if (possible == null) {
                    ctx.logError("No zero-argument method with this name found in event type '" + event.getSimpleName() + "'", entry.getValue());
                    break;
                }
                TypeMirror expectedType = ((ExecutableType)ctx.types().asMemberOf(ctx.eventType().get(), possible)).getReturnType();
                if (expectedType.getKind() == TypeKind.DECLARED && this.isOptional(declared = (DeclaredType)expectedType) && declared.getTypeArguments().size() == 1 && !this.isOptional(ctx.param().asType())) {
                    expectedType = declared.getTypeArguments().get(0);
                }
                if (ctx.types().isAssignable(ctx.param().asType(), expectedType)) break;
                ctx.logParamError("Annotated parameter was of incorrect type for the method referenced in @Getter. The parameter type should be '" + expectedType + "'!");
                break;
            }
        }
    };

    private static final Map<String, ListenerParameterAnnotation> BY_CLAZZ;
    private final String className;

    private ListenerParameterAnnotation(Class<? extends Annotation> anno) {
        this.className = anno.getName();
    }

    String className() {
        return this.className;
    }

    abstract void validate(ParameterContext var1);

    static @Nullable ListenerParameterAnnotation byClassName(String annotation) {
        return BY_CLAZZ.get(annotation);
    }

    static void validateValueContainerChild(String annotation, ParameterContext ctx) {
        TypeElement valueContainer = ctx.elements().getTypeElement("org.spongepowered.api.data.value.ValueContainer");
        if (valueContainer == null) {
            return;
        }
        if (!ctx.types().isAssignable(ctx.param().asType(), valueContainer.asType())) {
            ctx.logError(annotation + " is only applicable to parameters whose type is a subtype of ValueContainer");
        }
    }

    static void validateKeyReference(String annotation, ParameterContext ctx) {
        TypeMirror container = null;
        String value = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ctx.anno().getElementValues().entrySet()) {
            Name name = entry.getKey().getSimpleName();
            if (name.contentEquals("container")) {
                container = (TypeMirror)entry.getValue().getValue();
            } else if (name.contentEquals("value")) {
                value = (String)entry.getValue().getValue();
            }
            if (container == null || value == null) continue;
            break;
        }
        if (container == null) {
            container = ctx.elements().getTypeElement("org.spongepowered.api.data.Keys").asType();
        }
        if (container.getKind() != TypeKind.DECLARED) {
            return;
        }
        TypeElement key = ctx.elements().getTypeElement("org.spongepowered.api.data.Key");
        TypeElement element = (TypeElement)((DeclaredType)container).asElement();
        Element contained = ProcessorUtils.containingWithNameAndType(element.getEnclosedElements(), value, ElementKind.FIELD);
        if (contained == null) {
            ctx.logError("Could not find a matching Key in the specified container class");
            return;
        }
        Set<Modifier> modifiers = contained.getModifiers();
        if (!modifiers.contains((Object)Modifier.STATIC) || !modifiers.contains((Object)Modifier.PUBLIC)) {
            ctx.logError("The " + annotation + " annotation must refer to a public static field");
        }
        if (!ctx.types().isAssignable(contained.asType(), ctx.types().erasure(key.asType()))) {
            ctx.logError("The " + annotation + " annotation must refer to a field with type Key, but got '" + contained.asType() + "' instead");
        }
    }

    static {
        BY_CLAZZ = new HashMap<String, ListenerParameterAnnotation>();
        for (ListenerParameterAnnotation element : ListenerParameterAnnotation.values()) {
            BY_CLAZZ.put(element.className, element);
        }
    }
}

