/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import org.spongepowered.common.inject.SpongeCommonModule;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.mapping.SpongeMappingManager;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.MetadataParser;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;
import org.spongepowered.vanilla.launch.inject.SpongeVanillaModule;
import org.spongepowered.vanilla.launch.mapping.VanillaMappingManager;
import org.spongepowered.vanilla.launch.plugin.VanillaDummyPluginContainer;
import org.spongepowered.vanilla.launch.plugin.VanillaPluginManager;

public abstract class VanillaLaunch
extends Launch {
    private final Stage injectionStage;
    private final VanillaPluginManager pluginManager;
    private final VanillaMappingManager mappingManager;
    private PluginContainer vanillaPlugin;

    protected VanillaLaunch(VanillaPluginPlatform pluginPlatform, Stage injectionStage) {
        super(pluginPlatform);
        this.injectionStage = injectionStage;
        this.pluginManager = new VanillaPluginManager();
        this.mappingManager = new VanillaMappingManager();
    }

    @Override
    public final Stage injectionStage() {
        return this.injectionStage;
    }

    @Override
    public final PluginContainer platformPlugin() {
        if (this.vanillaPlugin == null) {
            this.vanillaPlugin = this.pluginManager().plugin("spongevanilla").orElse(null);
            if (this.vanillaPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing SpongeVanilla, this is a serious issue!");
            }
        }
        return this.vanillaPlugin;
    }

    @Override
    public final VanillaPluginPlatform pluginPlatform() {
        return (VanillaPluginPlatform)this.pluginPlatform;
    }

    @Override
    public final VanillaPluginManager pluginManager() {
        return this.pluginManager;
    }

    @Override
    public SpongeMappingManager mappingManager() {
        return this.mappingManager;
    }

    @Override
    public Injector createInjector() {
        ArrayList modules = Lists.newArrayList((Object[])new Module[]{new SpongeModule(), new SpongeCommonModule(), new SpongeVanillaModule()});
        return Guice.createInjector((Stage)this.injectionStage(), (Iterable)modules);
    }

    protected final void launchPlatform(String[] args) {
        this.createPlatformPlugins();
        this.logger().info("Loading Sponge, please wait...");
        this.performBootstrap(args);
    }

    protected abstract void performBootstrap(String[] var1);

    protected final void createPlatformPlugins() {
        String metadataFileLocation = this.pluginPlatform.metadataFilePath();
        try {
            URL classUrl = VanillaLaunch.class.getResource("/" + VanillaLaunch.class.getName().replace('.', '/') + ".class");
            MetadataContainer read = null;
            if (classUrl.getProtocol().equals("jar")) {
                String[] classUrlSplit = classUrl.getPath().split("!");
                Path expectedFile = Paths.get(new URL(classUrlSplit[0]).toURI());
                Enumeration<URL> manifests = VanillaLaunch.class.getClassLoader().getResources("/" + metadataFileLocation);
                while (manifests.hasMoreElements()) {
                    Path vanillaPath;
                    String[] pathSplit;
                    URL next = manifests.nextElement();
                    if (!next.getProtocol().equals("jar") || (pathSplit = next.getPath().split("!")).length != 2 || !(vanillaPath = Paths.get(new URL(pathSplit[0]).toURI())).equals(expectedFile)) continue;
                    try (InputStreamReader reader = new InputStreamReader(next.openStream(), StandardCharsets.UTF_8);){
                        read = MetadataParser.read((Reader)reader);
                        break;
                    }
                }
            }
            if (read == null) {
                Path vanillaPath = Paths.get(VanillaLaunch.class.getResource("/" + metadataFileLocation).toURI());
                try (BufferedReader reader = Files.newBufferedReader(vanillaPath, StandardCharsets.UTF_8);){
                    read = MetadataParser.read((Reader)reader);
                }
            }
            if (read == null) {
                throw new RuntimeException("Could not determine location for implementation metadata!");
            }
            for (PluginMetadata metadata : read.metadata()) {
                this.pluginManager().addPlugin(new VanillaDummyPluginContainer(metadata, this.logger(), this));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Could not load metadata information for the implementation! This should be impossible!");
        }
    }
}

