/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.transaction;

import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;

public class SlotTransaction
extends Transaction<ItemStackSnapshot> {
    private final Slot slot;

    public SlotTransaction(Slot slot, ItemStackSnapshot original, ItemStackSnapshot defaultReplacement) {
        super(original, defaultReplacement);
        this.slot = Objects.requireNonNull(slot, "Slot cannot be null!");
    }

    @Override
    public void setCustom(ItemStack stack) {
        this.setCustom(Objects.requireNonNull(stack, "ItemStack was null").createSnapshot());
    }

    public Slot slot() {
        return this.slot;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SlotTransaction.class.getSimpleName() + "[", "]").add("slot=" + this.slot).add("original=" + this.original()).add("default=" + this.defaultReplacement()).add("custom=" + this.custom()).add("valid=" + this.isValid()).toString();
    }
}

