/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.border;

import java.time.Duration;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.math.vector.Vector2d;

public interface WorldBorder {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static WorldBorder defaultBorder() {
        return WorldBorder.builder().overworldDefaults().build();
    }

    default public Builder toBuilder() {
        return WorldBorder.builder().from(this);
    }

    public Vector2d center();

    public double diameter();

    public double targetDiameter();

    public Duration timeUntilTargetDiameter();

    public double safeZone();

    public double damagePerBlock();

    public Duration warningTime();

    public int warningDistance();

    public static interface Builder
    extends CopyableBuilder<WorldBorder, Builder>,
    org.spongepowered.api.util.Builder<WorldBorder, Builder> {
        @Override
        public Builder from(WorldBorder var1);

        public Builder overworldDefaults();

        public Builder center(double var1, double var3);

        public Builder initialDiameter(double var1);

        public Builder targetDiameter(double var1);

        public Builder timeToTargetDiameter(Duration var1);

        public Builder safeZone(double var1);

        public Builder damagePerBlock(double var1);

        public Builder warningTime(Duration var1);

        public Builder warningDistance(double var1);

        public WorldBorder build();
    }
}

