/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.FrameType;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.SpongeAdvancementTemplate;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.SpongeCriterionUtil;

public final class SpongeAdvancementBuilder
extends AbstractResourceKeyedBuilder<AdvancementTemplate, AdvancementTemplate.Builder>
implements AdvancementTemplate.Builder.RootStep {
    private @Nullable Advancement parent;
    private AdvancementCriterion criterion;
    private @Nullable DisplayInfo displayInfo;
    private @Nullable ResourceLocation backgroundPath;
    private DataPack<AdvancementTemplate> pack = DataPacks.ADVANCEMENT;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    @Override
    public AdvancementTemplate.Builder parent(@Nullable Advancement parent) {
        this.parent = parent;
        this.backgroundPath = null;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder.RootStep root() {
        this.parent = null;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder background(ResourceKey backgroundPath) {
        this.backgroundPath = (ResourceLocation)backgroundPath;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder criterion(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        this.criterion = criterion;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder reset() {
        this.criterion = AdvancementCriterion.empty();
        this.displayInfo = null;
        this.parent = null;
        this.backgroundPath = null;
        this.pack = DataPacks.ADVANCEMENT;
        return this;
    }

    @Override
    public AdvancementTemplate build0() {
        Tuple<Map<String, Criterion>, String[][]> result = SpongeCriterionUtil.toVanillaCriteriaData(this.criterion);
        AdvancementRewards rewards = AdvancementRewards.EMPTY;
        ResourceLocation resourceLocation = (ResourceLocation)this.key;
        net.minecraft.advancements.DisplayInfo displayInfo = this.displayInfo == null ? null : new net.minecraft.advancements.DisplayInfo(ItemStackUtil.fromSnapshotToNative(this.displayInfo.icon()), SpongeAdventure.asVanilla(this.displayInfo.title()), SpongeAdventure.asVanilla(this.displayInfo.description()), this.backgroundPath, (FrameType)this.displayInfo.type(), this.displayInfo.doesShowToast(), this.displayInfo.doesAnnounceToChat(), this.displayInfo.isHidden());
        net.minecraft.advancements.Advancement parent = (net.minecraft.advancements.Advancement)this.parent;
        net.minecraft.advancements.Advancement advancement = new net.minecraft.advancements.Advancement(resourceLocation, parent, displayInfo, rewards, result.first(), result.second(), false);
        ((AdvancementBridge)advancement).bridge$setCriterion(this.criterion);
        return new SpongeAdvancementTemplate(this.key, advancement, this.pack);
    }
}

