/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.common;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.spongepowered.common.applaunch.config.common.CommandsCategory;
import org.spongepowered.common.applaunch.config.common.DebugCategory;
import org.spongepowered.common.applaunch.config.common.ExploitCategory;
import org.spongepowered.common.applaunch.config.common.GeneralCategory;
import org.spongepowered.common.applaunch.config.common.IpForwardingCategory;
import org.spongepowered.common.applaunch.config.common.ModuleCategory;
import org.spongepowered.common.applaunch.config.common.OptimizationCategory;
import org.spongepowered.common.applaunch.config.common.PhaseTrackerCategory;
import org.spongepowered.common.applaunch.config.common.ServicesCategory;
import org.spongepowered.common.applaunch.config.common.SqlCategory;
import org.spongepowered.common.applaunch.config.common.TeleportHelperCategory;
import org.spongepowered.common.applaunch.config.common.WorldCategory;
import org.spongepowered.common.applaunch.config.core.Config;
import org.spongepowered.common.applaunch.config.core.IpSet;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class CommonConfig
implements Config {
    public static final String FILE_NAME = "sponge.conf";
    @Setting
    public final GeneralCategory general = new GeneralCategory();
    @Setting
    @Comment(value="Configuration options related to the SQL manager, including connection aliases etc")
    public final SqlCategory sql = new SqlCategory();
    @Setting
    public final CommandsCategory commands = new CommandsCategory();
    @Setting
    public final ModuleCategory modules = new ModuleCategory();
    @Setting(value="ip-sets")
    private final Map<String, List<IpSet>> ipSets = new HashMap<String, List<IpSet>>();
    @Setting
    public final IpForwardingCategory ipForwarding = new IpForwardingCategory();
    @Setting
    public final ExploitCategory exploits = new ExploitCategory();
    @Setting
    public final OptimizationCategory optimizations = new OptimizationCategory();
    @Setting(value="phase-tracker")
    public final PhaseTrackerCategory phaseTracker = new PhaseTrackerCategory();
    @Setting(value="teleport-helper")
    @Comment(value="Blocks to blacklist for safe teleportation.")
    public final TeleportHelperCategory teleportHelper = new TeleportHelperCategory();
    @Setting
    @Comment(value="Enables server owners to require specific plugins to provide Sponge services")
    public final ServicesCategory services = new ServicesCategory();
    @Setting
    public final DebugCategory debug = new DebugCategory();
    @Setting
    public final WorldCategory world = new WorldCategory();

    public static ConfigurationTransformation transformation() {
        return ConfigurationTransformation.versionedBuilder().addVersion(2, CommonConfig.buildOneToTwo()).makeVersion(1, builder -> builder.addAction(NodePath.path("modules", "bungeecord"), TransformAction.rename("ip-forwarding")).addAction(NodePath.path("bungeecord"), TransformAction.rename("ip-forwarding")).addAction(NodePath.path("bungeecord", "ip-forwarding"), (path, value) -> {
            if (value.getBoolean()) {
                value.parent().node("mode").set((Object)IpForwardingCategory.Mode.LEGACY);
            }
            value.set(null);
            return null;
        })).build();
    }

    static ConfigurationTransformation buildOneToTwo() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("commands", "enforce-permission-checks-on-non-sponge-commands"), TransformAction.remove()).addAction(NodePath.path("commands", "commands-hidden"), TransformAction.remove()).addAction(NodePath.path("debug", "thread-contention-monitoring"), TransformAction.remove()).addAction(NodePath.path("exploits", "filter-invalid-entities-on-chunk-save"), TransformAction.remove()).addAction(NodePath.path("exploits", "limit-book-size"), TransformAction.remove()).addAction(NodePath.path("exploits", "book-size-total-multiplier"), TransformAction.remove()).addAction(NodePath.path("exploits", "mark-chunks-as-dirty-on-entity-list-modification"), TransformAction.remove()).addAction(NodePath.path("exploits", "update-tracked-chunk-on-entity-move"), TransformAction.remove()).addAction(NodePath.path("exploits", "load-chunk-on-entity-position-set"), TransformAction.remove()).addAction(NodePath.path("exploits", "sync-player-positions-for-vehicle-movement"), TransformAction.remove()).addAction(NodePath.path("general", "file-io-thread-sleep"), TransformAction.remove()).addAction(NodePath.path("permissions"), TransformAction.remove()).addAction(NodePath.path("modules", "block-entity-activation"), TransformAction.remove()).addAction(NodePath.path("modules", "entity-collision"), TransformAction.remove()).addAction(NodePath.path("modules", "tracking"), TransformAction.remove()).addAction(NodePath.path("modules", "real-time"), TransformAction.remove()).addAction(NodePath.path("modules", "timings"), TransformAction.remove()).addAction(NodePath.path("optimizations", "eigen-redstone"), TransformAction.remove()).addAction(NodePath.path("optimizations", "faster-thread-checks"), TransformAction.remove()).addAction(NodePath.path("optimizations", "optimize-maps"), TransformAction.remove()).addAction(NodePath.path("optimizations", "optimize-hoppers"), TransformAction.remove()).addAction(NodePath.path("optimizations", "optimize-block-entity-ticking"), TransformAction.remove()).addAction(NodePath.path("optimizations", "use-active-chunks-for-collisions"), TransformAction.remove()).addAction(NodePath.path("optimizations", "disable-failing-deserialization-log-spam"), TransformAction.remove()).addAction(NodePath.path("optimizations", "disable-scheduled-updates-for-persistent-leaf-blocks"), TransformAction.remove()).addAction(NodePath.path("phase-tracker", "capture-async-commands"), TransformAction.remove()).build();
    }

    public Map<String, Predicate<InetAddress>> getIpSets() {
        HashMap result = new HashMap(this.ipSets.size());
        for (Map.Entry<String, List<IpSet>> entry : this.ipSets.entrySet()) {
            result.put(entry.getKey(), CommonConfig.allOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public Predicate<InetAddress> getIpSet(String name) {
        return this.ipSets.containsKey(name) ? CommonConfig.allOf(this.ipSets.get(name)) : null;
    }

    private static <T> Predicate<T> allOf(List<? extends Predicate<T>> elements) {
        Predicate[] sets = elements.toArray(new Predicate[0]);
        return addr -> {
            for (Predicate set : sets) {
                if (set.test(addr)) continue;
                return false;
            }
            return true;
        };
    }
}

