/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class EntityCustomNameConverter
extends DataParameterConverter<Optional<Component>> {
    public EntityCustomNameConverter() {
        super(EntityAccessor.accessor$DATA_CUSTOM_NAME());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Optional<Component> oldValue, Optional<Component> newValue) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        oldValue.ifPresent(v -> builder.replace(Value.immutableOf(Keys.CUSTOM_NAME, SpongeAdventure.asAdventure(v))));
        newValue.ifPresent(v -> builder.success(Value.immutableOf(Keys.CUSTOM_NAME, SpongeAdventure.asAdventure(v))));
        return Optional.of(builder.result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Optional<Component> getValueFromEvent(Optional<Component> oldValue, DataTransactionResult result) {
        Optional<net.kyori.adventure.text.Component> component = result.successfulValue(Keys.CUSTOM_NAME).map(Value::get);
        if (component.isPresent()) {
            try {
                return Optional.of(SpongeAdventure.asVanilla(component.get()));
            }
            catch (Exception e) {
                return oldValue;
            }
        }
        return Optional.empty();
    }
}

