/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.lifecycle;

import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.lifecycle.RegisterRegistryValueEvent;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.event.lifecycle.AbstractLifecycleEvent;

public abstract class AbstractRegisterRegistryValueEvent
extends AbstractLifecycleEvent
implements RegisterRegistryValueEvent {
    public AbstractRegisterRegistryValueEvent(Cause cause, Game game) {
        super(cause, game);
    }

    @Override
    public <T> RegisterRegistryValueEvent.RegistryStep<T> registry(RegistryType<T> registryType) {
        Optional<Registry<T>> optRegistry = this.getHolder().findRegistry(Objects.requireNonNull(registryType, "registryType"));
        if (!optRegistry.isPresent()) {
            throw new IllegalArgumentException(String.format("RegistryType '%s' has no registered registry!", registryType));
        }
        Registry<T> registry = optRegistry.get();
        if (!registry.isDynamic()) {
            throw new IllegalStateException(String.format("RegistryType '%s' is read only and cannot accept new registry values!", registryType));
        }
        return new RegistryStepImpl<T>(registry);
    }

    protected abstract RegistryHolder getHolder();

    public static final class RegistryStepImpl<T>
    implements RegisterRegistryValueEvent.RegistryStep<T> {
        private final Registry<T> registry;

        public RegistryStepImpl(Registry<T> registry) {
            this.registry = registry;
        }

        @Override
        public RegisterRegistryValueEvent.RegistryStep<T> register(ResourceKey key, T value) {
            this.registry.register(key, value);
            return this;
        }
    }

    public static final class WorldScopedImpl
    extends AbstractRegisterRegistryValueEvent
    implements RegisterRegistryValueEvent.WorldScoped {
        private final ResourceKey worldKey;

        public WorldScopedImpl(Cause cause, Game game, ResourceKey worldKey) {
            super(cause, game);
            this.worldKey = worldKey;
        }

        @Override
        public ResourceKey worldKey() {
            return this.worldKey;
        }

        @Override
        protected RegistryHolder getHolder() {
            return Sponge.server().worldManager().world(this.worldKey).orElse(null);
        }
    }

    public static final class EngineScopedImpl<E extends Engine>
    extends AbstractRegisterRegistryValueEvent
    implements RegisterRegistryValueEvent.EngineScoped<E> {
        private final TypeToken<E> token;
        private final E engine;

        public EngineScopedImpl(Cause cause, Game game, E engine) {
            super(cause, game);
            this.token = TypeToken.get(engine.getClass());
            this.engine = engine;
        }

        @Override
        public TypeToken<E> paramType() {
            return this.token;
        }

        @Override
        protected RegistryHolder getHolder() {
            return this.engine;
        }
    }

    public static final class GameScopedImpl
    extends AbstractRegisterRegistryValueEvent
    implements RegisterRegistryValueEvent.GameScoped {
        public GameScopedImpl(Cause cause, Game game) {
            super(cause, game);
        }

        @Override
        protected RegistryHolder getHolder() {
            return this.game;
        }
    }
}

