/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.MultiInventoryAdapter;
import org.spongepowered.common.inventory.query.SpongeQuery;

public class AppendQuery
extends SpongeQuery {
    private final List<Query> queryList;

    public AppendQuery(List<Query> queryList) {
        this.queryList = Collections.unmodifiableList(queryList);
    }

    public static Query of(Query query, Query[] queries) {
        ArrayList<Query> newQueries = new ArrayList<Query>();
        if (query instanceof AppendQuery) {
            newQueries.addAll(((AppendQuery)query).queryList);
        } else {
            newQueries.add(query);
        }
        newQueries.addAll(Arrays.asList(queries));
        return new AppendQuery(newQueries);
    }

    @Override
    public Inventory execute(Inventory inventory, InventoryAdapter adapter) {
        EmptyInventoryImpl result = new EmptyInventoryImpl(inventory);
        if (this.queryList.isEmpty()) {
            return result;
        }
        List<Inventory> results = this.queryList.stream().map(q -> q.execute(inventory)).collect(Collectors.toList());
        return new MultiInventoryAdapter(results);
    }
}

