/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.recipe.ingredient.SpongeItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeIngredient
extends Ingredient {
    private static final Map<String, Predicate<net.minecraft.world.item.ItemStack>> cachedPredicates = new HashMap<String, Predicate<net.minecraft.world.item.ItemStack>>();

    public SpongeIngredient(Stream<? extends Ingredient.Value> values) {
        super(values);
    }

    public SpongeIngredient(Ingredient.Value value) {
        this(Stream.of(value));
    }

    public static void clearCache() {
        cachedPredicates.clear();
    }

    public boolean test(net.minecraft.world.item.ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        for (Ingredient.Value acceptedItem : this.values) {
            if (acceptedItem instanceof SpongeItemList) {
                if (!((SpongeItemList)acceptedItem).test(testStack)) continue;
                return true;
            }
            for (net.minecraft.world.item.ItemStack stack : acceptedItem.getItems()) {
                if (stack.getItem() != testStack.getItem()) continue;
                return true;
            }
        }
        return false;
    }

    public static SpongeIngredient spongeFromStacks(net.minecraft.world.item.ItemStack ... stacks) {
        SpongeStackItemList itemList = new SpongeStackItemList(stacks);
        return new SpongeIngredient(itemList);
    }

    public static SpongeIngredient spongeFromPredicate(ResourceKey key, Predicate<ItemStack> predicate, net.minecraft.world.item.ItemStack ... exemplaryIngredients) {
        Predicate<net.minecraft.world.item.ItemStack> mcPredicate = stack -> predicate.test(ItemStackUtil.fromNative(stack));
        Predicate<net.minecraft.world.item.ItemStack> registeredPredicate = cachedPredicates.get(key.toString());
        if (registeredPredicate instanceof WrappedPredicate) {
            WrappedPredicate wrapped = (WrappedPredicate)registeredPredicate;
            wrapped.setPredicate(mcPredicate);
        } else if (registeredPredicate != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Predicate ingredient registered twice! {} was replaced.", key.toString()));
        } else {
            cachedPredicates.put(key.toString(), mcPredicate);
        }
        SpongePredicateItemList itemList = new SpongePredicateItemList(key.toString(), mcPredicate, exemplaryIngredients);
        return new SpongeIngredient(itemList);
    }

    public static Predicate<net.minecraft.world.item.ItemStack> getCachedPredicate(String id) {
        return cachedPredicates.computeIfAbsent(id, k -> new WrappedPredicate(id));
    }

    public static class WrappedPredicate
    implements Predicate<net.minecraft.world.item.ItemStack> {
        private final String key;
        private Predicate<net.minecraft.world.item.ItemStack> predicate;

        public WrappedPredicate(String key) {
            this.key = key;
        }

        public void setPredicate(Predicate<net.minecraft.world.item.ItemStack> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(net.minecraft.world.item.ItemStack itemStack) {
            if (this.predicate == null) {
                throw new IllegalStateException(this.key + " predicate was not registered. Is the plugin loaded?");
            }
            return this.predicate.test(itemStack);
        }
    }
}

