/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipe;

public class SpongeSmithingRecipeSerializer<R extends SmithingTransformRecipe>
implements RecipeSerializer<R> {
    public R fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient template = IngredientUtil.spongeDeserialize(json.get("template"));
        Ingredient base = IngredientUtil.spongeDeserialize(json.get("base"));
        Ingredient addition = IngredientUtil.spongeDeserialize(json.get("addition"));
        Function<Container, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        ItemStack itemstack = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        return (R)((Object)new SpongeSmithingRecipe(recipeId, template, base, addition, spongeStack == null ? itemstack : spongeStack, resultFunction));
    }

    public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(FriendlyByteBuf buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

