/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;

@Mixin(value={ResultSlot.class})
public abstract class ResultSlotMixin_Inventory
extends Slot {
    @Shadow
    @Final
    private Player player;
    @Shadow
    private int removeCount;
    @Shadow
    @Final
    private CraftingContainer craftSlots;
    @Nullable
    private CraftingRecipe impl$onTakeRecipe;
    @Nullable
    private ItemStack impl$craftedStack;
    private int impl$craftedStackQuantity;

    public ResultSlotMixin_Inventory(Container inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public void set(@Nullable ItemStack stack) {
        super.set(stack);
        if (this.player instanceof ServerPlayer) {
            ((ServerPlayer)this.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(0, 0, 0, stack));
        }
    }

    @Inject(method={"checkTakeAchievements"}, at={@At(value="HEAD")})
    private void impl$beforeCrafting(ItemStack itemStack, CallbackInfo ci) {
        this.impl$craftedStackQuantity = this.removeCount;
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void impl$beforeTake(Player thePlayer, ItemStack stack, CallbackInfo ci) {
        if (this.impl$onTakeRecipe == null || !((Recipe)this.impl$onTakeRecipe).matches((Container)this.craftSlots, thePlayer.level())) {
            this.impl$onTakeRecipe = thePlayer.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, thePlayer.level()).orElse(null);
        }
        stack.grow(1);
        this.impl$craftedStack = stack.copy();
        if (this.removeCount != 0) {
            this.impl$craftedStackQuantity = this.removeCount;
        }
        this.impl$craftedStack.setCount(this.impl$craftedStackQuantity);
        stack.shrink(1);
    }

    @Redirect(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager;getRemainingItemsFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/NonNullList;"))
    private <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> impl$onGetRemainingItems(RecipeManager recipeManager, RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn) {
        if (this.impl$onTakeRecipe == null) {
            return NonNullList.withSize((int)inventoryIn.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        return worldIn.getRecipeManager().getRemainingItemsFor(recipeTypeIn, inventoryIn, worldIn);
    }

    @Inject(method={"onTake"}, cancellable=true, at={@At(value="RETURN")})
    private void impl$afterTake(Player thePlayer, ItemStack stack, CallbackInfo cir) {
        if (((LevelBridge)thePlayer.level()).bridge$isFake()) {
            return;
        }
        AbstractContainerMenu container = thePlayer.containerMenu;
        Inventory craftInv = ((Inventory)container).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeCommon.logger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        transactor.logCrafting(thePlayer, this.impl$craftedStack, (CraftingInventory)craftInv, this.impl$onTakeRecipe);
        this.impl$craftedStack = null;
    }
}

