/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.world.entity.player;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin_Bridge_Inventory
implements PlayerInventoryBridge,
InventoryAdapter {
    @Shadow
    public int selected;
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public NonNullList<ItemStack> items;
    @Shadow
    @Final
    public NonNullList<ItemStack> armor;
    @Shadow
    @Final
    public NonNullList<ItemStack> offhand;
    @Shadow
    @Final
    private List<NonNullList<ItemStack>> compartments;
    @Shadow
    private int timesChanged;
    private int impl$lastTimesChanged;
    private int impl$offhandIndex;

    public InventoryMixin_Bridge_Inventory() {
        this.impl$lastTimesChanged = this.timesChanged;
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")}, remap=false)
    private void onConstructed(Player playerIn, CallbackInfo ci) {
        for (NonNullList<ItemStack> inventory : this.compartments) {
            if (inventory == this.offhand) break;
            this.impl$offhandIndex += inventory.size();
        }
    }

    @Override
    public int bridge$getHeldItemIndex(InteractionHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return this.selected;
            }
            case OFF_HAND: {
                return this.impl$offhandIndex;
            }
        }
        throw new AssertionError(hand);
    }

    @Override
    public void bridge$setSelectedItem(int itemIndex, boolean notify) {
        itemIndex %= 9;
        if (notify && this.player instanceof ServerPlayer) {
            ClientboundSetCarriedItemPacket packet = new ClientboundSetCarriedItemPacket(itemIndex);
            ((ServerPlayer)this.player).connection.send((Packet)packet);
        }
        this.selected = itemIndex;
    }

    @Override
    public void bridge$cleanupDirty() {
        if (this.timesChanged != this.impl$lastTimesChanged) {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void bridge$markClean() {
        this.impl$lastTimesChanged = this.timesChanged;
    }
}

