/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.common.service.game.pagination.ActivePagination;
import org.spongepowered.common.service.game.pagination.PaginationCalculator;

final class ListPagination
extends ActivePagination {
    private final List<List<Component>> pages;

    public ListPagination(Supplier<Optional<? extends Audience>> src, PaginationCalculator calc, List<Map.Entry<Component, Integer>> lines, @Nullable Component title, @Nullable Component header, @Nullable Component footer, Component padding) {
        super(src, calc, title, header, footer, padding);
        boolean lastPageNotEmpty;
        ArrayList<List<Component>> pages = new ArrayList<List<Component>>();
        ArrayList<Object> currentPage = new ArrayList<Component>();
        int currentPageLines = 0;
        for (Map.Entry<Component, Integer> ent : lines) {
            boolean spillToNextPage;
            boolean finiteLinesPerPage = this.getMaxContentLinesPerPage() > 0;
            boolean willExceedPageLength = ent.getValue() + currentPageLines > this.getMaxContentLinesPerPage();
            boolean currentPageNotEmpty = currentPageLines != 0;
            boolean bl = spillToNextPage = finiteLinesPerPage && willExceedPageLength && currentPageNotEmpty;
            if (spillToNextPage) {
                this.padPage(currentPage, currentPageLines, true);
                currentPageLines = 0;
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            currentPageLines += ent.getValue().intValue();
            currentPage.add(ent.getKey());
        }
        boolean bl = lastPageNotEmpty = currentPageLines > 0;
        if (lastPageNotEmpty) {
            if (!pages.isEmpty()) {
                this.padPage(currentPage, currentPageLines, false);
            }
            pages.add(currentPage);
        }
        this.pages = pages;
    }

    @Override
    protected Iterable<Component> getLines(int page) throws CommandException {
        int size = this.pages.size();
        if (size == 0) {
            return ImmutableList.of();
        }
        if (page < 1) {
            throw new CommandException((Component)Component.text((String)String.format("Page %s does not exist!", page)));
        }
        if (page > size) {
            throw new CommandException((Component)Component.text((String)String.format("Page %s is greater than the max of %s!", page, size)));
        }
        return this.pages.get(page - 1);
    }

    @Override
    protected boolean hasPrevious(int page) {
        return page > 1;
    }

    @Override
    protected boolean hasNext(int page) {
        return page < this.pages.size();
    }

    @Override
    protected int getTotalPages() {
        return this.pages.size();
    }
}

