/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Range;

public final class SpongeRange<T extends Number>
implements Range<T> {
    private final @Nullable T min;
    private final @Nullable T max;

    public SpongeRange(@Nullable T min, @Nullable T max) {
        if (min == null && max == null) {
            throw new IllegalArgumentException("At least one of min or max must not be null.");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public @Nullable T min() {
        return this.min;
    }

    @Override
    public @Nullable T max() {
        return this.max;
    }

    public static final class FactoryImpl
    implements Range.Factory {
        @Override
        public @NonNull Range<@NonNull Float> floatRange(@Nullable Float min, @Nullable Float max) {
            if (min != null && max != null && max.floatValue() < min.floatValue()) {
                throw new IllegalArgumentException("min must be smaller or equal to max if both are defined");
            }
            return new SpongeRange<Float>(min, max);
        }

        @Override
        public @NonNull Range<@NonNull Integer> intRange(@Nullable Integer min, @Nullable Integer max) {
            if (min != null && max != null && max < min) {
                throw new IllegalArgumentException("min must be smaller or equal to max if both are defined");
            }
            return new SpongeRange<Integer>(min, max);
        }

        @Override
        public @NonNull Range<@NonNull Double> doubleRange(@Nullable Double min, @Nullable Double max) {
            if (min != null && max != null && max < min) {
                throw new IllegalArgumentException("min must be smaller or equal to max if both are defined");
            }
            return new SpongeRange<Double>(min, max);
        }
    }
}

