/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.border;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import org.spongepowered.common.accessor.world.level.border.WorldBorderAccessor;

public final class PlayerOwnBorderListener
implements BorderChangeListener {
    private final ServerPlayer player;

    public PlayerOwnBorderListener(ServerPlayer player) {
        this.player = player;
    }

    public void onBorderSizeSet(WorldBorder border, double newSize) {
        this.sendBorderPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderSizePacket(border));
    }

    public void onBorderSizeLerping(WorldBorder border, double oldSize, double newSize, long time) {
        this.sendBorderPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderLerpSizePacket(border));
    }

    public void onBorderCenterSet(WorldBorder border, double x, double z) {
        this.sendBorderPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderCenterPacket(border));
    }

    public void onBorderSetWarningTime(WorldBorder border, int newTime) {
        this.sendBorderPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderWarningDelayPacket(border));
    }

    public void onBorderSetWarningBlocks(WorldBorder border, int newDistance) {
        this.sendBorderPacket((Packet<ClientGamePacketListener>)new ClientboundSetBorderWarningDistancePacket(border));
    }

    public void onBorderSetDamagePerBlock(WorldBorder border, double newAmount) {
    }

    public void onBorderSetDamageSafeZOne(WorldBorder border, double newSize) {
    }

    public void onPlayerDisconnect() {
        ((org.spongepowered.api.entity.living.player.server.ServerPlayer)this.player).worldBorder().ifPresent(border -> ((WorldBorderAccessor)((Object)border)).accessor$listeners().remove(this));
    }

    private void sendBorderPacket(Packet<ClientGamePacketListener> packet) {
        this.player.connection.send(packet);
    }
}

