/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.file.DeleteFileVisitor;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldManager;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.level.storage.LevelStorageSource_LevelStorageAccessAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.levelgen.WorldOptionsBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public abstract class SpongeWorldManager
implements WorldManager {
    public static RegistryOps<Tag> bootstrapOps;
    private final MinecraftServer server;
    private final Path defaultWorldDirectory;
    private final Path customWorldsDirectory;
    private final Map<net.minecraft.resources.ResourceKey<Level>, ServerLevel> worlds;
    private static final TicketType<ResourceLocation> SPAWN_CHUNKS;

    public SpongeWorldManager(MinecraftServer server) {
        this.server = server;
        this.defaultWorldDirectory = ((LevelStorageSource_LevelStorageAccessAccessor)((MinecraftServerAccessor)this.server).accessor$storageSource()).accessor$levelDirectory().path();
        this.customWorldsDirectory = this.defaultWorldDirectory.resolve("dimensions");
        try {
            Files.createDirectories(this.customWorldsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.worlds = ((MinecraftServerAccessor)this.server).accessor$levels();
    }

    @Override
    public Server server() {
        return (Server)this.server;
    }

    public Path getDefaultWorldDirectory() {
        return this.defaultWorldDirectory;
    }

    @Override
    public Optional<ServerWorld> world(ResourceKey key) {
        return Optional.ofNullable((ServerWorld)this.worlds.get(SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"))));
    }

    @Override
    public Optional<Path> worldDirectory(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        Path directory = this.getDirectory(key);
        if (Files.notExists(directory, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(directory);
    }

    @Override
    public Collection<ServerWorld> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public List<ResourceKey> worldKeys() {
        ArrayList<ResourceKey> worldKeys = new ArrayList<ResourceKey>();
        worldKeys.add(DefaultWorldKeys.DEFAULT);
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_NETHER), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_NETHER);
        }
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_END), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_END);
        }
        try {
            for (Path namespacedDirectory : Files.list(this.customWorldsDirectory).toList()) {
                if (this.customWorldsDirectory.equals(namespacedDirectory)) continue;
                for (Path valueDirectory : Files.list(namespacedDirectory).toList()) {
                    if (namespacedDirectory.equals(valueDirectory)) continue;
                    worldKeys.add(ResourceKey.of(namespacedDirectory.getFileName().toString(), valueDirectory.getFileName().toString()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(worldKeys);
    }

    @Override
    public boolean worldExists(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return true;
        }
        if (this.worlds.get(registryKey) != null) {
            return true;
        }
        return Files.exists(this.getDirectory(key), new LinkOption[0]);
    }

    @Override
    public Optional<ResourceKey> worldKey(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.worlds.values().stream().filter(w -> ((ServerWorld)w).uniqueId().equals(uniqueId)).map(w -> (ServerWorld)w).map(ServerWorld::key).findAny();
    }

    @Override
    public Collection<ServerWorld> worldsOfType(WorldType type) {
        Objects.requireNonNull(type, "type");
        return this.worlds().stream().filter(w -> w.worldType() == type).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate template) {
        ResourceKey key = Objects.requireNonNull(template, "template").key();
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (Level.OVERWORLD.equals(registryKey)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        ServerLevel serverWorld = this.worlds.get(registryKey);
        if (serverWorld != null) {
            return CompletableFuture.completedFuture((ServerWorld)serverWorld);
        }
        this.saveTemplate(template);
        return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template).levelStem());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        ServerLevel world = this.worlds.get(registryKey);
        if (world != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        net.minecraft.resources.ResourceKey rKey = net.minecraft.resources.ResourceKey.create((net.minecraft.resources.ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)((ResourceLocation)key));
        LevelStem levelStem = (LevelStem)SpongeCommon.vanillaRegistry(Registries.LEVEL_STEM).get(rKey);
        if (levelStem != null) {
            return this.loadWorld0(registryKey, levelStem);
        }
        DataPack<WorldTemplate> pack = this.findPack(key);
        return this.loadTemplate(pack, key).thenCompose(template -> {
            if (template.isEmpty()) {
                return FutureUtil.completedWithException(new IOException(String.format("Failed to load a template for '%s'!", key)));
            }
            return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template.get()).levelStem());
        });
    }

    private CompletableFuture<ServerWorld> loadWorld0(net.minecraft.resources.ResourceKey<Level> registryKey, LevelStem levelStem) {
        ServerLevel world;
        ResourceKey worldKey = (ResourceKey)registryKey.location();
        DimensionType dimensionType = (DimensionType)levelStem.type().value();
        Optional<ResourceKey> worldTypeKey = this.worldTypeKey(dimensionType);
        MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        ChunkProgressListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
        try {
            world = this.createLevel(registryKey, levelStem, worldKey, worldTypeKey.orElse(null), chunkStatusListener);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e));
        }
        return ((CompletableFuture)((CompletableFuture)SpongeCommon.asyncScheduler().submit(() -> this.prepareWorld(world)).thenApply(w -> {
            ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
            return w;
        })).thenCompose(w -> this.postWorldLoad(world, false))).thenApply(w -> (ServerWorld)w);
    }

    private LevelStorageSource.LevelStorageAccess getLevelStorageAccess(ResourceKey worldKey) throws IOException {
        if (this.isVanillaWorld(worldKey)) {
            String directoryName = this.getDirectoryName(worldKey);
            return LevelStorageSource.createDefault((Path)this.defaultWorldDirectory).createAccess(directoryName);
        }
        String name = worldKey.namespace() + File.separator + worldKey.value();
        return LevelStorageSource.createDefault((Path)this.customWorldsDirectory).createAccess(name);
    }

    private LevelSettings createLevelSettings(PrimaryLevelData defaultLevelData, LevelStem levelStem, String directoryName) {
        LevelStemBridge levelStemBridge = (LevelStemBridge)levelStem;
        GameType gameType = levelStemBridge.bridge$gameMode();
        Boolean hardcore = levelStemBridge.bridge$hardcore();
        Difficulty difficulty = levelStemBridge.bridge$difficulty();
        Boolean commands = levelStemBridge.bridge$commands();
        return new LevelSettings(directoryName, gameType == null ? defaultLevelData.getGameType() : gameType, hardcore == null ? defaultLevelData.isHardcore() : hardcore.booleanValue(), difficulty == null ? defaultLevelData.getDifficulty() : difficulty, commands == null ? defaultLevelData.getAllowCommands() : commands.booleanValue(), new GameRules(), defaultLevelData.getDataConfiguration());
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel world = this.worlds.get(registryKey);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(world, "world").key());
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (world != this.worlds.get(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            this.unloadWorld0((ServerLevel)world);
            return CompletableFuture.completedFuture(true);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey key) {
        PrimaryLevelData levelData;
        LevelStorageSource.LevelStorageAccess storageSource;
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        try {
            storageSource = this.getLevelStorageAccess(key);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            PrimaryLevelData defaultLevelData = (PrimaryLevelData)this.server.getWorldData();
            try {
                levelData = this.loadLevelData((RegistryAccess)this.server.registryAccess(), defaultLevelData.getDataConfiguration(), storageSource);
            }
            catch (Exception ex) {
                CompletableFuture<Optional<ServerWorldProperties>> completableFuture = FutureUtil.completedWithException(ex);
                try {
                    storageSource.close();
                }
                catch (IOException ex2) {
                    return FutureUtil.completedWithException(ex2);
                }
                return completableFuture;
            }
        }
        finally {
            try {
                storageSource.close();
            }
            catch (IOException ex) {
                return FutureUtil.completedWithException(ex);
            }
        }
        if (levelData == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        DataPack<WorldTemplate> pack = this.findPack(key);
        return this.loadTemplate(pack, key).thenCompose(arg_0 -> SpongeWorldManager.lambda$loadProperties$8((WorldData)levelData, arg_0));
    }

    @Override
    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties properties) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(properties, "properties").key());
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            this.saveLevelDat((WorldData)properties, properties.key());
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        DataPack<WorldTemplate> pack = this.findPack(properties.key());
        return this.loadTemplate(pack, properties.key()).thenCompose(r -> {
            WorldTemplate template = r.orElse(null);
            if (template != null) {
                return this.saveTemplate((WorldTemplate)((WorldTemplate.Builder)WorldTemplate.builder().from(template)).from(properties).build());
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    private void saveLevelDat(WorldData properties, ResourceKey key) throws IOException {
        try (LevelStorageSource.LevelStorageAccess storageSource = this.getLevelStorageAccess(key);){
            storageSource.saveDataTag((RegistryAccess)this.server.registryAccess(), properties, null);
        }
    }

    @Override
    public CompletableFuture<Boolean> copyWorld(ResourceKey key, ResourceKey copyKey) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        net.minecraft.resources.ResourceKey<Level> copyRegistryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(copyKey, "copyKey"));
        if (Level.OVERWORLD.equals(copyRegistryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        boolean disableLevelSaving = false;
        if (loadedWorld != null) {
            disableLevelSaving = loadedWorld.noSave;
            loadedWorld.save(null, true, loadedWorld.noSave);
            loadedWorld.noSave = true;
        }
        final boolean isDefaultWorld = DefaultWorldKeys.DEFAULT.equals(key);
        final Path originalDirectory = this.getDirectory(key);
        final Path copyDirectory = this.getDirectory(copyKey);
        try {
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals("dimensions")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (isDefaultWorld && SpongeWorldManager.this.isVanillaSubWorld(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path relativize = originalDirectory.relativize(dir);
                    Path directory = copyDirectory.resolve(relativize);
                    Files.createDirectories(directory, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("level_sponge.dat_old")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (fileName.equals(Constants.World.LEVEL_DAT_OLD)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, copyDirectory.resolve(originalDirectory.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            try {
                Files.walkFileTree(copyDirectory, DeleteFileVisitor.INSTANCE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FutureUtil.completedWithException(e);
        }
        if (loadedWorld != null) {
            loadedWorld.noSave = disableLevelSaving;
        }
        try {
            this.server().dataPackManager().copy(this.findPack(key), key, copyKey);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> moveWorld(ResourceKey key, ResourceKey movedKey) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(movedKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path originalDirectory = this.getDirectory(key);
        Path movedDirectory = this.getDirectory(movedKey);
        try {
            Files.createDirectories(movedDirectory, new FileAttribute[0]);
            Files.move(originalDirectory, movedDirectory, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path configFile = this.getConfigFile(key);
        Path movedConfigFile = this.getConfigFile(movedKey);
        try {
            Files.createDirectories(movedConfigFile.getParent(), new FileAttribute[0]);
            Files.move(configFile, movedConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            this.server().dataPackManager().move(this.findPack(key), key, movedKey);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        Path directory;
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            boolean disableLevelSaving = loadedWorld.noSave;
            loadedWorld.noSave = true;
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                loadedWorld.noSave = disableLevelSaving;
                return FutureUtil.completedWithException(e);
            }
        }
        if (Files.exists(directory = this.getDirectory(key), new LinkOption[0])) {
            try {
                Files.walkFileTree(directory, DeleteFileVisitor.INSTANCE);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path configFile = this.getConfigFile(key);
        try {
            Files.deleteIfExists(configFile);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            this.server().dataPackManager().delete(this.findPack(key), key);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    private DataPack<WorldTemplate> findPack(ResourceKey key) {
        return this.server().dataPackManager().findPack(DataPackTypes.WORLD, key).orElse(DataPacks.WORLD);
    }

    private void unloadWorld0(ServerLevel world) throws IOException {
        net.minecraft.resources.ResourceKey registryKey = world.dimension();
        if (world.getPlayers(p -> true).size() != 0) {
            throw new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.location()));
        }
        Optional<ResourceKey> worldTypeKey = this.worldTypeKey(world.dimensionType());
        SpongeCommon.logger().info("Unloading world '{}' ({})", (Object)registryKey.location(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world);
        SpongeCommon.post(unloadWorldEvent);
        BlockPos spawnPoint = world.getSharedSpawnPos();
        world.getChunkSource().removeRegionTicket(SPAWN_CHUNKS, new ChunkPos(spawnPoint), 11, (Object)registryKey.location());
        ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().save();
        try {
            world.save(null, true, world.noSave);
            world.close();
            ((ServerLevelBridge)world).bridge$getLevelSave().close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        this.worlds.remove(registryKey);
    }

    public void loadLevel() {
        boolean multiworldEnabled;
        boolean bl = multiworldEnabled = this.server.isSingleplayer() || this.server.isNetherEnabled();
        if (!multiworldEnabled) {
            SpongeCommon.logger().warn("The option 'allow-nether' has been set to 'false' in the server.properties. Multi-World support has been disabled and no worlds besides the default world will be loaded.");
        }
        ChunkProgressListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
        Registry registry = SpongeCommon.vanillaRegistry(Registries.LEVEL_STEM);
        for (LevelStem template : registry) {
            ResourceKey worldKey = (ResourceKey)registry.getKey((Object)template);
            LevelStemBridge templateBridge = (LevelStemBridge)template;
            boolean isDefaultWorld = DefaultWorldKeys.DEFAULT.equals(worldKey);
            if (!isDefaultWorld && !multiworldEnabled) continue;
            DimensionType dimensionType = (DimensionType)template.type().value();
            Optional<ResourceKey> worldTypeKey = this.worldTypeKey(dimensionType);
            if (!isDefaultWorld && !templateBridge.bridge$loadOnStartup()) {
                SpongeCommon.logger().warn("World '{}' has been disabled from loading at startup. Skipping...", (Object)worldKey);
                continue;
            }
            MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(worldKey);
            if (isDefaultWorld) {
                LevelStorageSource.LevelStorageAccess storageSource = ((MinecraftServerAccessor)this.server).accessor$storageSource();
                PrimaryLevelData levelData = (PrimaryLevelData)this.server.getWorldData();
                ((ResourceKeyBridge)levelData).bridge$setKey((ResourceKey)registryKey.location());
                ImmutableList spawners = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)levelData));
                ServerLevel world = this.createLevel(registryKey, template, worldKey, worldTypeKey.orElse(null), storageSource, levelData, (List<CustomSpawner>)spawners, chunkStatusListener);
                world.getWorldBorder().applySettings(levelData.getWorldBorder());
                this.prepareWorld(world);
                continue;
            }
            try {
                ServerLevel world = this.createLevel(registryKey, template, worldKey, worldTypeKey.orElse(null), chunkStatusListener);
                world.getWorldBorder().applySettings(((PrimaryLevelData)world.getLevelData()).getWorldBorder());
                this.prepareWorld(world);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e);
            }
        }
        ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
        for (Map.Entry<net.minecraft.resources.ResourceKey<Level>, ServerLevel> entry : this.worlds.entrySet()) {
            try {
                this.postWorldLoad(entry.getValue(), true).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        ((SpongeUserManager)Sponge.server().userManager()).init();
        ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().load();
    }

    private PrimaryLevelData getOrCreateLevelData(LevelStorageSource.LevelStorageAccess storageSource, LevelStem levelStem, String directoryName) {
        PrimaryLevelData defaultLevelData = (PrimaryLevelData)this.server.getWorldData();
        @Nullable PrimaryLevelData levelData = this.loadLevelData((RegistryAccess)this.server.registryAccess(), defaultLevelData.getDataConfiguration(), storageSource);
        if (levelData != null) {
            return levelData;
        }
        if (this.server.isDemo()) {
            return new PrimaryLevelData(MinecraftServer.DEMO_SETTINGS, WorldOptions.DEMO_OPTIONS, PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable());
        }
        LevelSettings levelSettings = this.createLevelSettings(defaultLevelData, levelStem, directoryName);
        Long customSeed = ((LevelStemBridge)levelStem).bridge$seed();
        if (customSeed != null) {
            WorldOptions generationSettings = ((WorldOptionsBridge)defaultLevelData.worldGenOptions()).bridge$withSeed(customSeed);
            return new PrimaryLevelData(levelSettings, generationSettings, PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable());
        }
        return new PrimaryLevelData(levelSettings, defaultLevelData.worldGenOptions(), PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable());
    }

    @Nullable
    private PrimaryLevelData loadLevelData(RegistryAccess access, WorldDataConfiguration datapackConfig, LevelStorageSource.LevelStorageAccess storageSource) {
        Pair dataTag = storageSource.getDataTag(bootstrapOps, datapackConfig, access.registryOrThrow(Registries.LEVEL_STEM), Lifecycle.stable());
        return dataTag == null ? null : (PrimaryLevelData)dataTag.getFirst();
    }

    private ServerLevel createLevel(net.minecraft.resources.ResourceKey<Level> registryKey, LevelStem levelStem, ResourceKey worldKey, @Nullable ResourceKey worldTypeKey, ChunkProgressListener chunkStatusListener) throws IOException {
        String directoryName = this.getDirectoryName(worldKey);
        LevelStorageSource.LevelStorageAccess storageSource = this.getLevelStorageAccess(worldKey);
        PrimaryLevelData levelData = this.getOrCreateLevelData(storageSource, levelStem, directoryName);
        ((ResourceKeyBridge)levelData).bridge$setKey(worldKey);
        return this.createLevel(registryKey, levelStem, worldKey, worldTypeKey, storageSource, levelData, (List<CustomSpawner>)ImmutableList.of(), chunkStatusListener);
    }

    private ServerLevel createLevel(net.minecraft.resources.ResourceKey<Level> registryKey, LevelStem levelStem, ResourceKey worldKey, @Nullable ResourceKey worldTypeKey, LevelStorageSource.LevelStorageAccess storageSource, PrimaryLevelData levelData, List<CustomSpawner> spawners, ChunkProgressListener chunkStatusListener) {
        ((PrimaryLevelDataBridge)levelData).bridge$populateFromLevelStem(levelStem);
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey, worldKey);
        ((PrimaryLevelDataBridge)levelData).bridge$configAdapter(configAdapter);
        levelData.setModdedInfo(this.server.getServerModName(), this.server.getModdedStatus().shouldReportAsModified());
        long seed = BiomeManager.obfuscateSeed((long)levelData.worldGenOptions().seed());
        Executor executor = ((MinecraftServerAccessor)this.server).accessor$executor();
        ServerLevel world = new ServerLevel(this.server, executor, storageSource, (ServerLevelData)levelData, registryKey, levelStem, chunkStatusListener, levelData.isDebugWorld(), seed, spawners, true, null);
        this.worlds.put(registryKey, world);
        return world;
    }

    private ServerLevel prepareWorld(ServerLevel world) {
        boolean isDefaultWorld = Level.OVERWORLD.equals(world.dimension());
        PrimaryLevelData levelData = (PrimaryLevelData)world.getLevelData();
        PrimaryLevelDataBridge levelDataBridge = (PrimaryLevelDataBridge)levelData;
        if (isDefaultWorld) {
            ((MinecraftServerAccessor)this.server).accessor$readScoreboard(world.getDataStorage());
            ((MinecraftServerAccessor)this.server).accessor$commandStorage(new CommandStorage(world.getDataStorage()));
        }
        boolean isInitialized = levelData.isInitialized();
        LoadWorldEvent loadWorldEvent = SpongeEventFactory.createLoadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world, isInitialized);
        SpongeCommon.post(loadWorldEvent);
        PlatformHooks.INSTANCE.getWorldHooks().postLoadWorld(world);
        levelDataBridge.bridge$triggerViewDistanceLogic();
        world.getWorldBorder().applySettings(levelData.getWorldBorder());
        if (!isInitialized) {
            try {
                boolean isDebugGeneration = levelData.isDebugWorld();
                boolean hasSpawnAlready = levelDataBridge.bridge$customSpawnPosition();
                if (!hasSpawnAlready) {
                    if (isDefaultWorld || levelDataBridge.bridge$performsSpawnLogic()) {
                        MinecraftServerAccessor.invoker$setInitialSpawn(world, (ServerLevelData)levelData, levelData.worldGenOptions().generateBonusChest(), isDebugGeneration);
                    } else if (Level.END.equals(world.dimension())) {
                        levelData.setSpawn(ServerLevel.END_SPAWN_POINT, 0.0f);
                    }
                } else if (levelData.worldGenOptions().generateBonusChest()) {
                    BlockPos pos = new BlockPos(levelData.getXSpawn(), levelData.getYSpawn(), levelData.getZSpawn());
                    ConfiguredFeature bonusChestFeature = (ConfiguredFeature)SpongeCommon.vanillaRegistry(Registries.CONFIGURED_FEATURE).get(MiscOverworldFeatures.BONUS_CHEST);
                    bonusChestFeature.place((WorldGenLevel)world, world.getChunkSource().getGenerator(), world.random, pos);
                }
                levelData.setInitialized(true);
                if (isDebugGeneration) {
                    ((MinecraftServerAccessor)this.server).invoker$setupDebugLevel((WorldData)levelData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)("Exception initializing world '" + world.dimension().location() + "'"));
                try {
                    world.fillReportDetails(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            levelData.setInitialized(true);
        }
        this.server.getPlayerList().addWorldborderListener(world);
        if (levelData.getCustomBossEvents() != null) {
            ((ServerLevelBridge)world).bridge$getBossBarManager().load(levelData.getCustomBossEvents());
        }
        return world;
    }

    private CompletableFuture<ServerLevel> postWorldLoad(ServerLevel world, boolean blocking) {
        PrimaryLevelData levelData = (PrimaryLevelData)world.getLevelData();
        PrimaryLevelDataBridge levelBridge = (PrimaryLevelDataBridge)levelData;
        if (Level.OVERWORLD.equals(world.dimension()) || levelBridge.bridge$performsSpawnLogic()) {
            Optional<ResourceKey> worldTypeKey = this.worldTypeKey(world.dimensionType());
            MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for world '{}' ({})", (Object)world.dimension().location(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            if (blocking) {
                this.loadSpawnChunks(world);
                return CompletableFuture.completedFuture(world);
            }
            return this.loadSpawnChunksAsync(world);
        }
        return CompletableFuture.completedFuture(world);
    }

    private Optional<ResourceKey> worldTypeKey(DimensionType type) {
        return Optional.ofNullable(SpongeCommon.vanillaRegistry(Registries.DIMENSION_TYPE).getKey((Object)type)).map(ResourceKey.class::cast);
    }

    private CompletableFuture<ServerLevel> loadSpawnChunksAsync(ServerLevel world) {
        BlockPos spawnPoint = world.getSharedSpawnPos();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ServerChunkCache serverChunkProvider = world.getChunkSource();
        int borderRadius = 11;
        int diameter = 21;
        int spawnChunks = 441;
        serverChunkProvider.addRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        CompletableFuture generationFuture = new CompletableFuture();
        Sponge.asyncScheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(task -> {
            if (serverChunkProvider.getTickingGenerated() >= 441) {
                Sponge.server().scheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(() -> generationFuture.complete(world)).build());
                task.cancel();
                MinecraftServerAccessor.accessor$LOGGER().info("Done preparing start region for world '{}' ({})", (Object)world.dimension().location(), (Object)this.worldTypeKey(world.dimensionType()).map(Object::toString).orElse("inline"));
            }
        }).interval(10L, TimeUnit.MILLISECONDS).build());
        return generationFuture.thenApply(v -> {
            this.updateForcedChunks(world, serverChunkProvider);
            if (!((PrimaryLevelDataBridge)world.getLevelData()).bridge$performsSpawnLogic()) {
                serverChunkProvider.removeRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
            }
            return world;
        });
    }

    private void loadSpawnChunks(ServerLevel world) {
        BlockPos spawnPoint = world.getSharedSpawnPos();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ChunkProgressListener chunkStatusListener = ((ServerLevelBridge)world).bridge$getChunkStatusListener();
        chunkStatusListener.updateSpawnPos(chunkPos);
        ServerChunkCache serverChunkProvider = world.getChunkSource();
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis());
        serverChunkProvider.addRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        while (serverChunkProvider.getTickingGenerated() != 441) {
            ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
            ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        }
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        this.updateForcedChunks(world, serverChunkProvider);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        chunkStatusListener.stop();
        if (!((PrimaryLevelDataBridge)world.getLevelData()).bridge$performsSpawnLogic()) {
            serverChunkProvider.removeRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        }
    }

    private void updateForcedChunks(ServerLevel world, ServerChunkCache serverChunkProvider) {
        ForcedChunksSavedData forcedChunksSaveData = (ForcedChunksSavedData)world.getDataStorage().get(ForcedChunksSavedData::load, "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.getChunks().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                ChunkPos forceChunkPos = new ChunkPos(i);
                serverChunkProvider.updateChunkForced(forceChunkPos, true);
            }
        }
    }

    private CompletionStage<Boolean> saveTemplate(WorldTemplate template) {
        return this.server().dataPackManager().save(template).thenApply(b -> true);
    }

    private CompletableFuture<Optional<WorldTemplate>> loadTemplate(DataPack<WorldTemplate> pack, ResourceKey key) {
        if (this.server().dataPackManager().exists(pack, key)) {
            return this.server().dataPackManager().load(pack, key).exceptionally(e -> {
                e.printStackTrace();
                return Optional.empty();
            });
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public static net.minecraft.resources.ResourceKey<Level> createRegistryKey(ResourceKey key) {
        return net.minecraft.resources.ResourceKey.create((net.minecraft.resources.ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)key));
    }

    private LevelStorageSource.LevelStorageAccess createStorageSource(ResourceKey key) throws IOException {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            LevelStorageSource.createDefault((Path)this.defaultWorldDirectory.getParent()).createAccess(this.defaultWorldDirectory.getFileName().toString());
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return LevelStorageSource.createDefault((Path)this.defaultWorldDirectory).createAccess("DIM-1");
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return LevelStorageSource.createDefault((Path)this.defaultWorldDirectory).createAccess("DIM1");
        }
        return LevelStorageSource.createDefault((Path)this.customWorldsDirectory).createAccess(key.namespace() + File.separator + key.value());
    }

    private String getDirectoryName(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            return "";
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return "DIM-1";
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return "DIM1";
        }
        return key.value();
    }

    private Path getDirectory(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            return this.defaultWorldDirectory;
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return this.defaultWorldDirectory.resolve("DIM-1");
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return this.defaultWorldDirectory.resolve("DIM1");
        }
        return this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
    }

    private boolean isVanillaWorld(ResourceKey key) {
        return DefaultWorldKeys.DEFAULT.equals(key) || DefaultWorldKeys.THE_NETHER.equals(key) || DefaultWorldKeys.THE_END.equals(key);
    }

    private boolean isVanillaSubWorld(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    private Path getConfigFile(ResourceKey key) {
        return SpongeCommon.spongeConfigDirectory().resolve(((Launch)Launch.instance()).id()).resolve("worlds").resolve(key.namespace()).resolve(key.value() + ".conf");
    }

    private static /* synthetic */ CompletionStage lambda$loadProperties$8(WorldData levelData, Optional template) {
        if (template.isPresent()) {
            LevelStem scratch = ((SpongeWorldTemplate)template.get()).levelStem();
            ((PrimaryLevelDataBridge)levelData).bridge$populateFromLevelStem(scratch);
        }
        return CompletableFuture.completedFuture(Optional.of((ServerWorldProperties)levelData));
    }

    static {
        SPAWN_CHUNKS = TicketType.create((String)"spawn_chunks", ResourceLocation::compareTo);
    }
}

