/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.stream.VolumeCollector;
import org.spongepowered.api.world.volume.stream.VolumeConsumer;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeFlatMapper;
import org.spongepowered.api.world.volume.stream.VolumeMapper;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslator;
import org.spongepowered.api.world.volume.stream.VolumePredicate;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;

public class SpongeVolumeStream<V extends Volume, T>
implements VolumeStream<V, T> {
    private final Supplier<? extends V> volumeSupplier;
    private final Stream<VolumeElement<V, T>> stream;

    public SpongeVolumeStream(Stream<VolumeElement<V, T>> elementStream, Supplier<? extends V> volumeSupplier) {
        this.stream = elementStream;
        this.volumeSupplier = volumeSupplier;
    }

    @Override
    public V volume() {
        return (V)((Volume)this.volumeSupplier.get());
    }

    @Override
    public VolumeStream<V, T> filter(VolumePredicate<V, T> predicate) {
        return new SpongeVolumeStream<V, T>(this.stream.filter((? super T element) -> predicate.test((Volume)this.volumeSupplier.get(), element::type, element.position().x(), element.position().y(), element.position().z())), this.volumeSupplier);
    }

    @Override
    public VolumeStream<V, T> filter(Predicate<VolumeElement<V, ? super T>> predicate) {
        return new SpongeVolumeStream<V, T>(this.stream.filter(predicate), this.volumeSupplier);
    }

    @Override
    public <Out> VolumeStream<V, Out> map(VolumeMapper<V, T, Out> mapper) {
        return new SpongeVolumeStream<V, T>(this.stream.map((? super T element) -> VolumeElement.of((Volume)this.volumeSupplier.get(), mapper.map((Volume)this.volumeSupplier.get(), element::type, element.position().x(), element.position().y(), element.position().z()), element.position())), this.volumeSupplier);
    }

    @Override
    public VolumeStream<V, Optional<? extends T>> flatMap(VolumeFlatMapper<V, T> mapper) {
        return new SpongeVolumeStream<V, T>(this.stream.map((? super T element) -> VolumeElement.of((Volume)this.volumeSupplier.get(), mapper.map((Volume)this.volumeSupplier.get(), element::type, element.position().x(), element.position().y(), element.position().z()), element.position())), this.volumeSupplier);
    }

    @Override
    public VolumeStream<V, T> transform(VolumePositionTranslator<V, T> transformer) {
        return new SpongeVolumeStream<V, T>(this.stream.map(transformer::apply), this.volumeSupplier);
    }

    @Override
    public <Out> VolumeStream<V, Out> map(Function<VolumeElement<V, T>, ? extends Out> mapper) {
        return new SpongeVolumeStream<V, T>(this.stream.map((? super T element) -> VolumeElement.of(this.volume(), mapper.apply((VolumeElement<V, T>)element), element.position())), this.volumeSupplier);
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public boolean allMatch(VolumePredicate<V, ? super T> predicate) {
        return this.stream.allMatch((? super T element) -> predicate.test(this.volume(), element::type, element.position().x(), element.position().y(), element.position().z()));
    }

    @Override
    public boolean allMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(VolumePredicate<V, ? super T> predicate) {
        return this.stream.noneMatch((? super T element) -> predicate.test(this.volume(), element::type, element.position().x(), element.position().y(), element.position().z()));
    }

    @Override
    public boolean noneMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.stream.noneMatch(predicate);
    }

    @Override
    public boolean anyMatch(VolumePredicate<V, ? super T> predicate) {
        return this.stream.anyMatch((? super T element) -> predicate.test(this.volume(), element::type, element.position().x(), element.position().y(), element.position().z()));
    }

    @Override
    public boolean anyMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public Optional<VolumeElement<V, T>> findFirst() {
        return this.stream.findFirst();
    }

    @Override
    public Optional<VolumeElement<V, T>> findAny() {
        return this.stream.findAny();
    }

    @Override
    public Stream<VolumeElement<V, T>> toStream() {
        return this.stream;
    }

    @Override
    public <W extends MutableVolume> void apply(VolumeCollector<W, T, ?> collector) {
        PhaseTracker instance = PhaseTracker.getInstance();
        try (@Nullable PhaseContext<@NonNull P> context = instance.getPhaseContext().isApplyingStreams() ? null : PluginPhase.State.VOLUME_STREAM_APPLICATION.createPhaseContext(instance).setVolumeStream(this).spawnType(() -> PhaseTracker.getCauseStackManager().context(EventContextKeys.SPAWN_TYPE).orElse(null));){
            if (context != null) {
                context.buildAndSwitch();
            }
            this.stream.forEach((? super T element) -> {
                MutableVolume targetVolume = (MutableVolume)collector.target().get();
                @Nullable VolumeElement<@NonNull Supplier<M>, Supplier<Object>> transformed = collector.positionTransform().apply(VolumeElement.of(collector.target(), element::type, element.position()));
                collector.applicator().apply(targetVolume, transformed);
            });
        }
    }

    @Override
    public <W extends MutableVolume, R> void applyUntil(VolumeCollector<W, T, R> collector, Predicate<R> predicate) {
        boolean doWork = true;
        Iterator iterator = this.stream.iterator();
        while (doWork && iterator.hasNext()) {
            MutableVolume targetVolume = (MutableVolume)collector.target().get();
            VolumeElement element = (VolumeElement)iterator.next();
            VolumeElement<Supplier<W>, Supplier<Object>> transformed = collector.positionTransform().apply(VolumeElement.of(collector.target(), element::type, element.position()));
            R apply = collector.applicator().apply(targetVolume, transformed);
            doWork = predicate.test(apply);
        }
    }

    @Override
    public void forEach(VolumeConsumer<V, T> visitor) {
        this.stream.forEach((? super T element) -> visitor.consume(element.volume(), element.type(), element.position().x(), element.position().y(), element.position().z()));
    }

    @Override
    public void forEach(Consumer<VolumeElement<V, T>> consumer) {
        this.stream.forEach(consumer);
    }
}

