/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class ChatFormatter {
    private static final String DEFAULT_SCHEME = "http://";
    private static final String SCHEME = "https?://";
    private static final String IP_ADDRESS = "(?:\\d{1,3}\\.){3}\\d{1,3}";
    private static final String DOMAIN = "(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?";
    private static final String PORT = "\\d{1,5}";
    private static final String PATH = ".*?";
    private static final Pattern URL_PATTERN = Pattern.compile("(?:https?://)?(?:(?:\\d{1,3}\\.){3}\\d{1,3}|(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?)(?::\\d{1,5})?.*?(?=[!?,;:\"']?(?:[\u00a7\\s]|$))", 2);

    private ChatFormatter() {
    }

    @Nullable
    public static MutableComponent format(String s) {
        Matcher matcher = URL_PATTERN.matcher(s);
        if (!matcher.find()) {
            LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacyAmpersand();
            return SpongeAdventure.asVanillaMutable((net.kyori.adventure.text.Component)legacyComponentSerializer.deserialize(s));
        }
        MutableComponent result = null;
        int pos = 0;
        do {
            Object url;
            String displayUrl;
            int end;
            int start;
            block11: {
                start = matcher.start();
                end = matcher.end();
                displayUrl = s.substring(start, end);
                url = displayUrl;
                try {
                    if (new URI((String)url).getScheme() != null) break block11;
                    url = DEFAULT_SCHEME + (String)url;
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            if (pos < start) {
                if (result == null) {
                    result = Component.literal((String)s.substring(pos, start));
                } else {
                    result.append(s.substring(pos, start));
                }
            }
            pos = end;
            MutableComponent link = Component.literal((String)displayUrl);
            link.setStyle(link.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url)));
            if (result == null) {
                result = Component.literal((String)"");
            }
            result.append((Component)link);
        } while (matcher.find());
        if (pos < s.length()) {
            if (result == null) {
                result = Component.literal((String)s.substring(pos));
            } else {
                result.append(s.substring(pos));
            }
        }
        return result;
    }
}

