/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.spongepowered.vanilla.installer.AsyncUtils;
import org.spongepowered.vanilla.installer.InstallerUtils;
import org.spongepowered.vanilla.installer.LauncherCommandLine;
import org.spongepowered.vanilla.installer.model.sponge.Libraries;
import org.spongepowered.vanilla.installer.model.sponge.SonatypeResponse;
import org.tinylog.Logger;

public final class LibraryManager {
    private final boolean checkLibraryHashes;
    private final Path rootDirectory;
    private final URL librariesUrl;
    private final Map<String, Set<Library>> libraries;
    private final ExecutorService preparationWorker;
    private final Gson gson;

    public LibraryManager(boolean checkLibraryHashes, Path rootDirectory, URL librariesUrl) {
        this.checkLibraryHashes = checkLibraryHashes;
        this.rootDirectory = rootDirectory;
        this.librariesUrl = librariesUrl;
        this.libraries = new LinkedHashMap<String, Set<Library>>();
        int availableCpus = Runtime.getRuntime().availableProcessors();
        this.preparationWorker = new ThreadPoolExecutor(Math.min(Math.max(4, availableCpus * 2), 64), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.gson = new Gson();
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public Set<Library> getAll(String collection) {
        return Collections.unmodifiableSet(this.libraries.getOrDefault(collection, Collections.emptySet()));
    }

    protected void addLibrary(String set, Library library) {
        this.libraries.computeIfAbsent(set, $ -> Collections.synchronizedSet(new LinkedHashSet())).add(library);
    }

    public void validate() throws Exception {
        Libraries dependencies;
        Logger.info("Scanning and verifying libraries in '{}'. Please wait, this may take a moment...", LauncherCommandLine.librariesDirectory.toAbsolutePath());
        try (JsonReader reader = new JsonReader(new InputStreamReader(this.librariesUrl.openStream(), StandardCharsets.UTF_8));){
            dependencies = (Libraries)this.gson.fromJson(reader, (Type)((Object)Libraries.class));
        }
        HashMap<String, Set<Library>> downloadedDeps = new HashMap<String, Set<Library>>();
        HashMap<String, CompletableFuture<Path>> operations = new HashMap<String, CompletableFuture<Path>>();
        ConcurrentHashMap.KeySetView failures = ConcurrentHashMap.newKeySet();
        for (Map.Entry<String, List<Libraries.Dependency>> setEntry : dependencies.dependencies.entrySet()) {
            downloadedDeps.put(setEntry.getKey(), this.scheduleDownloads(setEntry.getKey(), setEntry.getValue(), operations, failures));
        }
        ((CompletableFuture)CompletableFuture.allOf(operations.values().toArray(new CompletableFuture[0])).handle((result, err) -> {
            if (err != null) {
                failures.add(err.getMessage());
                Logger.error(err, "Failed to download library");
            }
            return result;
        })).join();
        if (!failures.isEmpty()) {
            Logger.error("Failed to download some libraries:");
            for (String message : failures) {
                Logger.error(message);
            }
            System.exit(-1);
        }
        this.libraries.putAll(downloadedDeps);
    }

    private Set<Library> scheduleDownloads(String collection, List<Libraries.Dependency> dependencies, Map<String, CompletableFuture<Path>> operations, Set<String> failures) {
        Set<Library> downloadedDeps = Collections.synchronizedSet(new LinkedHashSet(dependencies.size()));
        for (Libraries.Dependency dependency : dependencies) {
            operations.computeIfAbsent(LibraryManager.asId(dependency), $ -> AsyncUtils.asyncFailableFuture(() -> {
                String groupPath = dependency.group.replace(".", "/");
                Path depDirectory = this.rootDirectory.resolve(groupPath).resolve(dependency.module).resolve(dependency.version);
                Files.createDirectories(depDirectory, new FileAttribute[0]);
                Path depFile = depDirectory.resolve(dependency.module + "-" + dependency.version + ".jar");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                boolean checkHashes = this.checkLibraryHashes;
                if (Files.exists(depFile, new LinkOption[0])) {
                    if (!checkHashes) {
                        Logger.info("Detected existing '{}', skipping hash checks...", depFile);
                        return depFile;
                    }
                    byte[] bytes = Files.readAllBytes(depFile);
                    String fileMd5 = InstallerUtils.toHexString(md5.digest(bytes));
                    if (dependency.md5.equals(fileMd5)) {
                        Logger.debug("'{}' verified!", depFile);
                    } else {
                        Logger.error("Checksum verification failed: Expected {}, {}. Deleting cached '{}'...", dependency.md5, fileMd5, depFile);
                        Files.delete(depFile);
                        SonatypeResponse response = this.getResponseFor(this.gson, dependency);
                        if (response.items.isEmpty()) {
                            failures.add("No data received from '" + new URL(String.format("https://repo.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                            return null;
                        }
                        SonatypeResponse.Item item = response.items.get(0);
                        URL url = item.downloadUrl;
                        InstallerUtils.downloadCheckHash(url, depFile, md5, item.checksum.md5);
                    }
                } else {
                    SonatypeResponse response = this.getResponseFor(this.gson, dependency);
                    if (response.items.isEmpty()) {
                        failures.add("No data received from '" + new URL(String.format("https://repo.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                        return null;
                    }
                    SonatypeResponse.Item item = response.items.get(0);
                    URL url = item.downloadUrl;
                    if (checkHashes) {
                        InstallerUtils.downloadCheckHash(url, depFile, md5, item.checksum.md5);
                    } else {
                        InstallerUtils.download(url, depFile, true);
                    }
                }
                return depFile;
            }, this.preparationWorker)).whenComplete((res, err) -> {
                if (res != null) {
                    downloadedDeps.add(new Library(LibraryManager.asId(dependency), (Path)res));
                }
            });
        }
        return downloadedDeps;
    }

    private SonatypeResponse getResponseFor(Gson gson, Libraries.Dependency dependency) throws IOException {
        URL requestUrl = new URL(String.format("https://repo.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version));
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Sponge-Downloader Minecraft/1.20.1");
        connection.connect();
        try (JsonReader reader = new JsonReader(new InputStreamReader(connection.getInputStream()));){
            SonatypeResponse sonatypeResponse = (SonatypeResponse)gson.fromJson(reader, (Type)((Object)SonatypeResponse.class));
            return sonatypeResponse;
        }
    }

    public ExecutorService preparationWorker() {
        return this.preparationWorker;
    }

    public void finishedProcessing() {
        boolean successful;
        if (this.preparationWorker.isTerminated()) {
            return;
        }
        this.preparationWorker.shutdown();
        try {
            successful = this.preparationWorker.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            successful = false;
        }
        if (!successful) {
            Logger.warn("Failed to shut down library preparation pool in 10 seconds, forcing shutdown now.");
            this.preparationWorker.shutdownNow();
        }
    }

    private static String asId(Libraries.Dependency dep) {
        return dep.group + ":" + dep.module + ":" + dep.version;
    }

    public static class Library {
        private final String name;
        private final Path file;

        public Library(String name, Path file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

