/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import com.google.inject.Inject;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Client;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.SystemSubject;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.util.metric.MetricsConfigManager;

public final class Sponge {
    @Inject
    private static @Nullable Game game;

    public static Game game() {
        if (game == null) {
            throw new IllegalStateException("Sponge has not been initialized!");
        }
        return game;
    }

    public static Platform platform() {
        return Sponge.game().platform();
    }

    public static DataManager dataManager() {
        return Sponge.game().dataManager();
    }

    public static PluginManager pluginManager() {
        return Sponge.game().pluginManager();
    }

    public static EventManager eventManager() {
        return Sponge.game().eventManager();
    }

    public static ConfigManager configManager() {
        return Sponge.game().configManager();
    }

    public static ChannelManager channelManager() {
        return Sponge.game().channelManager();
    }

    public static boolean isServerAvailable() {
        return Sponge.game().isServerAvailable();
    }

    public static Server server() {
        return Sponge.game().server();
    }

    public static boolean isClientAvailable() {
        return Sponge.game().isClientAvailable();
    }

    public static Client client() {
        return Sponge.game().client();
    }

    public static SystemSubject systemSubject() {
        return Sponge.game().systemSubject();
    }

    public static MetricsConfigManager metricsConfigManager() {
        return Sponge.game().metricsConfigManager();
    }

    public static Scheduler asyncScheduler() {
        return Sponge.game().asyncScheduler();
    }

    public static ServiceProvider.GameScoped serviceProvider() {
        return Sponge.game().serviceProvider();
    }
}

