/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.selector;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.math.vector.Vector3d;

public interface Selector {
    public static Selector parse(String string) throws IllegalArgumentException {
        return Sponge.game().factoryProvider().provide(Factory.class).parse(string);
    }

    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public Collection<Entity> select(ServerLocation var1) throws IllegalStateException;

    public Collection<Entity> select(Entity var1) throws IllegalStateException;

    public Collection<Entity> select(CommandCause var1);

    public int limit();

    public boolean playersOnly();

    public static interface Factory {
        public Selector parse(String var1) throws IllegalArgumentException;
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Selector, Builder> {
        public Builder applySelectorType(Supplier<? extends SelectorType> var1);

        public Builder applySelectorType(SelectorType var1);

        public Builder includeSelf();

        public Builder limit(int var1);

        public Builder distance(Range<Double> var1);

        public Builder volume(Vector3d var1, Vector3d var2);

        public Builder sortAlgorithm(Supplier<? extends SelectorSortAlgorithm> var1);

        public Builder sortAlgorithm(SelectorSortAlgorithm var1);

        public Builder addAdvancement(ResourceKey var1);

        public Builder addNotAdvancement(ResourceKey var1);

        public Builder addAdvancementCriterion(ResourceKey var1, AdvancementCriterion var2);

        public Builder addNotAdvancementCriterion(ResourceKey var1, AdvancementCriterion var2);

        public Builder dataView(DataView var1);

        public Builder addEntityType(Supplier<EntityType<?>> var1, boolean var2);

        public Builder addEntityType(EntityType<?> var1, boolean var2);

        public Builder addNotEntityType(Supplier<EntityType<?>> var1);

        public Builder addNotEntityType(EntityType<?> var1);

        public Builder experienceLevel(Range<Integer> var1);

        public Builder addGameMode(Supplier<? extends GameMode> var1);

        public Builder addGameMode(GameMode var1);

        public Builder addNotGameMode(Supplier<? extends GameMode> var1);

        public Builder addNotGameMode(GameMode var1);

        public Builder anyTeam();

        public Builder noTeam();

        public Builder addTeam(Team var1);

        public Builder addNotTeam(Team var1);

        public Builder addName(String var1);

        public Builder addNotName(String var1);

        public Builder addObjective(Objective var1, Range<Integer> var2);

        public Builder addTag(String var1);

        public Builder addNotTag(String var1);

        public Builder pitch(Range<Double> var1);

        public Builder yaw(Range<Double> var1);

        public Builder addFilter(Predicate<Entity> var1);

        public Selector build() throws IllegalStateException;
    }
}

