/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.volume.game.PrimitiveGameVolume;
import org.spongepowered.math.vector.Vector3i;

public interface BlockReaderAwareMatcher<T> {
    public static BlockReaderAwareMatcher<BlockState> allBlocks() {
        return (state, volume, position) -> true;
    }

    public static BlockReaderAwareMatcher<BlockState> forBlock(BlockState filter) {
        return (state, volume, position) -> state == filter;
    }

    public static BlockReaderAwareMatcher<BlockState> forBlock(BlockType type) {
        Objects.requireNonNull(type, "BlockType cannot be null");
        return (state, volume, position) -> state != null && state.type() == type;
    }

    public boolean test(@Nullable T var1, PrimitiveGameVolume var2, Vector3i var3);
}

