/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityPredicates;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface EntityVolume
extends Volume {
    public Collection<? extends Player> players();

    public Optional<Entity> entity(UUID var1);

    public Collection<? extends Entity> entities();

    default public Collection<? extends Entity> entities(AABB box) {
        Objects.requireNonNull(box);
        return this.entities(box, (? super Entity entity) -> true);
    }

    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> var1, AABB var2, @Nullable Predicate<? super T> var3);

    public Collection<? extends Entity> entities(AABB var1, Predicate<? super Entity> var2);

    default public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box) {
        return this.entities(entityClass, box, EntityPredicates.NO_SPECTATOR);
    }

    default public Optional<? extends Player> nearestPlayer(double x, double y, double z, double distance, @Nullable Predicate<? super Entity> predicate) {
        Player nearest = null;
        double closest = -1.0;
        for (Player player : this.players()) {
            if (predicate != null && !predicate.test(player)) continue;
            double dist = player.position().distanceSquared(x, y, z);
            if (!(closest < 0.0) && !(dist < distance * distance) || closest != -1.0 && !(dist < distance)) continue;
            nearest = player;
            closest = dist;
        }
        return Optional.ofNullable(nearest);
    }

    default public Collection<? extends Entity> nearbyEntities(Vector3d location, double distance) {
        Objects.requireNonNull(location);
        if (distance <= 0.0) {
            throw new IllegalArgumentException("Distance must be a positive number!");
        }
        return this.entities(AABB.of(location.x() - distance, location.y() - distance, location.z() - distance, location.x() + distance, location.y() + distance, location.z() + distance), (? super Entity entity) -> entity.location().position().distanceSquared(location) <= distance * distance);
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends EntityVolume,
    Streamable<U>,
    UnmodifiableVolume,
    BlockVolume.Unmodifiable<U> {
    }

    public static interface Immutable
    extends Unmodifiable<Immutable>,
    ImmutableVolume {
    }

    public static interface EntityVolumeFactory {
        public Mutable empty(Vector3i var1, Vector3i var2);
    }

    public static interface Mutable
    extends Modifiable<Mutable> {
        public static Mutable empty(Vector3i min, Vector3i max) {
            return Sponge.game().factoryProvider().provide(EntityVolumeFactory.class).empty(min, max);
        }
    }

    public static interface Modifiable<M extends Modifiable<M>>
    extends Streamable<M>,
    MutableVolume {
        public <E extends Entity> E createEntity(EntityType<E> var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

        default public <E extends Entity> E createEntity(Supplier<EntityType<E>> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
            return this.createEntity(type.get(), position);
        }

        default public <E extends Entity> E createEntity(EntityType<E> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
            Objects.requireNonNull(position, "position");
            return this.createEntity(type, position.toDouble());
        }

        default public <E extends Entity> E createEntity(Supplier<EntityType<E>> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
            return this.createEntity(type.get(), position);
        }

        public <E extends Entity> E createEntityNaturally(EntityType<E> var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

        default public <E extends Entity> E createEntityNaturally(Supplier<EntityType<E>> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
            return this.createEntityNaturally(type.get(), position);
        }

        default public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
            Objects.requireNonNull(position, "position");
            return this.createEntityNaturally(type, position.toDouble());
        }

        default public <E extends Entity> E createEntityNaturally(Supplier<EntityType<E>> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
            return this.createEntityNaturally(type.get(), position);
        }

        public Optional<Entity> createEntity(DataContainer var1);

        public Optional<Entity> createEntity(DataContainer var1, Vector3d var2);

        public boolean spawnEntity(Entity var1);

        public Collection<Entity> spawnEntities(Iterable<? extends Entity> var1);
    }

    public static interface Streamable<E extends Streamable<E>>
    extends EntityVolume {
        public VolumeStream<E, Entity> entityStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }
}

