/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.SpongeAdvancementTemplate;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.SpongeCriterionUtil;

public final class SpongeAdvancementBuilder
extends AbstractResourceKeyedBuilder<AdvancementTemplate, AdvancementTemplate.Builder>
implements AdvancementTemplate.Builder.RootStep {
    private @Nullable ResourceLocation parent;
    private AdvancementCriterion criterion;
    private @Nullable DisplayInfo displayInfo;
    private @Nullable ResourceLocation backgroundPath;
    private DataPack<AdvancementTemplate> pack = DataPacks.ADVANCEMENT;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    @Override
    public AdvancementTemplate.Builder parent(@Nullable AdvancementTemplate parent) {
        return this.parent(parent.key());
    }

    @Override
    public AdvancementTemplate.Builder parent(@Nullable ResourceKey parent) {
        this.parent = (ResourceLocation)parent;
        this.backgroundPath = null;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder.RootStep root() {
        this.parent = null;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder background(ResourceKey backgroundPath) {
        this.backgroundPath = (ResourceLocation)backgroundPath;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder criterion(AdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        this.criterion = criterion;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    @Override
    public AdvancementTemplate.Builder reset() {
        this.criterion = AdvancementCriterion.empty();
        this.displayInfo = null;
        this.parent = null;
        this.backgroundPath = null;
        this.pack = DataPacks.ADVANCEMENT;
        return this;
    }

    @Override
    public AdvancementTemplate build0() {
        Tuple<Map<String, Criterion<?>>, List<List<String>>> result = SpongeCriterionUtil.toVanillaCriteriaData(this.criterion);
        AdvancementRewards rewards = AdvancementRewards.EMPTY;
        Optional<net.minecraft.advancements.DisplayInfo> displayInfo = Optional.ofNullable(this.displayInfo).map(di -> new net.minecraft.advancements.DisplayInfo(ItemStackUtil.fromSnapshotToNative(di.icon()), SpongeAdventure.asVanilla(di.title()), SpongeAdventure.asVanilla(di.description()), Optional.ofNullable(this.backgroundPath), (AdvancementType)di.type(), di.doesShowToast(), di.doesAnnounceToChat(), di.isHidden()));
        Advancement advancement = new Advancement(Optional.ofNullable(this.parent), displayInfo, rewards, result.first(), new AdvancementRequirements(result.second()), false);
        ((AdvancementBridge)advancement).bridge$setCriterion(this.criterion);
        return new SpongeAdvancementTemplate(this.key, advancement, this.pack);
    }
}

