/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement.criterion;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.common.util.Preconditions;

public abstract class AbstractCriterionBuilder<T extends AdvancementCriterion, B extends AdvancementCriterion.BaseBuilder<T, B>>
implements AdvancementCriterion.BaseBuilder<T, B> {
    protected @Nullable FilteredTrigger<?> trigger;
    protected @Nullable String name;
    protected @Nullable Trigger<?> type;

    @Override
    public <C extends FilteredTriggerConfiguration> B trigger(Trigger<C> type, FilteredTrigger<C> trigger) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(trigger, "trigger");
        this.trigger = trigger;
        this.type = type;
        return (B)this;
    }

    @Override
    public B name(String name) {
        Objects.requireNonNull(name, "name");
        this.name = name;
        return (B)this;
    }

    @Override
    public T build() {
        Preconditions.checkState(this.name != null, "The name must be set");
        return this.build0();
    }

    abstract T build0();

    @Override
    public B from(T value) {
        this.trigger = value.trigger().orElse(null);
        this.name = value.name();
        return (B)this;
    }

    @Override
    public B reset() {
        this.trigger = null;
        this.name = null;
        return (B)this;
    }
}

