/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.core;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.configurate.serialize.ScalarSerializer;

public final class TokenHoldingString {
    static final ScalarSerializer<TokenHoldingString> SERIALIZER = new Serializer();
    private static final Pattern TOKEN_MATCH = Pattern.compile("\\$\\{([^}]+)}");
    private static final Map<String, Function<PluginPlatform, String>> TOKENS = new HashMap<String, Function<PluginPlatform, String>>();
    private final String plainValue;
    private final String parsedValue;

    private static String sanitizePath(String path) {
        return path.replace("\\", "\\\\");
    }

    public static TokenHoldingString of(String input) {
        return new TokenHoldingString(input, TokenHoldingString.parsePlaceholders(input));
    }

    private static void register(String token, Function<PluginPlatform, String> getter) {
        TOKENS.put(token.toLowerCase(Locale.ROOT), getter);
    }

    private static String parsePlaceholders(String input) {
        Matcher matcher = TOKEN_MATCH.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        StringBuffer result = new StringBuffer();
        do {
            String token;
            Function<PluginPlatform, String> replacer;
            String replaced = (replacer = TOKENS.get((token = matcher.group(1)).toLowerCase())) == null ? "" : replacer.apply((PluginPlatform)AppLaunch.pluginPlatform());
            matcher.appendReplacement(result, replaced == null ? "" : TokenHoldingString.sanitizePath(replaced));
        } while (matcher.find());
        matcher.appendTail(result);
        return result.toString();
    }

    private TokenHoldingString(String plain, String parsed) {
        this.plainValue = plain;
        this.parsedValue = parsed;
    }

    public String getPlain() {
        return this.plainValue;
    }

    public String getParsed() {
        return this.parsedValue;
    }

    static {
        TokenHoldingString.register("CANONICAL_GAME_DIR", platform -> platform.baseDirectory().toString());
        TokenHoldingString.register("CANONICAL_MODS_DIR", platform -> platform.pluginDirectories().get(0).toString());
    }

    static final class Serializer
    extends ScalarSerializer<TokenHoldingString> {
        Serializer() {
            super(TokenHoldingString.class);
        }

        @Override
        public TokenHoldingString deserialize(Type type, Object obj) {
            return TokenHoldingString.of(obj.toString());
        }

        @Override
        public Object serialize(TokenHoldingString item, Predicate<Class<?>> typeSupported) {
            return item.getPlain();
        }
    }
}

