/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.flag;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.parameter.flag.SpongeFlag;
import org.spongepowered.common.util.Preconditions;

public final class SpongeFlagBuilder
implements Flag.Builder {
    private @Nullable Parameter parameter;
    private final Set<String> aliases = new HashSet<String>();
    private final Set<String> keys = new HashSet<String>();
    private Predicate<CommandCause> requirement = cause -> true;

    @Override
    public @NonNull Flag.Builder alias(@NonNull String alias) {
        Objects.requireNonNull(alias, "The alias cannot be null.");
        if (alias.startsWith("-")) {
            throw new IllegalArgumentException("Flag '" + alias + "' cannot start with a dash");
        }
        if (alias.contains(" ")) {
            throw new IllegalArgumentException("Flag '" + alias + "' cannot contain whitespace");
        }
        if (alias.length() == 1) {
            this.aliases.add("-" + alias.toLowerCase(Locale.ROOT));
        } else {
            this.aliases.add("--" + alias.toLowerCase(Locale.ROOT));
        }
        this.keys.add(alias.toLowerCase(Locale.ROOT));
        return this;
    }

    @Override
    public @NonNull Flag.Builder aliases(@NonNull Iterable<String> aliases) {
        for (String alias : aliases) {
            this.alias(alias);
        }
        return this;
    }

    @Override
    public @NonNull Flag.Builder setPermission(@Nullable String permission) {
        if (permission == null) {
            return this.setRequirement(null);
        }
        return this.setRequirement(cause -> cause.hasPermission(permission));
    }

    @Override
    public @NonNull Flag.Builder setRequirement(@Nullable Predicate<CommandCause> requirement) {
        this.requirement = requirement == null ? cause -> true : requirement;
        return this;
    }

    @Override
    public @NonNull Flag.Builder setParameter(@Nullable Parameter parameter) {
        this.parameter = parameter;
        return this;
    }

    @Override
    public @NonNull Flag build() throws IllegalStateException {
        Preconditions.checkState(!this.aliases.isEmpty(), "Aliases cannot be empty.");
        return new SpongeFlag((Set<String>)ImmutableSet.copyOf(this.keys), (Set<String>)ImmutableSet.copyOf(this.aliases), this.requirement, this.parameter);
    }

    @Override
    public @NonNull Flag.Builder reset() {
        this.aliases.clear();
        this.requirement = cause -> true;
        this.parameter = null;
        return this;
    }
}

